/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashSet;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class EnumDefImpl
extends FieldDefImpl
implements EnumDef {
    private static final long serialVersionUID = 1L;
    private final String[] values;
    private final String name;
    private transient int encodingLen;

    EnumDefImpl(String name, String[] values, String description) {
        super(FieldDef.Type.ENUM, description);
        this.name = name;
        this.values = values;
        this.validate();
        this.init();
    }

    EnumDefImpl(String name, String[] values) {
        this(name, values, null);
    }

    private EnumDefImpl(EnumDefImpl impl) {
        super(impl);
        this.name = impl.name;
        this.values = Arrays.copyOf(impl.values, impl.values.length);
        this.encodingLen = impl.encodingLen;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void init() {
        this.encodingLen = SortableString.encodingLength(this.values.length);
        if (this.encodingLen < 2) {
            this.encodingLen = 2;
        }
    }

    private EnumDefImpl() {
        this.name = null;
        this.values = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getValues() {
        return this.values;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public EnumDef asEnum() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof EnumDefImpl) {
            EnumDefImpl otherDef = (EnumDefImpl)other;
            return Arrays.equals(this.values, otherDef.getValues());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.values);
    }

    @Override
    protected void toJson(ObjectNode node) {
        super.toJson(node);
        node.put("enum_name", this.name);
        ArrayNode enumVals = node.putArray("symbols");
        for (String val : this.getValues()) {
            enumVals.add(val);
        }
    }

    @Override
    public EnumDefImpl clone() {
        return new EnumDefImpl(this);
    }

    @Override
    public EnumValueImpl createEnum(String value) {
        return new EnumValueImpl(this, value);
    }

    @Override
    public JsonNode mapTypeToAvro(ObjectNode node) {
        if (node == null) {
            node = JsonUtils.createObjectNode();
        }
        node.put("name", this.name);
        node.put("type", "enum");
        ArrayNode enumVals = node.putArray("symbols");
        for (String val : this.getValues()) {
            enumVals.add(val);
        }
        return node;
    }

    private void validate() {
        if (this.values == null || this.values.length < 1) {
            throw new IllegalArgumentException("Enumerations requires one or more values");
        }
        if (this.name == null) {
            throw new IllegalArgumentException("Enumerations require a name");
        }
        HashSet<String> set = new HashSet<String>();
        for (String value : this.values) {
            this.validateStringValue(value);
            if (set.contains(value)) {
                throw new IllegalArgumentException("Duplicated enumeration value: " + value);
            }
            set.add(value);
        }
    }

    private void validateStringValue(String value) {
        if (value.matches("^.*[^a-zA-Z0-9_].*$")) {
            throw new IllegalArgumentException("Enumeration string names may contain only alphanumeric values plus the characters \"_\"");
        }
        if (value.charAt(0) >= '0' && value.charAt(0) <= '9') {
            throw new IllegalArgumentException("Enumeration string names must start with an alphabetic character or the character \"_\"");
        }
    }

    boolean isValidIndex(int index) {
        return index < this.values.length;
    }

    EnumValueImpl createEnum(int index) {
        if (!this.isValidIndex(index)) {
            throw new IllegalArgumentException("Index is out of range for enumeration: " + index);
        }
        return new EnumValueImpl(this, this.values[index]);
    }

    int indexOf(String enumValue) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!enumValue.equals(this.values[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Value is not valid for the enumeration: " + enumValue);
    }

    int getEncodingLen() {
        return this.encodingLen;
    }

    boolean valuesEqual(EnumDefImpl other) {
        return Arrays.equals(this.values, other.getValues());
    }

    void validateValue(String value) {
        for (String val : this.values) {
            if (!val.equals(value)) continue;
            return;
        }
        throw new IllegalArgumentException("Invalid enumeration value '" + value + "', must be in values: " + Arrays.toString(this.values));
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isTextual()) {
            throw new IllegalArgumentException("Default value for type ENUM is not a string");
        }
        return this.createEnum(node.asText());
    }
}

