/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryValueImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FixedBinaryDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

@Persistent(version=1)
class FixedBinaryDefImpl
extends FieldDefImpl
implements FixedBinaryDef {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int size;

    FixedBinaryDefImpl(String name, int size, String description) {
        super(FieldDef.Type.FIXED_BINARY, description);
        this.name = name;
        this.size = size;
        this.validate();
    }

    FixedBinaryDefImpl(String name, int size) {
        this(name, size, null);
    }

    private FixedBinaryDefImpl() {
        super(FieldDef.Type.BINARY);
        this.size = 0;
        this.name = null;
    }

    private FixedBinaryDefImpl(FixedBinaryDefImpl impl) {
        super(impl);
        this.name = impl.name;
        this.size = impl.size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFixedBinary() {
        return true;
    }

    @Override
    public FixedBinaryDef asFixedBinary() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FixedBinaryDefImpl) {
            FixedBinaryDefImpl otherDef = (FixedBinaryDefImpl)other;
            return this.size == otherDef.size && this.name.equals(otherDef.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.size + this.name.hashCode();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        node.put("size", this.size);
        node.put("name", this.name);
    }

    @Override
    public FixedBinaryDefImpl clone() {
        return new FixedBinaryDefImpl(this);
    }

    @Override
    public FixedBinaryValueImpl createFixedBinary(byte[] value) {
        this.validateValue(value);
        return new FixedBinaryValueImpl(value, this);
    }

    @Override
    public JsonNode mapTypeToAvro(ObjectNode node) {
        if (node == null) {
            node = JsonUtils.createObjectNode();
        }
        node.put("type", "fixed");
        node.put("name", this.name);
        node.put("size", this.size);
        return node;
    }

    private void validate() {
        if (this.size <= 0) {
            throw new IllegalArgumentException("FixedBinaryDef size limit must be a positive integer");
        }
        if (this.name == null) {
            throw new IllegalArgumentException("FixedBinaryDef requires a name");
        }
    }

    private void validateValue(byte[] value) {
        if (value.length != this.size) {
            throw new IllegalArgumentException("Invalid length for FixedBinary array, it must be " + this.size + ", and it is " + value.length);
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isBinary()) {
            throw new IllegalArgumentException("Default value for type FIXED_BINARY is not binary");
        }
        try {
            byte[] bytes = node.getBinaryValue();
            if (bytes.length != this.size) {
                throw new IllegalArgumentException("Illegal size for FIXED_BINARY: " + bytes.length + ", must be " + this.size);
            }
            return this.createFixedBinary(bytes);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException creating fixed binary value: " + ioe, ioe);
        }
    }

    @Override
    public FixedBinaryValueImpl fromString(String base64) {
        TextNode n = new TextNode(base64);
        try {
            return this.createFixedBinary(n.getBinaryValue());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Cannot create binary from string: " + base64, ioe);
        }
    }
}

