/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Table;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class IndexImpl
implements Index,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final TableImpl table;
    private final List<String> fields;
    private IndexStatus status;
    private transient List<IndexField> indexFields;

    public IndexImpl(String name, TableImpl table, List<String> fields, String description) {
        this.name = name;
        this.table = table;
        this.fields = fields;
        this.description = description;
        this.status = IndexStatus.TRANSIENT;
        this.validate();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IndexKeyImpl createIndexKey() {
        return new IndexKeyImpl(this);
    }

    @Override
    public IndexKeyImpl createIndexKey(RecordValue value) {
        IndexKeyImpl key = new IndexKeyImpl(this);
        TableImpl.populateRecord(key, value);
        return key;
    }

    @Override
    public IndexKey createIndexKeyFromJson(String jsonInput, boolean exact) {
        return this.createIndexKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public IndexKey createIndexKeyFromJson(InputStream jsonInput, boolean exact) {
        IndexKeyImpl key = this.createIndexKey();
        this.table.createFromJson(key, jsonInput, exact);
        return key;
    }

    @Override
    public FieldRange createFieldRange(String fieldName) {
        IndexField field = new IndexField(fieldName);
        FieldDefImpl def = this.findIndexField(field);
        if (def == null) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        if (!this.containsField(field)) {
            throw new IllegalArgumentException("Field does not exist in index: " + fieldName);
        }
        return new FieldRange(fieldName, def);
    }

    int numFields() {
        return this.fields.size();
    }

    public boolean isKeyOnly() {
        for (String field : this.fields) {
            if (this.table.isKeyComponent(field)) continue;
            return false;
        }
        return true;
    }

    public boolean isMultiKey() {
        for (IndexField field : this.getIndexFields()) {
            if (!field.hasArray()) continue;
            return true;
        }
        return false;
    }

    public IndexStatus getStatus() {
        return this.status;
    }

    public void setStatus(IndexStatus status) {
        this.status = status;
    }

    public TableImpl getTableImpl() {
        return this.table;
    }

    List<String> getFieldsInternal() {
        return this.fields;
    }

    List<IndexField> getIndexFields() {
        if (this.indexFields == null) {
            this.initIndexFields();
        }
        return this.indexFields;
    }

    private synchronized void initIndexFields() {
        if (this.indexFields == null) {
            ArrayList<IndexField> list = new ArrayList<IndexField>(this.fields.size());
            for (String field : this.fields) {
                IndexField indexField = new IndexField(field);
                this.containsArray(indexField);
                list.add(indexField);
            }
            this.indexFields = list;
        }
    }

    private String findArray() {
        for (IndexField field : this.getIndexFields()) {
            if (!field.hasArray()) continue;
            return field.getArrayPath();
        }
        return null;
    }

    private boolean containsArray(IndexField field) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = field.iterator();
        FieldDefImpl def = field.getFirstDef();
        if (def.isArray()) {
            field.setArrayPath(iter.next());
            return true;
        }
        sb.append(iter.next()).append(".");
        while (iter.hasNext()) {
            String current = iter.next();
            sb.append(current);
            def = def.findField(current);
            assert (def != null);
            if (def.isArray()) {
                field.setArrayPath(sb.toString());
                return true;
            }
            sb.append(".");
        }
        return false;
    }

    public byte[] extractIndexKey(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            return this.serializeIndexKey(row, false, 0);
        }
        return null;
    }

    public List<byte[]> extractIndexKeys(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            String arrayField = this.findArray();
            assert (arrayField != null);
            ArrayValueImpl fv = (ArrayValueImpl)row.getComplex(new IndexField(arrayField));
            if (fv == null || fv.isNull()) {
                return null;
            }
            int arraySize = fv.size();
            ArrayList<byte[]> returnList = new ArrayList<byte[]>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                byte[] serKey = this.serializeIndexKey(row, false, i);
                if (serKey == null) continue;
                returnList.add(serKey);
            }
            return returnList;
        }
        return null;
    }

    public void toJsonNode(ObjectNode node) {
        node.put("name", this.name);
        node.put("description", this.description);
        ArrayNode fieldArray = node.putArray("fields");
        for (String s : this.fields) {
            fieldArray.add(s);
        }
    }

    private void validate() {
        TableImpl.validateComponent(this.name, false);
        boolean hasArray = false;
        if (this.fields.isEmpty()) {
            throw new IllegalCommandException("Index requires at least one field");
        }
        assert (this.indexFields == null);
        this.indexFields = new ArrayList<IndexField>(this.fields.size());
        for (String field : this.fields) {
            if (field == null || field.length() == 0) {
                throw new IllegalCommandException("Invalid (null or empty) index field name");
            }
            IndexField ifield = new IndexField(field);
            FieldDefImpl def = this.findIndexField(ifield);
            if (def == null) {
                throw new IllegalCommandException("Index field not found in table: " + field);
            }
            if (!def.isValidIndexField()) {
                throw new IllegalCommandException("Field type is not valid in an index: " + (Object)((Object)def.getType()) + ", field name: " + field);
            }
            boolean fieldHasArray = this.containsArray(ifield);
            if (fieldHasArray) {
                if (hasArray) {
                    throw new IllegalCommandException("Indexes may contain only one array field");
                }
                hasArray = true;
            }
            if (this.indexFields.contains(ifield)) {
                throw new IllegalCommandException("Index already contains the field: " + field);
            }
            this.indexFields.add(ifield);
        }
        assert (this.fields.size() == this.indexFields.size());
        this.table.checkForDuplicateIndex(this);
    }

    public String toString() {
        return "Index[" + this.name + ", " + this.table.getId() + ", " + (Object)((Object)this.status) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] serializeIndexKey(RecordValueImpl record, boolean allowPartial, int arrayIndex) {
        TupleOutput out = null;
        out = new TupleOutput();
        for (IndexField field : this.getIndexFields()) {
            FieldValue val = record.findField(field.iterator(), arrayIndex);
            FieldDefImpl def = this.findIndexField(field);
            assert (def != null);
            if (val != null && def.getType() == FieldDef.Type.ARRAY) {
                def = (FieldDefImpl)((ArrayDefImpl)def).getElement();
                val = ((ArrayValueImpl)val).get(arrayIndex);
            }
            if (val == null) {
                if (allowPartial) break;
                byte[] byArray = null;
                return byArray;
            }
            if (val.isNull()) {
                byte[] byArray = null;
                return byArray;
            }
            switch (def.getType()) {
                case INTEGER: {
                    out.writeSortedPackedInt(val.asInteger().get());
                    break;
                }
                case STRING: {
                    out.writeString(val.asString().get());
                    break;
                }
                case LONG: {
                    out.writeSortedPackedLong(val.asLong().get());
                    break;
                }
                case DOUBLE: {
                    out.writeSortedDouble(val.asDouble().get());
                    break;
                }
                case FLOAT: {
                    out.writeSortedFloat(val.asFloat().get());
                    break;
                }
                case ENUM: {
                    out.writeSortedPackedInt(val.asEnum().getIndex());
                    break;
                }
                case ARRAY: 
                case BINARY: 
                case BOOLEAN: 
                case FIXED_BINARY: 
                case MAP: 
                case RECORD: {
                    throw new IllegalStateException("Type not supported in indexes: " + (Object)((Object)def.getType()));
                }
            }
        }
        byte[] byArray = out.size() != 0 ? out.toByteArray() : null;
        return byArray;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public byte[] serializeIndexKey(IndexKeyImpl record) {
        return this.serializeIndexKey(record, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexKeyImpl rowFromIndexKey(byte[] data, boolean partialOK) {
        IndexKeyImpl ikey = this.createIndexKey();
        TupleInput input = null;
        try {
            input = new TupleInput(data);
            for (IndexField field : this.getIndexFields()) {
                if (input.available() <= 0) break;
                FieldDefImpl def = this.findIndexField(field);
                assert (def != null);
                switch (def.getType()) {
                    case INTEGER: {
                        ikey.putComplex(field, FieldDef.Type.INTEGER, (Object)input.readSortedPackedInt());
                        break;
                    }
                    case STRING: {
                        ikey.putComplex(field, FieldDef.Type.STRING, (Object)input.readString());
                        break;
                    }
                    case LONG: {
                        ikey.putComplex(field, FieldDef.Type.LONG, (Object)input.readSortedPackedLong());
                        break;
                    }
                    case DOUBLE: {
                        ikey.putComplex(field, FieldDef.Type.DOUBLE, (Object)input.readSortedDouble());
                        break;
                    }
                    case FLOAT: {
                        ikey.putComplex(field, FieldDef.Type.FLOAT, (Object)Float.valueOf(input.readSortedFloat()));
                        break;
                    }
                    case ENUM: {
                        ikey.putComplex(field, FieldDef.Type.ENUM, (Object)input.readSortedPackedInt());
                        break;
                    }
                    case ARRAY: {
                        ikey.putComplex(field, FieldDef.Type.ARRAY, null);
                        ArrayValueImpl array = (ArrayValueImpl)ikey.getComplex(field);
                        this.readArrayElement(array, input);
                        break;
                    }
                    case BINARY: 
                    case BOOLEAN: 
                    case FIXED_BINARY: 
                    case MAP: 
                    case RECORD: {
                        throw new IllegalStateException("Type not supported in indexes: " + (Object)((Object)def.getType()));
                    }
                }
            }
            if (!partialOK && ikey.numValues() != this.fields.size()) {
                throw new IllegalStateException("Missing fields from index data for index " + this.getName() + ", expected " + this.fields.size() + ", received " + ikey.numValues());
            }
            IndexKeyImpl indexKeyImpl = ikey;
            return indexKeyImpl;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void readArrayElement(ArrayValueImpl array, TupleInput input) {
        switch (array.getDefinition().getElement().getType()) {
            case INTEGER: {
                array.add(input.readSortedPackedInt());
                break;
            }
            case STRING: {
                array.add(input.readString());
                break;
            }
            case LONG: {
                array.add(input.readSortedPackedLong());
                break;
            }
            case DOUBLE: {
                array.add(input.readSortedDouble());
                break;
            }
            case FLOAT: {
                array.add(input.readSortedFloat());
                break;
            }
            case ENUM: {
                array.addEnum(input.readSortedPackedInt());
                break;
            }
            default: {
                throw new IllegalStateException("Type not supported in indexes: ");
            }
        }
    }

    boolean containsField(IndexField indexField) {
        for (IndexField iField : this.getIndexFields()) {
            if (!iField.equals(indexField)) continue;
            return true;
        }
        return false;
    }

    boolean containsField(String fieldName) {
        String fname = fieldName.toLowerCase();
        for (IndexField indexField : this.getIndexFields()) {
            if (!(indexField.isComplex() ? indexField.getFieldName().contains(fname) : indexField.getFieldName().equals(fname))) continue;
            return true;
        }
        return false;
    }

    FieldDefImpl findIndexField(IndexField field) {
        Iterator<String> iter = field.iterator();
        FieldDefImpl def = (FieldDefImpl)this.table.getField(iter.next());
        if (def == null || !field.isComplex()) {
            return def;
        }
        assert (iter.hasNext());
        return def.findField(iter);
    }

    IndexField createIndexField(String fieldName) {
        return new IndexField(fieldName);
    }

    class IndexField {
        private final String fieldName;
        private final List<String> fieldComponents;
        private final boolean isComplex;
        private String arrayPath;

        private IndexField(String field) {
            this.fieldName = field.toLowerCase();
            this.fieldComponents = this.parseComplexFieldName(this.fieldName);
            this.isComplex = this.fieldComponents.size() > 1;
        }

        final boolean isComplex() {
            return this.isComplex;
        }

        final String getFieldName() {
            return this.fieldName;
        }

        final List<String> getComponents() {
            return this.fieldComponents;
        }

        Iterator<String> iterator() {
            return this.fieldComponents.iterator();
        }

        private boolean hasArray() {
            return this.arrayPath != null;
        }

        private String getArrayPath() {
            return this.arrayPath;
        }

        private void setArrayPath(String path) {
            this.arrayPath = path;
        }

        private FieldDefImpl getFirstDef() {
            return (FieldDefImpl)IndexImpl.this.table.getField(this.fieldComponents.get(0));
        }

        public String toString() {
            return this.fieldName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IndexField) {
                IndexField other = (IndexField)obj;
                if (this.getComponents().size() == other.getComponents().size()) {
                    Iterator<String> it = this.iterator();
                    Iterator<String> otherIt = other.iterator();
                    while (it.hasNext()) {
                        if (it.next().equals(otherIt.next())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (String s : this.fieldComponents) {
                hash += s.hashCode();
            }
            return hash;
        }

        private List<String> parseComplexFieldName(String fname) {
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            for (char ch : fname.toCharArray()) {
                if (ch == '.') {
                    if (sb.length() == 0) {
                        throw new IllegalArgumentException("Malformed field name: " + fname);
                    }
                    list.add(sb.toString());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(ch);
            }
            if (sb.length() > 0) {
                list.add(sb.toString());
            }
            return list;
        }
    }

    public static enum IndexStatus {
        TRANSIENT{

            @Override
            public boolean isTransient() {
                return true;
            }
        }
        ,
        POPULATING{

            @Override
            public boolean isPopulating() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isTransient() {
            return false;
        }

        public boolean isPopulating() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

