/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.LongValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.LongNode;

@Persistent(version=1)
class LongValueImpl
extends FieldValueImpl
implements LongValue {
    private static final long serialVersionUID = 1L;
    private final long value;

    LongValueImpl(long value) {
        this.value = value;
    }

    LongValueImpl(String keyValue) {
        this.value = SortableString.longFromSortable(keyValue);
    }

    private LongValueImpl() {
        this.value = 0L;
    }

    @Override
    public long get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.LONG;
    }

    @Override
    public LongValueImpl clone() {
        return new LongValueImpl(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof LongValueImpl) {
            return this.value == ((LongValueImpl)other).get();
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof LongValueImpl) {
            return Long.valueOf(this.value).compareTo(((LongValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an LongValue");
    }

    @Override
    public String formatForKey(FieldDef field) {
        int len = field != null ? ((LongDefImpl)field).getEncodingLength() : 0;
        return SortableString.toSortable(this.value, len);
    }

    @Override
    public FieldValueImpl getNextValue() {
        if (this.value == Long.MAX_VALUE) {
            return null;
        }
        return new LongValueImpl(this.value + 1L);
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return new LongValueImpl(Long.MIN_VALUE);
    }

    @Override
    public JsonNode toJsonNode() {
        return new LongNode(this.value);
    }

    @Override
    public LongValue asLong() {
        return this;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

