/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.Iterator;
import java.util.Map;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordDef;
import oracle.kv.table.Row;
import oracle.kv.table.Table;

public class RowImpl
extends RecordValueImpl
implements Row {
    private static final long serialVersionUID = 1L;
    protected final TableImpl table;
    private Version version;
    private int tableVersion;

    RowImpl(RecordDef field, TableImpl table) {
        super(field);
        assert (field != null && table != null);
        this.table = table;
        this.version = null;
        this.tableVersion = 0;
    }

    RowImpl(RecordDef field, TableImpl table, Map<String, FieldValue> fieldMap) {
        super(field, fieldMap);
        assert (field != null && table != null);
        this.table = table;
        this.version = null;
        this.tableVersion = 0;
    }

    RowImpl(RowImpl other) {
        super(other);
        this.table = other.table;
        this.version = other.version;
        this.tableVersion = other.tableVersion;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public boolean isRow() {
        return true;
    }

    @Override
    public Row asRow() {
        return this;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public int getTableVersion() {
        return this.tableVersion;
    }

    void setTableVersion(int tableVersion) {
        this.tableVersion = tableVersion;
    }

    void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public RowImpl clone() {
        return new RowImpl(this);
    }

    @Override
    public PrimaryKey createPrimaryKey() {
        RowImpl impl = this.clone();
        impl.removeValueFields();
        return new PrimaryKeyImpl(this.getDefinition(), this.table, impl.valueMap);
    }

    public int getDataSize() {
        return this.table.getDataSize(this);
    }

    public int getKeySize() {
        return this.table.getKeySize(this);
    }

    Key getPrimaryKey(boolean allowPartial) {
        return this.table.createKey(this, allowPartial);
    }

    TableImpl getTableImpl() {
        return this.table;
    }

    RowImpl rowFromValueVersion(ValueVersion vv, boolean keyOnly) {
        RowImpl row = new RowImpl(this);
        if (keyOnly) {
            this.removeValueFields();
        }
        return this.table.rowFromValueVersion(vv, row);
    }

    void copyKeyFields(RowImpl row) {
        for (String keyField : this.table.getPrimaryKey()) {
            FieldValue val = row.get(keyField);
            if (val == null) continue;
            this.put(keyField, val);
        }
    }

    Value createValue() {
        return this.table.createValue(this);
    }

    @Override
    FieldDefImpl validateNameAndType(String name, FieldDef.Type type) {
        return super.validateNameAndType(name, type);
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof RowImpl) {
            RowImpl otherImpl = (RowImpl)other;
            if (this.table.getId() == otherImpl.table.getId()) {
                return super.compareTo(otherImpl);
            }
            return RowImpl.compare(this.table.getId(), otherImpl.table.getId());
        }
        throw new IllegalArgumentException("Cannot compare Row to another type");
    }

    private static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof RowImpl) {
            return this.table.nameEquals(((RowImpl)other).table);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.table.getFullName().hashCode();
    }

    private void removeValueFields() {
        if (this.table.hasValueFields()) {
            Iterator entries = this.valueMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (this.table.isKeyComponent((String)entry.getKey())) continue;
                entries.remove();
            }
        }
    }
}

