/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.StringValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.TextNode;

@Persistent(version=1)
class StringValueImpl
extends FieldValueImpl
implements StringValue {
    private static final long serialVersionUID = 1L;
    private final String value;
    private static final char MIN_VALUE_CHAR = '\u0001';

    StringValueImpl(String value) {
        this.value = value;
    }

    private StringValueImpl() {
        this.value = null;
    }

    public static StringValueImpl create(String value) {
        return new StringValueImpl(value);
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.STRING;
    }

    @Override
    public StringValueImpl clone() {
        return new StringValueImpl(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof StringValueImpl) {
            return this.value.equals(((StringValueImpl)other).get());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof StringValueImpl) {
            return this.value.compareTo(((StringValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an StringValue");
    }

    @Override
    public String formatForKey(FieldDef field) {
        return this.value;
    }

    @Override
    public FieldValueImpl getNextValue() {
        return new StringValueImpl(this.value + '\u0001');
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        throw new IllegalStateException("StringValue.getMinimumValue should never be called");
    }

    @Override
    public JsonNode toJsonNode() {
        return new TextNode(this.value);
    }

    @Override
    public StringValue asString() {
        return this;
    }

    @Override
    public boolean isString() {
        return true;
    }

    public String toString() {
        return this.value;
    }
}

