/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.util.PackedInteger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.ReturnRowImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TableVersionException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.ReturnRow;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableImpl
implements Table,
MetadataInfo,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private long id;
    private final TableImpl parent;
    private final TreeMap<String, Index> indexes;
    private final List<String> primaryKey;
    private final List<String> shardKey;
    private final String description;
    private final Map<String, Table> children;
    private final ArrayList<FieldMap> versions;
    private TableStatus status;
    private final boolean r2compat;
    private final int schemaId;
    private transient Schema schema;
    private transient int version;
    private transient int numKeyComponents;
    private transient String idString;
    public static final String SEPARATOR = ".";
    private static final int MAX_ID_LENGTH = 32;
    private static final int MAX_NAME_LENGTH = 64;
    private static final String SEPARATOR_REGEX = "\\.";
    static final String VALID_NAME_CHAR_REGEX = "^.*[^a-zA-Z0-9_].*$";
    private static final int INITIAL_TABLE_VERSION = 1;

    private TableImpl(String name, TableImpl parent, List<String> primaryKey, List<String> shardKey, FieldMap fields, boolean r2compat, int schemaId, String description, boolean validate) {
        this.name = name;
        this.parent = parent;
        this.description = description;
        this.primaryKey = primaryKey;
        this.shardKey = shardKey;
        this.status = TableStatus.READY;
        this.r2compat = r2compat;
        this.schemaId = schemaId;
        this.version = 1;
        this.children = new TreeMap<String, Table>(FieldComparator.instance);
        this.indexes = new TreeMap(FieldComparator.instance);
        this.versions = new ArrayList();
        this.versions.add(fields);
        if (validate) {
            this.validate();
            this.setSchema(true);
        }
        this.setIdString();
    }

    private TableImpl(TableImpl t) {
        this.name = t.name;
        this.id = t.id;
        this.version = t.version;
        this.description = t.description;
        this.parent = t.parent;
        this.primaryKey = t.primaryKey;
        this.shardKey = t.shardKey;
        this.status = t.status;
        this.r2compat = t.r2compat;
        this.schemaId = t.schemaId;
        this.children = new TreeMap<String, Table>(FieldComparator.instance);
        for (Table table : t.children.values()) {
            this.children.put(table.getName(), ((TableImpl)table).clone());
        }
        this.versions = new ArrayList<FieldMap>(t.versions);
        this.indexes = new TreeMap<String, Index>((SortedMap<String, Index>)t.indexes);
        this.setSchema(true);
        this.setIdString();
    }

    static TableImpl createTable(String name, Table parent, List<String> primaryKey, List<String> shardKey, FieldMap fields, boolean r2compat, int schemaId, String description, boolean validate) {
        return new TableImpl(name, (TableImpl)parent, primaryKey, shardKey, fields, r2compat, schemaId, description, validate);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setSchema(false);
        this.getTableVersion();
        this.setIdString();
    }

    @Override
    public TableImpl clone() {
        return new TableImpl(this);
    }

    @Override
    public Table getChildTable(String tableName) {
        return this.children.get(tableName);
    }

    @Override
    public boolean childTableExists(String tableName) {
        return this.children.containsKey(tableName);
    }

    @Override
    public Table getVersion(int version1) {
        if (this.versions.size() < version1 || version1 < 0) {
            throw new IllegalArgumentException("Table version " + version1 + " does not exist for table " + this.getFullName());
        }
        TableImpl newTable = this.clone();
        newTable.version = version1;
        newTable.setSchema(true);
        return newTable;
    }

    @Override
    public Map<String, Table> getChildTables() {
        return Collections.unmodifiableMap(this.children);
    }

    @Override
    public Table getParent() {
        return this.parent;
    }

    public String getAvroSchema(boolean pretty) {
        return this.generateAvroSchema(this.version, pretty);
    }

    @Override
    public int getTableVersion() {
        if (this.version == 0) {
            this.version = this.versions.size();
        }
        return this.version;
    }

    @Override
    public Index getIndex(String indexName) {
        return this.indexes.get(indexName);
    }

    @Override
    public Map<String, Index> getIndexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        this.getTableNameInternal(sb);
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getIdString() {
        return this.idString;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.getFieldOrder(this.version));
    }

    @Override
    public FieldDef getField(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, false);
        if (fme != null) {
            return fme.getField();
        }
        return null;
    }

    @Override
    public boolean isNullable(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.isNullable();
    }

    @Override
    public FieldValue getDefaultValue(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.getDefaultValue();
    }

    @Override
    public List<String> getPrimaryKey() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    @Override
    public List<String> getShardKey() {
        return Collections.unmodifiableList(this.shardKey);
    }

    List<String> getPrimaryKeyInternal() {
        return this.primaryKey;
    }

    List<String> getShardKeyInternal() {
        return this.shardKey;
    }

    @Override
    public RowImpl createRow() {
        return new RowImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
    }

    @Override
    public RowImpl createRow(RecordValue value) {
        RowImpl row = new RowImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
        TableImpl.populateRecord(row, value);
        return row;
    }

    @Override
    public RowImpl createRowWithDefaults() {
        RecordDefImpl def = new RecordDefImpl(this.getName(), this.getFieldMap());
        RowImpl row = new RowImpl((RecordDef)def, this);
        for (Map.Entry<String, FieldMapEntry> entry : this.getFieldMap().getFields().entrySet()) {
            row.put(entry.getKey(), entry.getValue().getDefaultValue());
        }
        return row;
    }

    @Override
    public PrimaryKeyImpl createPrimaryKey() {
        return new PrimaryKeyImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
    }

    @Override
    public PrimaryKeyImpl createPrimaryKey(RecordValue value) {
        PrimaryKeyImpl key = new PrimaryKeyImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
        TableImpl.populateRecord(key, value);
        return key;
    }

    @Override
    public ReturnRowImpl createReturnRow(ReturnRow.Choice returnChoice) {
        return new ReturnRowImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this, returnChoice);
    }

    @Override
    public Row createRowFromJson(String jsonInput, boolean exact) {
        return this.createRowFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public Row createRowFromJson(InputStream jsonInput, boolean exact) {
        RowImpl row = this.createRow();
        this.createFromJson(row, jsonInput, exact);
        return row;
    }

    @Override
    public PrimaryKeyImpl createPrimaryKeyFromJson(String jsonInput, boolean exact) {
        return this.createPrimaryKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public PrimaryKeyImpl createPrimaryKeyFromJson(InputStream jsonInput, boolean exact) {
        PrimaryKeyImpl key = this.createPrimaryKey();
        this.createFromJson(key, jsonInput, exact);
        return key;
    }

    @Override
    public FieldRange createFieldRange(String fieldName) {
        FieldDef def = this.getField(fieldName);
        if (def == null) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        if (!this.primaryKey.contains(fieldName)) {
            throw new IllegalArgumentException("Field does not exist in primary key: " + fieldName);
        }
        return new FieldRange(fieldName, def);
    }

    public boolean isAncestor(Table ancestor) {
        String fullName = ancestor.getFullName();
        for (Table parentTable = this.getParent(); parentTable != null; parentTable = parentTable.getParent()) {
            if (!fullName.equals(parentTable.getFullName())) continue;
            return true;
        }
        return false;
    }

    public TableImpl getTopLevelTable() {
        if (this.parent != null) {
            return this.parent.getTopLevelTable();
        }
        return this;
    }

    void createFromJson(RecordValueImpl row, InputStream jsonInput, boolean exact) {
        JsonParser jp = null;
        try {
            jp = JsonUtils.createJsonParser(jsonInput);
            row.addJsonFields(jp, exact);
            row.validate();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof Table) {
            TableImpl otherDef = (TableImpl)other;
            if (this.getName().equals(otherDef.getName()) && this.getId() == otherDef.getId()) {
                if (this.getParent() != null ? !this.getParent().equals(otherDef.getParent()) : otherDef.getParent() != null) {
                    return false;
                }
                return this.versionsEqual(otherDef) && this.getFieldMap().equals(otherDef.getFieldMap());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getFullName().hashCode() + this.versions.size() + this.getFieldMap().hashCode();
    }

    boolean nameEquals(TableImpl other) {
        return this.getFullName().equals(other.getFullName());
    }

    private boolean versionsEqual(TableImpl other) {
        int thisVersion = this.version == 0 ? this.versions.size() : this.version;
        int otherVersion = other.version == 0 ? other.versions.size() : other.version;
        return thisVersion == otherVersion;
    }

    @Override
    public int numTableVersions() {
        return this.versions.size();
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public boolean isR2compatible() {
        return this.r2compat;
    }

    public int getSchemaId() {
        return this.schemaId;
    }

    void setId(long id) {
        this.id = id;
        this.setIdString();
    }

    private void setIdString() {
        this.idString = this.id == 0L || this.r2compat ? this.name : TableImpl.createIdString(this.id);
    }

    static String createIdString(long id) {
        int encodingLength = SortableString.encodingLength(id);
        return SortableString.toSortable(id, encodingLength);
    }

    public FieldMap getFieldMap() {
        return this.getFieldMap(this.version);
    }

    public int getNumKeyComponents() {
        if (this.numKeyComponents == 0) {
            this.calculateNumKeys();
        }
        return this.numKeyComponents;
    }

    private synchronized void calculateNumKeys() {
        if (this.numKeyComponents == 0) {
            int num = this.primaryKey.size() + 1;
            TableImpl t = this;
            while (t.parent != null) {
                ++num;
                t = t.parent;
            }
            this.numKeyComponents = num;
        }
    }

    public TableStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(TableStatus newStatus) {
        if (this.status != newStatus && this.status.isDeleting()) {
            throw new IllegalStateException("Table is being deleted, cannot change status to " + (Object)((Object)newStatus));
        }
        this.status = newStatus;
    }

    Map<String, Table> getMutableChildTables() {
        return this.children;
    }

    FieldMapEntry getFieldMapEntry(String fieldName, boolean mustExist) {
        FieldMap fieldMap = this.getFieldMap();
        FieldMapEntry fme = fieldMap.getFieldMapEntry(fieldName);
        if (fme != null) {
            return fme;
        }
        if (mustExist) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        return null;
    }

    List<String> getMutablePrimaryKey() {
        return this.primaryKey;
    }

    public int getPrimaryKeySize() {
        return this.primaryKey.size();
    }

    Map<String, Index> getMutableIndexes() {
        return this.indexes;
    }

    public String getParentName() {
        if (this.parent != null) {
            return this.parent.getFullName();
        }
        return null;
    }

    public Key createKey(Row row, boolean allowPartial) {
        this.setTableVersion(row);
        return TableKey.createKey(this, row, allowPartial).getKey();
    }

    RowImpl createRowFromKeyBytes(byte[] keyBytes) {
        return this.createFromKeyBytes(keyBytes, false);
    }

    PrimaryKeyImpl createPrimaryKeyFromKeyBytes(byte[] keyBytes) {
        return (PrimaryKeyImpl)this.createFromKeyBytes(keyBytes, true);
    }

    private RowImpl createFromKeyBytes(byte[] keyBytes, boolean createPrimaryKey) {
        TableImpl targetTable;
        Key.BinaryKeyIterator keyIter = this.createBinaryKeyIterator(keyBytes);
        if (keyIter != null && (targetTable = this.findTargetTable(keyIter)) != null) {
            RowImpl row = createPrimaryKey ? targetTable.createPrimaryKey() : targetTable.createRow();
            keyIter.reset();
            if (this.initRowFromKeyBytes(row, keyIter, targetTable)) {
                return row;
            }
        }
        return null;
    }

    RowImpl createRowFromBytes(byte[] keyBytes, byte[] valueBytes, boolean keyOnly) {
        RowImpl fullKey = this.createRowFromKeyBytes(keyBytes);
        if (fullKey != null) {
            if (keyOnly || valueBytes.length == 0) {
                return fullKey;
            }
            Value.Format format = Value.Format.fromFirstByte(valueBytes[0]);
            if (format == Value.Format.TABLE || format == Value.Format.AVRO && this.r2compat) {
                int offset = 1;
                if (format == Value.Format.AVRO && this.r2compat) {
                    offset = PackedInteger.getReadSortedIntLength(valueBytes, 0);
                }
                if (this.initRowFromByteValue(fullKey, valueBytes, format, offset)) {
                    return fullKey;
                }
            }
        }
        return null;
    }

    private boolean initRowFromKeyBytes(RowImpl row, Key.BinaryKeyIterator keyIter, TableImpl targetTable) {
        Iterator<String> pkIter = targetTable.getPrimaryKey().iterator();
        return targetTable.fillInKeyForTable(row, keyIter, pkIter);
    }

    int getDataSize(Row row) {
        Value value = this.createValue(row);
        return value.getValue().length + 1;
    }

    int getKeySize(Row row) {
        return this.createKey(row, true).toByteArray().length;
    }

    Value createValue(Row row) {
        this.setSchema(false);
        if (this.schema == null) {
            return Value.EMPTY_VALUE;
        }
        boolean isAvro = this.schemaId != 0 && this.getTableVersion() == 1;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (!isAvro) {
            int writeVersion = this.getTableVersion();
            outputStream.write(writeVersion);
            this.setTableVersion(row);
        } else {
            int size = PackedInteger.getWriteSortedIntLength(this.schemaId);
            byte[] buf = new byte[size];
            PackedInteger.writeSortedInt(buf, 0, this.schemaId);
            outputStream.write(buf, 0, size);
            ((RowImpl)row).setTableVersion(1);
        }
        BinaryEncoder e = JsonUtils.getEncoderFactory().binaryEncoder((OutputStream)outputStream, null);
        GenericDatumWriter w = new GenericDatumWriter(this.schema);
        GenericData.Record r = new GenericData.Record(this.schema);
        for (Map.Entry<String, FieldMapEntry> entry : this.getFields(this.version).entrySet()) {
            FieldMapEntry fme = entry.getValue();
            String fieldName = entry.getKey();
            if (this.isKeyComponent(fieldName)) continue;
            FieldValueImpl fv = (FieldValueImpl)row.get(fieldName);
            if (fv == null) {
                fv = fme.getDefaultValue();
            }
            if (fv.isNull()) {
                if (!fme.isNullable()) {
                    throw new IllegalCommandException("The field can not be null: " + fieldName);
                }
                r.put(fieldName, null);
                continue;
            }
            r.put(fieldName, fv.toAvroValue(this.schema.getField(fieldName).schema()));
        }
        try {
            w.write((Object)r, (Encoder)e);
            e.flush();
        }
        catch (IOException ioe) {
            throw new IllegalCommandException("Failed to serialize Avro: " + ioe);
        }
        return Value.internalCreateValue(outputStream.toByteArray(), isAvro ? Value.Format.AVRO : Value.Format.TABLE);
    }

    private boolean initRowFromByteValue(RowImpl row, byte[] data, Value.Format format, int offset) {
        GenericRecord result = null;
        if (data.length >= offset + 1) {
            Schema writerSchema = this.schema;
            byte tableVersion = format == Value.Format.AVRO ? (byte)1 : data[offset];
            row.setTableVersion(tableVersion);
            if (tableVersion != this.getTableVersion() && tableVersion > this.numTableVersions()) {
                throw new TableVersionException(tableVersion);
            }
            try {
                if (tableVersion != this.getTableVersion()) {
                    String schemaString = this.generateAvroSchema(tableVersion, false);
                    writerSchema = new Schema.Parser().parse(schemaString);
                }
                if (format != Value.Format.AVRO || offset == 0) {
                    ++offset;
                }
                GenericDatumReader reader = new GenericDatumReader(writerSchema, this.schema);
                BinaryDecoder decoder = JsonUtils.getDecoderFactory().binaryDecoder(data, offset, data.length - offset, null);
                result = (GenericRecord)reader.read(null, (Decoder)decoder);
            }
            catch (Exception e) {
                return false;
            }
        }
        for (Map.Entry<String, FieldMapEntry> entry : this.getFields(this.version).entrySet()) {
            Object o;
            FieldMapEntry fme = entry.getValue();
            String fieldName = entry.getKey();
            if (this.isKeyComponent(fieldName)) continue;
            Object object = o = result != null ? result.get(fieldName) : null;
            if (o != null) {
                Schema fieldSchema = this.schema.getField(fieldName).schema();
                row.put(fieldName, FieldValueImpl.fromAvroValue(fme.getField(), o, fieldSchema));
                continue;
            }
            if (fme.isNullable()) {
                row.putNull(fieldName);
                continue;
            }
            row.put(fieldName, fme.getDefaultValue());
        }
        return true;
    }

    RowImpl rowFromValueVersion(ValueVersion vv, RowImpl row) {
        assert (row != null);
        row.setVersion(vv.getVersion());
        byte[] data = vv.getValue().getValue();
        Value.Format format = vv.getValue().getFormat();
        if (!(format == Value.Format.TABLE || format == Value.Format.AVRO && this.r2compat || data.length <= 1)) {
            return null;
        }
        if (this.setSchema(false) == null) {
            return row;
        }
        if (this.initRowFromByteValue(row, data, format, 0)) {
            return row;
        }
        return null;
    }

    void evolve(FieldMap newFields) {
        if (this.version == 255) {
            throw new IllegalCommandException("Can't evolve the table any further; too many versions");
        }
        this.validateEvolution(newFields);
        if (this.version != 0 && this.version != this.versions.size()) {
            throw new IllegalCommandException("Table evolution must be performed on the latest version");
        }
        this.versions.add(newFields);
        if (this.version != 0) {
            ++this.version;
        }
        this.setSchema(true);
    }

    void validateFieldAddition(String fieldName, FieldMapEntry field) {
        if (this.getField(fieldName) != null) {
            throw new IllegalArgumentException("Cannot add field, " + fieldName + ", it already exists");
        }
        for (FieldMap map : this.versions) {
            FieldMapEntry entry = map.getFieldMapEntry(fieldName);
            if (entry == null || entry.getField().equals(field.getField())) continue;
            throw new IllegalArgumentException("Cannot add field, " + fieldName + ". An older version " + "of the table contains this name and the types do " + "not match, is: " + (Object)((Object)field.getField().getType()) + ", was: " + (Object)((Object)entry.getField().getType()));
        }
    }

    boolean hasValueFields() {
        return this.schema != null;
    }

    private void validateEvolution(FieldMap newFields) {
        for (String fieldName : this.primaryKey) {
            FieldDef newDef;
            FieldDef oldDef = this.getField(fieldName);
            if (oldDef.equals(newDef = newFields.get(fieldName))) continue;
            throw new IllegalCommandException("Evolution cannot modify the primary key");
        }
        for (Index index : this.indexes.values()) {
            for (String field : index.getFields()) {
                FieldDef newDef = newFields.get(field);
                if (newDef == null) {
                    throw new IllegalCommandException("Evolution cannot remove indexed fields");
                }
                if (newDef.equals(this.getField(field))) continue;
                throw new IllegalCommandException("Evolution cannot modify indexed fields");
            }
        }
    }

    public String toJsonString(boolean pretty) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode o = JsonUtils.createObjectNode();
        o.put("type", "table");
        o.put("name", this.getName());
        if (this.r2compat) {
            o.put("r2compat", this.r2compat);
        }
        o.put("description", this.description);
        if (this.parent != null) {
            o.put("parent", this.parent.getName());
        }
        ArrayNode key = o.putArray("shardKey");
        for (String fieldName : this.shardKey) {
            key.add(fieldName);
        }
        key = o.putArray("primaryKey");
        for (String fieldName : this.primaryKey) {
            key.add(fieldName);
        }
        if (this.children.size() != 0) {
            ArrayNode childArray = o.putArray("children");
            for (Map.Entry<String, Table> entry : this.children.entrySet()) {
                childArray.add(entry.getKey());
            }
        }
        this.getFieldMap().putFields(o);
        if (this.indexes.size() != 0) {
            ArrayNode indexArray = o.putArray("indexes");
            for (Map.Entry<String, Object> entry : this.indexes.entrySet()) {
                IndexImpl impl = (IndexImpl)entry.getValue();
                impl.toJsonNode(indexArray.addObject());
            }
        }
        try {
            return writer.writeValueAsString((Object)o);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }

    public void addIndex(Index index) {
        this.checkForDuplicateIndex(index);
        this.indexes.put(index.getName(), index);
    }

    public Index removeIndex(String indexName) {
        return this.indexes.remove(indexName);
    }

    Key.BinaryKeyIterator createBinaryKeyIterator(byte[] key) {
        Key.BinaryKeyIterator keyIter = new Key.BinaryKeyIterator(key);
        if (this.parent != null) {
            for (int i = 0; i < this.parent.getNumKeyComponents(); ++i) {
                if (keyIter.atEndOfKey()) {
                    return null;
                }
                keyIter.skip();
            }
        }
        if (keyIter.atEndOfKey()) {
            return null;
        }
        String tableId = keyIter.next();
        if (this.getIdString().equals(tableId)) {
            return keyIter;
        }
        return null;
    }

    public TableImpl findTargetTable(byte[] key) {
        Key.BinaryKeyIterator iter = this.createBinaryKeyIterator(key);
        if (iter != null) {
            return this.findTargetTable(iter);
        }
        return null;
    }

    TableImpl findTargetTable(Key.BinaryKeyIterator keyIter) {
        int numPrimaryKeyComponentsToSkip = this.primaryKey.size();
        if (this.parent != null) {
            numPrimaryKeyComponentsToSkip -= this.parent.primaryKey.size();
        }
        for (int i = 0; i < numPrimaryKeyComponentsToSkip; ++i) {
            if (keyIter.atEndOfKey()) {
                return null;
            }
            keyIter.skip();
        }
        if (keyIter.atEndOfKey()) {
            return this;
        }
        String childId = keyIter.next();
        for (Table table : this.children.values()) {
            if (!((TableImpl)table).getIdString().equals(childId)) continue;
            return ((TableImpl)table).findTargetTable(keyIter);
        }
        return null;
    }

    boolean isKeyComponent(String fieldName) {
        for (String component : this.primaryKey) {
            if (!fieldName.equals(component)) continue;
            return true;
        }
        return false;
    }

    boolean isIndexKeyComponent(String fieldName) {
        for (Index index : this.indexes.values()) {
            if (!((IndexImpl)index).containsField(fieldName)) continue;
            return true;
        }
        return false;
    }

    private Map<String, FieldMapEntry> getFields(int version1) {
        return this.getFieldMap(version1).getFields();
    }

    private List<String> getFieldOrder(int version1) {
        return this.getFieldMap(version1).getFieldOrder();
    }

    private FieldMap getFieldMap(int version1) {
        if (this.versions.size() < version1 || version1 < 0) {
            throw new IllegalCommandException("Table version " + version1 + " does not exist for table " + this.name);
        }
        int versionToGet = version1 == 0 ? this.versions.size() : version1;
        return this.versions.get(versionToGet - 1);
    }

    private void throwMissingState(String state) {
        throw new IllegalCommandException("Table is missing state required for construction: " + state);
    }

    private void validate() {
        FieldMap fields;
        if (this.primaryKey.isEmpty()) {
            this.throwMissingState("primary key");
        }
        if (this.name == null) {
            this.throwMissingState("table name");
        }
        if ((fields = this.getFieldMap(0)) == null || fields.isEmpty()) {
            this.throwMissingState("no fields defined");
        }
        if (this.parent != null && this.primaryKey.size() <= this.parent.primaryKey.size()) {
            throw new IllegalCommandException("Child table needs a primary key component");
        }
        if (this.shardKey.size() > this.primaryKey.size()) {
            throw new IllegalCommandException("Shard key must be a subset of the primary key");
        }
        for (int i = 0; i < this.shardKey.size(); ++i) {
            String pkField = this.primaryKey.get(i);
            if (pkField != null && pkField.equals(this.shardKey.get(i))) continue;
            throw new IllegalCommandException("Shard key must be a subset of the primary key");
        }
        for (String pkField : this.primaryKey) {
            FieldDef field = this.getField(pkField);
            if (field == null) {
                throw new IllegalCommandException("Primary key field is not a valid field: " + pkField);
            }
            if (field.isValidKeyField()) continue;
            throw new IllegalCommandException("Field type cannot be part of a primary key: " + (Object)((Object)field.getType()) + ", field name: " + pkField);
        }
    }

    private Schema setSchema(boolean flush) {
        if (this.schema == null || flush) {
            String schemaString = this.generateAvroSchema(this.version, true);
            this.schema = schemaString == null ? null : new Schema.Parser().parse(schemaString);
        }
        return this.schema;
    }

    private void getTableNameInternal(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.getTableNameInternal(sb);
            sb.append(SEPARATOR);
        }
        sb.append(this.name);
    }

    private boolean fillInKeyForTable(Row keyRecord, Key.BinaryKeyIterator keyIter, Iterator<String> pkIter) {
        if (this.parent != null && !this.parent.fillInKeyForTable(keyRecord, keyIter, pkIter)) {
            return false;
        }
        assert (!keyIter.atEndOfKey());
        this.setTableVersion(keyRecord);
        String keyComponent = keyIter.next();
        if (!keyComponent.equals(this.getIdString())) {
            return false;
        }
        String lastKeyField = this.primaryKey.get(this.primaryKey.size() - 1);
        while (pkIter.hasNext()) {
            assert (!keyIter.atEndOfKey());
            String field = pkIter.next();
            String val = keyIter.next();
            try {
                keyRecord.put(field, this.createFromKey(val, this.getField(field)));
            }
            catch (Exception e) {
                return false;
            }
            if (!field.equals(lastKeyField)) continue;
            break;
        }
        return true;
    }

    private FieldValue createFromKey(String value, FieldDef field) {
        switch (field.getType()) {
            case INTEGER: {
                return new IntegerValueImpl(value);
            }
            case LONG: {
                return new LongValueImpl(value);
            }
            case STRING: {
                return new StringValueImpl(value);
            }
            case DOUBLE: {
                return new DoubleValueImpl(value);
            }
            case FLOAT: {
                return new FloatValueImpl(value);
            }
            case ENUM: {
                return EnumValueImpl.createFromKey((EnumDef)field, value);
            }
        }
        throw new IllegalCommandException("Type is not allowed in a key: " + (Object)((Object)field.getType()));
    }

    private String generateAvroSchema(int versionToUse, boolean pretty) {
        boolean hasSchema = false;
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode sch = JsonUtils.createObjectNode();
        sch.put("type", "record");
        sch.put("name", this.getName());
        ArrayNode array = sch.putArray("fields");
        Map<String, FieldMapEntry> mapToUse = this.getFields(versionToUse);
        for (String fname : this.getFieldOrder(versionToUse)) {
            FieldMapEntry fme = mapToUse.get(fname);
            if (this.isKeyComponent(fname)) continue;
            hasSchema = true;
            ObjectNode fnode = array.addObject();
            fnode.put("name", fname);
            fme.createAvroTypeAndDefault(fnode);
            if (fme.getField().getDescription() == null) continue;
            fnode.put("doc", fme.getField().getDescription());
        }
        if (!hasSchema) {
            return null;
        }
        try {
            return writer.writeValueAsString((Object)sch);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("IO Error writing Avro schema string", ioe);
        }
    }

    public String toString() {
        return "Table[" + this.name + ", " + this.indexes.size() + ", " + this.children.size() + ", " + (Object)((Object)this.status) + "]";
    }

    public static void validateComponent(String component, boolean isId) {
        if (component.matches(VALID_NAME_CHAR_REGEX)) {
            throw new IllegalCommandException("Table, index and field names may contain only alphanumeric values plus the characters \"_\"");
        }
        if (component.charAt(0) < 'A' || component.charAt(0) > 'z' || component.charAt(0) == '_') {
            throw new IllegalCommandException("Table, index and field names must start with an alphabetic character");
        }
        if (isId && component.length() > 32) {
            throw new IllegalCommandException("Table names must be less than or equal to 32 characters");
        }
        if (!isId && component.length() > 64) {
            throw new IllegalCommandException("Field and index names must be less than or equal to 64 characters");
        }
    }

    static String[] parseFullName(String fullName) {
        return fullName.split(SEPARATOR_REGEX);
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    public int getSourceSeqNum() {
        return this.versions.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    static void populateRecord(RecordValueImpl record, RecordValue value) {
        for (String s : record.getFields()) {
            FieldValue v = value.get(s);
            if (v == null) continue;
            record.put(s, v);
        }
        record.validate();
    }

    void checkForDuplicateIndex(Index index) {
        for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
            if (!index.getFields().equals(entry.getValue().getFields())) continue;
            throw new IllegalCommandException("Index is a duplicate of an existing index with another name.  Existing index name: " + entry.getKey() + ", new index name: " + index.getName());
        }
    }

    private void setTableVersion(Row row) {
        ((RowImpl)row).setTableVersion(this.getTableVersion());
    }

    public static enum TableStatus {
        DELETING{

            @Override
            public boolean isDeleting() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isDeleting() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

