/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import oracle.kv.Depth;
import oracle.kv.ParallelScanIterator;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.TableIterate;
import oracle.kv.impl.api.ops.TableKeysIterate;
import oracle.kv.impl.api.parallelscan.ParallelScan;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

class TableScan {
    private TableScan() {
    }

    static TableIterator<Row> createTableIterator(final TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (iterateOptions != null) {
            config.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
            config.setMaxResultsBatches(iterateOptions.getMaxResultsBatches());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions));
        if (key.getMajorKeyComplete()) {
            return TableScan.createPartitionRowIterator(apiImpl, params, key, targetTables);
        }
        return new TableIteratorWrapper<Row>(new ParallelScan.ParallelScanIteratorImpl<Row>(apiImpl.getStore(), config, params){

            @Override
            protected TableIterate generateGetterOp(byte[] resumeKey) {
                return new TableIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey);
            }

            @Override
            protected ParallelScan.ConvertResultsReturnValue convertResults(Result result) {
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                ParallelScan.ResultsQueueEntry[] results = TableScan.convertTableRowResults(apiImpl, byteKeyResults, key.getTable(), targetTables);
                if (results == null) {
                    return new ParallelScan.ConvertResultsReturnValue(0, null);
                }
                byte[] resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                this.putResult(results);
                return new ParallelScan.ConvertResultsReturnValue(results.length, resumeKey);
            }
        });
    }

    static TableIterator<PrimaryKey> createTableKeysIterator(TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (iterateOptions != null) {
            config.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
            config.setMaxResultsBatches(iterateOptions.getMaxResultsBatches());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions));
        if (key.getMajorKeyComplete()) {
            return TableScan.createPartitionKeyIterator(apiImpl, params, key, targetTables);
        }
        return new TableIteratorWrapper<PrimaryKey>(new ParallelScan.ParallelScanIteratorImpl<PrimaryKey>(apiImpl.getStore(), config, params){

            @Override
            protected TableKeysIterate generateGetterOp(byte[] resumeKey) {
                return new TableKeysIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey);
            }

            @Override
            protected ParallelScan.ConvertResultsReturnValue convertResults(Result result) {
                List<byte[]> byteKeyResults = result.getKeyList();
                ParallelScan.ResultsQueueEntry[] results = TableScan.convertTableKeyResults(byteKeyResults, key.getTable(), targetTables);
                if (results == null) {
                    return new ParallelScan.ConvertResultsReturnValue(0, null);
                }
                byte[] resumeKey = byteKeyResults.get(byteKeyResults.size() - 1);
                this.putResult(results);
                return new ParallelScan.ConvertResultsReturnValue(results.length, resumeKey);
            }
        });
    }

    private static ParallelScan.ResultsQueueEntry<Row>[] convertTableRowResults(TableAPIImpl apiImpl, List<ResultKeyValueVersion> byteKeyResults, TableImpl table, TargetTables targetTables) {
        int cnt = byteKeyResults.size();
        if (cnt == 0) {
            return null;
        }
        ParallelScan.ResultsQueueEntry[] rowResults = new ParallelScan.ResultsQueueEntry[cnt];
        int actualCount = 0;
        for (ResultKeyValueVersion entry : byteKeyResults) {
            ValueVersion vv;
            RowImpl row;
            RowImpl fullKey;
            if (targetTables.hasAncestorTables()) {
                table = table.getTopLevelTable();
            }
            if ((fullKey = table.createRowFromKeyBytes(entry.getKeyBytes())) == null || (row = apiImpl.getRowFromValueVersion(vv = new ValueVersion(entry.getValue(), entry.getVersion()), fullKey, false)) == null) continue;
            rowResults[actualCount++] = new ParallelScan.ResultsQueueEntry<RowImpl>(row, null);
        }
        if (actualCount < cnt) {
            return Arrays.copyOf(rowResults, actualCount);
        }
        return rowResults;
    }

    private static ParallelScan.ResultsQueueEntry<PrimaryKey>[] convertTableKeyResults(List<byte[]> byteKeyResults, TableImpl table, TargetTables targetTables) {
        int cnt = byteKeyResults.size();
        if (cnt == 0) {
            return null;
        }
        ParallelScan.ResultsQueueEntry[] keyResults = new ParallelScan.ResultsQueueEntry[cnt];
        int actualCount = 0;
        for (byte[] entry : byteKeyResults) {
            PrimaryKeyImpl pKey;
            if (targetTables.hasAncestorTables()) {
                table = table.getTopLevelTable();
            }
            if ((pKey = table.createPrimaryKeyFromKeyBytes(entry)) == null) continue;
            keyResults[actualCount++] = new ParallelScan.ResultsQueueEntry<PrimaryKeyImpl>(pKey, null);
        }
        if (actualCount < cnt) {
            return Arrays.copyOf(keyResults, actualCount);
        }
        return keyResults;
    }

    static TableIterator<Row> createPartitionRowIterator(final TableAPIImpl apiImpl, final StoreIteratorParams params, TableKey key, final TargetTables targetTables) {
        final KVStoreImpl store = apiImpl.getStore();
        byte[] parentKeyBytes = store.getKeySerializer().toByteArray(key.getKey());
        final PartitionId partitionId = store.getDispatcher().getPartitionId(parentKeyBytes);
        final TableImpl table = key.getTable();
        return new MultiGetIteratorWrapper<Row>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            @Override
            ParallelScan.ResultsQueueEntry<Row>[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                TableIterate op = new TableIterate(params, targetTables, true, this.resumeKey);
                Request req = store.makeReadRequest((InternalOperation)op, partitionId, params.getConsistency(), params.getTimeout(), params.getTimeoutUnit());
                Result result = store.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                if (byteKeyResults.isEmpty()) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                return TableScan.convertTableRowResults(apiImpl, byteKeyResults, table, targetTables);
            }
        };
    }

    static TableIterator<PrimaryKey> createPartitionKeyIterator(TableAPIImpl apiImpl, final StoreIteratorParams params, TableKey key, final TargetTables targetTables) {
        final KVStoreImpl store = apiImpl.getStore();
        byte[] parentKeyBytes = store.getKeySerializer().toByteArray(key.getKey());
        final PartitionId partitionId = store.getDispatcher().getPartitionId(parentKeyBytes);
        final TableImpl table = key.getTable();
        return new MultiGetIteratorWrapper<PrimaryKey>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            @Override
            ParallelScan.ResultsQueueEntry<PrimaryKey>[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                TableKeysIterate op = new TableKeysIterate(params, targetTables, true, this.resumeKey);
                Request req = store.makeReadRequest((InternalOperation)op, partitionId, params.getConsistency(), params.getTimeout(), params.getTimeoutUnit());
                Result result = store.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<byte[]> byteKeyResults = result.getKeyList();
                if (byteKeyResults.isEmpty()) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1);
                return TableScan.convertTableKeyResults(byteKeyResults, table, targetTables);
            }
        };
    }

    private static abstract class MultiGetIteratorWrapper<E>
    implements TableIterator<E> {
        private ParallelScan.ResultsQueueEntry<E>[] elements = null;
        private int nextElement = 0;

        private MultiGetIteratorWrapper() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.elements != null && this.nextElement < this.elements.length) {
                return true;
            }
            this.elements = this.getMoreElements();
            if (this.elements == null) {
                return false;
            }
            assert (this.elements.length > 0);
            this.nextElement = 0;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.nextElement++].getEntry();
        }

        abstract ParallelScan.ResultsQueueEntry<E>[] getMoreElements();

        @Override
        public void close() {
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }
    }

    private static class TableIteratorWrapper<K>
    implements TableIterator<K> {
        private final ParallelScanIterator<K> psi;

        private TableIteratorWrapper(ParallelScanIterator<K> psi) {
            this.psi = psi;
        }

        @Override
        public void close() {
            this.psi.close();
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return this.psi.getPartitionMetrics();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return this.psi.getShardMetrics();
        }

        @Override
        public K next() {
            return this.psi.next();
        }

        @Override
        public boolean hasNext() {
            return this.psi.hasNext();
        }

        @Override
        public void remove() {
            this.psi.remove();
        }
    }
}

