/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.fault;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultException;
import oracle.kv.impl.fault.SystemFaultException;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.test.TestStatus;

public abstract class ProcessFaultHandler {
    private final ProcessExitCode defaultExitCode;
    protected Logger logger;

    public ProcessFaultHandler(Logger logger, ProcessExitCode defaultExitCode) {
        this.logger = logger;
        this.defaultExitCode = defaultExitCode;
    }

    public ProcessExitCode getDefaultExitCode() {
        return this.defaultExitCode;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public <R, E extends Exception> R execute(Operation<R, E> operation) throws E {
        try {
            return operation.execute();
        }
        catch (RuntimeException re) {
            this.rethrow(re);
        }
        catch (Error e) {
            this.rethrow(e);
        }
        assert (false) : " code not reachable ";
        return null;
    }

    public <R> R execute(SimpleOperation<R> operation) {
        try {
            return operation.execute();
        }
        catch (RuntimeException re) {
            this.rethrow(re);
        }
        catch (Error e) {
            this.rethrow(e);
        }
        assert (false) : " code not reachable ";
        return null;
    }

    public <E extends Exception> void execute(Procedure<E> proc) throws E {
        try {
            proc.execute();
        }
        catch (RuntimeException re) {
            this.rethrow(re);
        }
        catch (Error e) {
            this.rethrow(e);
        }
    }

    public void execute(SimpleProcedure proc) {
        try {
            proc.execute();
        }
        catch (RuntimeException re) {
            this.rethrow(re);
        }
        catch (Error e) {
            this.rethrow(e);
        }
    }

    public void rethrow(Error error) {
        try {
            this.logger.log(Level.SEVERE, "Process exiting with error", error);
            throw error;
        }
        catch (Throwable throwable) {
            this.queueShutdown(error, ProcessExitCode.RESTART);
            throw throwable;
        }
    }

    public void rethrow(RuntimeException requestException) throws FaultException {
        ProcessExitCode exitCode;
        try {
            throw requestException;
        }
        catch (ProcessFaultException rfe) {
            exitCode = rfe.getExitCode();
        }
        catch (SystemFaultException sfe) {
            exitCode = sfe.getExitCode();
        }
        catch (OperationFaultException nfe) {
            exitCode = null;
        }
        catch (ClientAccessException cae) {
            exitCode = null;
        }
        catch (KVSecurityException kvse) {
            exitCode = null;
        }
        catch (SessionAccessException sae) {
            exitCode = null;
        }
        catch (RuntimeException re) {
            exitCode = this.getExitCode(re, this.defaultExitCode);
        }
        try {
            if (exitCode != null) {
                this.logger.log(Level.SEVERE, "Process exiting", requestException);
            } else if (this.logger.isLoggable(Level.FINE)) {
                String msg = "Process fault handler handled exception: " + requestException.getClass().getName() + " Exception message: " + requestException.getMessage();
                this.logger.fine(msg);
            }
            throw this.getThrowException(requestException);
        }
        catch (Throwable throwable) {
            if (exitCode != null) {
                this.queueShutdown(requestException, exitCode);
            }
            throw throwable;
        }
    }

    protected RuntimeException getThrowException(RuntimeException requestException) {
        if (requestException instanceof ClientAccessException) {
            throw (RuntimeException)requestException.getCause();
        }
        return requestException;
    }

    protected ProcessExitCode getExitCode(RuntimeException requestException, ProcessExitCode exitCode) {
        return this.defaultExitCode;
    }

    public final void queueShutdown(Throwable requestException, ProcessExitCode exitCode) {
        boolean immediateExit = true;
        if (requestException instanceof OutOfMemoryError) {
            exitCode = ProcessExitCode.RESTART_OOME;
        } else {
            try {
                this.queueShutdownInternal(requestException, exitCode);
                immediateExit = false;
            }
            catch (OutOfMemoryError ome) {
                exitCode = ProcessExitCode.RESTART_OOME;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "Process exiting", requestException);
                this.logger.log(Level.SEVERE, "Error during shutdown", t);
            }
        }
        if (immediateExit) {
            if (TestStatus.isActive()) {
                throw new IllegalStateException("exit", requestException);
            }
            System.exit(exitCode.getValue());
        }
    }

    protected abstract void queueShutdownInternal(Throwable var1, ProcessExitCode var2);

    public static interface SimpleProcedure {
        public void execute();
    }

    public static interface Procedure<E extends Exception> {
        public void execute() throws E;
    }

    public static interface SimpleOperation<R> {
        public R execute();
    }

    public static interface Operation<R, E extends Exception> {
        public R execute() throws E;
    }
}

