/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.RepNodeServiceFaultHandler;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultException;

public class RepNodeAdminFaultHandler
extends RepNodeServiceFaultHandler {
    private final AtomicInteger activeRequests = new AtomicInteger(0);

    public RepNodeAdminFaultHandler(RepNodeService repNodeService, Logger logger, ProcessExitCode defaultExitCode) {
        super(repNodeService, logger, defaultExitCode);
    }

    public int getActiveRequests() {
        return this.activeRequests.get();
    }

    protected RuntimeException getThrowException(RuntimeException fault) {
        if (fault instanceof ClientAccessException) {
            return ((ClientAccessException)fault).getCause();
        }
        return new RepNodeAdminFaultException(fault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, E extends Exception> R execute(ProcessFaultHandler.Operation<R, E> operation) throws E {
        this.activeRequests.incrementAndGet();
        try {
            Object object = super.execute(operation);
            return (R)object;
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R execute(ProcessFaultHandler.SimpleOperation<R> operation) {
        this.activeRequests.incrementAndGet();
        try {
            Object object = super.execute(operation);
            return (R)object;
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> void execute(ProcessFaultHandler.Procedure<E> proc) throws E {
        this.activeRequests.incrementAndGet();
        try {
            super.execute(proc);
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProcessFaultHandler.SimpleProcedure proc) {
        this.activeRequests.incrementAndGet();
        try {
            super.execute(proc);
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }
}

