/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.ssl;

import com.sleepycat.je.rep.net.SSLAuthenticator;
import com.sleepycat.je.rep.utilint.net.AliasKeyManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.security.ssl.SSLPatternAuthenticator;
import oracle.kv.impl.security.ssl.SSLPatternVerifier;
import oracle.kv.impl.security.ssl.SSLStdHostVerifier;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.ssl.SSLSocketPolicy;

public class SSLConfig {
    public static final String ENABLED_CIPHER_SUITES = "oracle.kv.ssl.ciphersuites";
    public static final String ENABLED_PROTOCOLS = "oracle.kv.ssl.protocols";
    public static final String CLIENT_AUTHENTICATOR = "oracle.kv.ssl.clientAuthenticator";
    public static final String SERVER_HOST_VERIFIER = "oracle.kv.ssl.hostnameVerifier";
    public static final String KEYSTORE_FILE = "oracle.kv.ssl.keyStore";
    public static final String KEYSTORE_TYPE = "oracle.kv.ssl.keyStoreType";
    public static final String KEYSTORE_ALIAS = "oracle.kv.ssl.keyStoreAlias";
    public static final String TRUSTSTORE_FILE = "oracle.kv.ssl.trustStore";
    public static final String TRUSTSTORE_TYPE = "oracle.kv.ssl.trustStoreType";
    private static final String X509_ALGO_NAME_PROPERTY = "oracle.kv.ssl.x509AlgoName";
    static final String JE_SSL_DN_AUTHENTICATOR_CLASS = "com.sleepycat.je.rep.utilint.net.SSLDNAuthenticator";
    static final String JE_SSL_DN_HOST_VERIFIER_CLASS = "com.sleepycat.je.rep.utilint.net.SSLDNHostVerifier";
    static final String JE_SSL_STD_HOST_VERIFIER_CLASS = "com.sleepycat.je.rep.utilint.net.SSLStdHostVerifier";
    private static final Set<String> allProps = new HashSet<String>();
    private static final String X509_ALGO_NAME;
    private final Properties props;
    private char[] keystorePassword = null;

    public SSLConfig(Properties sslProps) {
        this.props = sslProps;
        if (sslProps != null) {
            SSLConfig.validateProperties(sslProps);
        }
    }

    public static Properties validateProperties(Properties sslProps) throws IllegalArgumentException {
        File truststoreFile;
        Properties returnProps = new Properties();
        for (String propName : sslProps.stringPropertyNames()) {
            if (!propName.startsWith("oracle.kv.ssl.")) continue;
            if (!allProps.contains(propName)) {
                throw new IllegalArgumentException(propName + " is not a supported SSL property");
            }
            returnProps.setProperty(propName, sslProps.getProperty(propName));
        }
        String truststore = sslProps.getProperty(TRUSTSTORE_FILE);
        if (truststore != null && !(truststoreFile = new File(truststore)).isAbsolute()) {
            throw new IllegalArgumentException("The truststore file must be specified using an absolute pathname.");
        }
        return returnProps;
    }

    public synchronized void setKeystorePassword(char[] newKsPassword) {
        if (this.keystorePassword != null) {
            Arrays.fill(this.keystorePassword, ' ');
        }
        this.keystorePassword = (char[])(newKsPassword == null ? null : Arrays.copyOf(newKsPassword, newKsPassword.length));
    }

    public RMISocketPolicy makeClientSocketPolicy() throws IllegalStateException {
        try {
            return new SSLSocketPolicy(null, this.makeSSLControl(false));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while initializing SSL configuration", e);
        }
    }

    public SSLControl makeSSLControl(boolean isServer) throws KeyStoreException, IOException {
        String allowProtocols;
        SSLParameters sslParams = new SSLParameters();
        String allowCipherSuites = this.getProp(ENABLED_CIPHER_SUITES);
        if (allowCipherSuites != null) {
            String[] allowCipherSuiteList = this.trim(allowCipherSuites.split(","));
            sslParams.setCipherSuites(allowCipherSuiteList);
        }
        if ((allowProtocols = this.getProp(ENABLED_PROTOCOLS)) != null) {
            String[] allowProtocolList = this.trim(allowProtocols.split(","));
            sslParams.setProtocols(allowProtocolList);
        }
        SSLContext sslContext = this.makeSSLContext(this.makeAuth(), isServer);
        SSLAuthenticator authenticator = null;
        HostnameVerifier hostVerifier = null;
        if (isServer) {
            String clientIdentityAllowed = this.getProp(CLIENT_AUTHENTICATOR);
            if (clientIdentityAllowed != null) {
                authenticator = SSLConfig.makeAuthenticator(clientIdentityAllowed);
                sslParams.setNeedClientAuth(true);
            }
        } else {
            String serverIdentityAllowed = this.getProp(SERVER_HOST_VERIFIER);
            if (serverIdentityAllowed != null) {
                hostVerifier = this.makeHostVerifier(serverIdentityAllowed);
            }
        }
        sslParams = SSLConfig.filterSSLParameters(sslParams, sslContext);
        return new SSLControl(sslParams, sslContext, hostVerifier, authenticator);
    }

    private static SSLParameters filterSSLParameters(SSLParameters configParams, SSLContext filterContext) throws IllegalArgumentException {
        String[] suppProtocols;
        String[] suppCipherSuites;
        SSLParameters suppParams = filterContext.getSupportedSSLParameters();
        String[] configCipherSuites = configParams.getCipherSuites();
        if (configCipherSuites != null && (configCipherSuites = SSLConfig.filterConfig(configCipherSuites, suppCipherSuites = suppParams.getCipherSuites())).length == 0) {
            throw new IllegalArgumentException("None of the configured SSL cipher suites are supported by the environment.");
        }
        String[] configProtocols = configParams.getProtocols();
        if (configProtocols != null && (configProtocols = SSLConfig.filterConfig(configProtocols, suppProtocols = suppParams.getProtocols())).length == 0) {
            throw new IllegalArgumentException("None of the configured SSL protocols are supported by the environment.");
        }
        SSLParameters newParams = new SSLParameters(configCipherSuites, configProtocols);
        newParams.setNeedClientAuth(configParams.getNeedClientAuth());
        return newParams;
    }

    private static SSLAuthenticator makeAuthenticator(String peerIdentityAllowed) {
        InstanceInfo<SSLAuthenticator> authInfo = SSLConfig.makeAuthenticatorInfo(peerIdentityAllowed);
        return (SSLAuthenticator)authInfo.impl;
    }

    static InstanceInfo<SSLAuthenticator> makeAuthenticatorInfo(String peerIdentityAllowed) {
        String peerIdent = peerIdentityAllowed.trim();
        if (peerIdent.startsWith("dnmatch(") && peerIdent.endsWith(")")) {
            String match = peerIdent.substring("dnmatch(".length(), peerIdent.length() - 1);
            return new InstanceInfo<SSLAuthenticator>(new SSLPatternAuthenticator(match), JE_SSL_DN_AUTHENTICATOR_CLASS, match);
        }
        throw new IllegalArgumentException(peerIdent + " is not a valid server peer constraint.");
    }

    private HostnameVerifier makeHostVerifier(String peerIdentityAllowed) {
        InstanceInfo<HostnameVerifier> verInfo = SSLConfig.makeHostVerifierInfo(peerIdentityAllowed);
        return (HostnameVerifier)verInfo.impl;
    }

    static InstanceInfo<HostnameVerifier> makeHostVerifierInfo(String peerIdentityAllowed) {
        String peerIdent = peerIdentityAllowed.trim();
        if ("hostname".equals(peerIdent)) {
            return new InstanceInfo<HostnameVerifier>(new SSLStdHostVerifier(), JE_SSL_STD_HOST_VERIFIER_CLASS, null);
        }
        if (peerIdent.startsWith("dnmatch(") && peerIdent.endsWith(")")) {
            String match = peerIdent.substring("dnmatch(".length(), peerIdent.length() - 1);
            return new InstanceInfo<HostnameVerifier>(new SSLPatternVerifier(match), JE_SSL_DN_HOST_VERIFIER_CLASS, match);
        }
        throw new IllegalArgumentException(peerIdent + " is not a valid client peer constraint.");
    }

    private SSLAuthInfo makeAuth() {
        String tsType;
        String ts;
        String keyAlias;
        char[] ksPwChars;
        String ksType;
        SSLAuthInfo sslAuth = new SSLAuthInfo();
        String ks = this.getProp(KEYSTORE_FILE);
        if (ks != null) {
            sslAuth.keyStore = new File(ks);
        }
        if ((ksType = this.getProp(KEYSTORE_TYPE)) != null) {
            sslAuth.keyStoreType = ksType;
        }
        if ((ksPwChars = this.keystorePassword) != null) {
            SSLAuthInfo.access$402(sslAuth, ksPwChars);
        }
        if ((keyAlias = this.getProp(KEYSTORE_ALIAS)) != null) {
            sslAuth.keyStoreAlias = keyAlias;
        }
        if ((ts = this.getProp(TRUSTSTORE_FILE)) != null) {
            sslAuth.trustStore = new File(ts);
        }
        if ((tsType = this.getProp(TRUSTSTORE_TYPE)) != null) {
            sslAuth.trustStoreType = tsType;
        }
        return sslAuth;
    }

    private SSLContext makeSSLContext(SSLAuthInfo authInfo, boolean isServer) throws KeyStoreException, IOException {
        try {
            KeyManager[] kmList = null;
            TrustManager[] tmList = null;
            if (authInfo.keyStore != null && authInfo.keyStorePassword != null) {
                String ksType = authInfo.keyStoreType;
                if (ksType == null) {
                    ksType = KeyStore.getDefaultType();
                }
                KeyStore ks = KeyStore.getInstance(ksType);
                ks.load(new FileInputStream(authInfo.keyStore), authInfo.keyStorePassword);
                String alias = authInfo.keyStoreAlias;
                if (alias != null && !ks.containsAlias(alias)) {
                    throw new IllegalArgumentException("Alias " + alias + " not found in " + authInfo.keyStore);
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(X509_ALGO_NAME);
                kmf.init(ks, authInfo.keyStorePassword);
                kmList = kmf.getKeyManagers();
                if (alias != null) {
                    X509ExtendedKeyManager x509KeyManager = null;
                    for (KeyManager km : kmList) {
                        if (!(km instanceof X509ExtendedKeyManager)) continue;
                        x509KeyManager = (X509ExtendedKeyManager)km;
                        break;
                    }
                    if (x509KeyManager == null) {
                        throw new IllegalStateException("Unable to locate an X509ExtendedKeyManager corresponding to keyStore " + authInfo.keyStore);
                    }
                    kmList = new KeyManager[]{new AliasKeyManager(x509KeyManager, isServer ? alias : null, isServer ? null : alias)};
                }
            }
            if (authInfo.trustStore != null) {
                String tsType = authInfo.trustStoreType;
                if (tsType == null) {
                    tsType = KeyStore.getDefaultType();
                }
                KeyStore ts = KeyStore.getInstance(tsType);
                char[] tsPw = authInfo.trustStorePassword != null ? authInfo.trustStorePassword : null;
                ts.load(new FileInputStream(authInfo.trustStore), tsPw);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(X509_ALGO_NAME);
                tmf.init(ts);
                tmList = tmf.getTrustManagers();
            }
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmList, tmList, null);
            return ctx;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyStoreException(nsae);
        }
        catch (UnrecoverableKeyException urke) {
            throw new KeyStoreException(urke);
        }
        catch (KeyManagementException kme) {
            throw new KeyStoreException(kme);
        }
        catch (CertificateException ce) {
            throw new KeyStoreException(ce);
        }
    }

    private String getProp(String key) {
        return this.trim(this.props.getProperty(key));
    }

    private String trim(String input) {
        if (input == null) {
            return null;
        }
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return trimmed;
    }

    private String[] trim(String[] input) {
        if (input == null) {
            return null;
        }
        String[] result = new String[input.length];
        int count = 0;
        for (String s : input) {
            String t = this.trim(s);
            if (t == null) continue;
            result[count++] = t;
        }
        if (count == 0) {
            return null;
        }
        return Arrays.copyOf(result, count);
    }

    private static String[] filterConfig(String[] configChoices, String[] supported) {
        ArrayList<String> keep = new ArrayList<String>();
        block0: for (String choice : configChoices) {
            for (String supp : supported) {
                if (!choice.equals(supp)) continue;
                keep.add(choice);
                continue block0;
            }
        }
        return keep.toArray(new String[keep.size()]);
    }

    private static String getX509AlgoName() {
        String x509Name = System.getProperty(X509_ALGO_NAME_PROPERTY);
        if (x509Name != null && !x509Name.isEmpty()) {
            return x509Name;
        }
        String jvmVendor = System.getProperty("java.vendor");
        if (jvmVendor.startsWith("IBM")) {
            return "IbmX509";
        }
        return "SunX509";
    }

    char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    static {
        allProps.add(ENABLED_CIPHER_SUITES);
        allProps.add(ENABLED_PROTOCOLS);
        allProps.add(CLIENT_AUTHENTICATOR);
        allProps.add(SERVER_HOST_VERIFIER);
        allProps.add(KEYSTORE_FILE);
        allProps.add(KEYSTORE_TYPE);
        allProps.add(KEYSTORE_ALIAS);
        allProps.add(TRUSTSTORE_FILE);
        allProps.add(TRUSTSTORE_TYPE);
        X509_ALGO_NAME = SSLConfig.getX509AlgoName();
    }

    private class SSLAuthInfo {
        private File keyStore;
        private String keyStoreType;
        private char[] keyStorePassword;
        private String keyStoreAlias;
        private File trustStore;
        private String trustStoreType;
        private char[] trustStorePassword;

        private SSLAuthInfo() {
        }

        static /* synthetic */ char[] access$402(SSLAuthInfo x0, char[] x1) {
            x0.keyStorePassword = x1;
            return x1;
        }
    }

    static final class InstanceInfo<T> {
        final T impl;
        final String jeImplClass;
        final String jeImplParams;

        private InstanceInfo(T impl, String jeImplClass, String jeImplParams) {
            this.impl = impl;
            this.jeImplClass = jeImplClass;
            this.jeImplParams = jeImplParams;
        }
    }
}

