/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreException;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.ReauthenticateHandler;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.security.login.AdminLoginManager;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.shell.ShellInputReader;

public class KVStoreLogin {
    public static final String PWD_MANAGER = "oracle.kv.auth.pwdfile.manager";
    private static final String WALLET_MANAGER_CLASS = "oracle.kv.impl.security.wallet.WalletManager";
    private static final String DEFAULT_FILESTORE_MANAGER_CLASS = "oracle.kv.impl.security.filestore.FileStoreManager";
    private String userName;
    private String securityFilePath;
    private Properties securityProps = null;
    private ShellInputReader reader = null;
    private static final Set<String> fileProperties = new HashSet<String>();

    public KVStoreLogin() {
        this(null, null);
    }

    public KVStoreLogin(String user, String security) {
        this.userName = user;
        this.securityFilePath = security;
    }

    public String getUserName() {
        return this.userName;
    }

    public void updateLoginInfo(String user, String security) {
        this.userName = user;
        this.securityFilePath = security;
        this.loadSecurityProperties();
    }

    public Properties getSecurityProperties() {
        return this.securityProps;
    }

    public void loadSecurityProperties() {
        if (this.securityFilePath == null) {
            this.securityFilePath = System.getProperty("oracle.kv.security");
        }
        this.securityProps = KVStoreLogin.createSecurityProperties(this.securityFilePath);
        if (this.securityProps != null && this.userName == null) {
            this.userName = this.securityProps.getProperty("oracle.kv.auth.username");
        }
        if (this.securityFilePath != null && !this.foundSSLTransport()) {
            throw new IllegalArgumentException("A security file was specified, but the file does not provide the required SSL transport setting, which will cause user logins to fail");
        }
    }

    private ShellInputReader getReader() {
        if (this.reader == null) {
            this.reader = new ShellInputReader(System.in, System.out);
        }
        return this.reader;
    }

    protected void setReader(ShellInputReader reader) {
        this.reader = reader;
    }

    public PasswordCredentials makeShellLoginCredentials() throws IOException {
        char[] passwd;
        if (this.userName == null) {
            this.userName = this.getReader().readLine("Login as:");
        }
        if ((passwd = KVStoreLogin.retrievePassword(this.userName, this.securityProps)) == null) {
            passwd = this.getReader().readPassword(this.userName + "'s password:");
        }
        return new PasswordCredentials(this.userName, passwd);
    }

    public PasswordCredentials getLoginCredentials() {
        return KVStoreLogin.makeLoginCredentials(this.securityProps);
    }

    public String getSecurityFilePath() {
        return this.securityFilePath;
    }

    public boolean foundSSLTransport() {
        String transportType = this.securityProps == null ? null : this.securityProps.getProperty("oracle.kv.transport");
        return transportType != null && transportType.equals("ssl");
    }

    public boolean hasTransportSettings() {
        return this.securityProps != null && this.securityProps.getProperty("oracle.kv.transport") != null;
    }

    public void prepareRegistryCSF() {
        if (this.hasTransportSettings()) {
            ClientSocketFactory.setRMIPolicy(this.getSecurityProperties());
        }
        RegistryUtils.initRegistryCSF();
    }

    public static PasswordCredentials makeLoginCredentials(Properties securityProps) {
        if (securityProps == null) {
            return null;
        }
        String user = securityProps.getProperty("oracle.kv.auth.username");
        if (user == null) {
            return null;
        }
        char[] passwd = KVStoreLogin.retrievePassword(user, securityProps);
        return passwd == null ? null : new PasswordCredentials(user, passwd);
    }

    public static Properties createSecurityProperties(String security) {
        if (security == null) {
            return null;
        }
        File securityFile = new File(security);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(securityFile);
            Properties securityProps = new Properties();
            securityProps.load(fis);
            KVStoreLogin.resolveRelativePaths(securityProps, securityFile);
            Properties properties = securityProps;
            return properties;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void resolveRelativePaths(Properties securityProps, File sourceFile) {
        File sourceDir = sourceFile.getAbsoluteFile().getParentFile();
        for (String propName : securityProps.stringPropertyNames()) {
            String propVal;
            File propFile;
            if (!fileProperties.contains(propName) || (propFile = new File(propVal = securityProps.getProperty(propName))).isAbsolute()) continue;
            propFile = new File(sourceDir, propVal);
            securityProps.setProperty(propName, propFile.getPath());
        }
    }

    private static char[] retrievePassword(String user, Properties securityProps) {
        if (user == null || securityProps == null) {
            return null;
        }
        PasswordManager pwdManager = null;
        PasswordStore pwdStore = null;
        try {
            String walletDir = securityProps.getProperty("oracle.kv.auth.wallet.dir");
            if (walletDir != null && !walletDir.isEmpty()) {
                pwdManager = PasswordManager.load(WALLET_MANAGER_CLASS);
                pwdStore = pwdManager.getStoreHandle(new File(walletDir));
            } else {
                String pwdFile;
                String mgrClass = securityProps.getProperty(PWD_MANAGER);
                if (mgrClass == null || mgrClass.isEmpty()) {
                    mgrClass = DEFAULT_FILESTORE_MANAGER_CLASS;
                }
                if ((pwdFile = securityProps.getProperty("oracle.kv.auth.pwdfile.file")) == null || pwdFile.isEmpty()) {
                    char[] cArray = null;
                    return cArray;
                }
                pwdManager = PasswordManager.load(mgrClass);
                pwdStore = pwdManager.getStoreHandle(new File(pwdFile));
            }
            pwdStore.open(null);
            char[] cArray = pwdStore.getSecret(user);
            return cArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (pwdStore != null) {
                pwdStore.discard();
            }
        }
    }

    public static ReauthenticateHandler makeReauthenticateHandler(final CredentialsProvider credsProvider) {
        return credsProvider == null ? null : new ReauthenticateHandler(){

            @Override
            public void reauthenticate(KVStore kvstore) throws FaultException, AuthenticationFailureException, AuthenticationRequiredException {
                LoginCredentials creds = credsProvider.getCredentials();
                kvstore.login(creds);
            }
        };
    }

    public static AdminLoginManager getAdminLoginMgr(String host, int port, PasswordCredentials pwdCreds) throws AuthenticationFailureException {
        return KVStoreLogin.getAdminLoginMgr(new String[]{host + ":" + port}, pwdCreds);
    }

    public static AdminLoginManager getAdminLoginMgr(String[] hostPorts, PasswordCredentials pwdCreds) throws AuthenticationFailureException {
        AdminLoginManager loginMgr;
        if (pwdCreds != null && (loginMgr = new AdminLoginManager(pwdCreds.getUsername(), true)).bootstrap(hostPorts, (LoginCredentials)pwdCreds)) {
            return loginMgr;
        }
        return null;
    }

    public static RepNodeLoginManager getRepNodeLoginMgr(String host, int port, PasswordCredentials pwdCreds, String storeName) throws AuthenticationFailureException {
        return KVStoreLogin.getRepNodeLoginMgr(new String[]{host + ":" + port}, pwdCreds, storeName);
    }

    public static RepNodeLoginManager getRepNodeLoginMgr(String[] hostPorts, PasswordCredentials pwdCreds, String storeName) throws AuthenticationFailureException {
        if (pwdCreds != null) {
            try {
                RepNodeLoginManager loginMgr = new RepNodeLoginManager(pwdCreds.getUsername(), true);
                loginMgr.bootstrap(hostPorts, pwdCreds, storeName);
                return loginMgr;
            }
            catch (KVStoreException kVStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        fileProperties.add("oracle.kv.security");
        fileProperties.add("oracle.kv.auth.wallet.dir");
        fileProperties.add("oracle.kv.auth.pwdfile.file");
        fileProperties.add("oracle.kv.ssl.keyStore");
        fileProperties.add("oracle.kv.ssl.trustStore");
    }

    public static class StoreLoginCredentialsProvider
    implements CredentialsProvider {
        private final Properties props;

        public StoreLoginCredentialsProvider(Properties securityProps) {
            this.props = securityProps;
        }

        @Override
        public LoginCredentials getCredentials() {
            return KVStoreLogin.makeLoginCredentials(this.props);
        }
    }

    public static interface CredentialsProvider {
        public LoginCredentials getCredentials();
    }
}

