/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.Value;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;

public class UserDataControl {
    private static boolean HIDE_KEY = true;
    private static boolean HIDE_VALUE = true;
    public static final String HIDDEN = "[hidden]";
    private static ParameterListener PARAM_SETTER = new ParamSetter();

    private static void setKeyHiding(boolean shouldHide) {
        HIDE_KEY = shouldHide;
    }

    private static void setValueHiding(boolean shouldHide) {
        HIDE_VALUE = shouldHide;
    }

    public static String displayKey(byte[] keyBytes) {
        if (keyBytes == null) {
            return "null";
        }
        return HIDE_KEY ? HIDDEN : Key.fromByteArray(keyBytes).toString();
    }

    public static String displayKey(Key key) {
        if (key == null) {
            return "null";
        }
        return HIDE_KEY ? HIDDEN : key.toString();
    }

    public static String displayKeyRange(KeyRange keyRange) {
        if (keyRange == null) {
            return "null";
        }
        return HIDE_KEY ? HIDDEN : keyRange.toString();
    }

    public static String displayValue(Value value, byte[] valueBytes) {
        if (value == null) {
            if (valueBytes == null) {
                return "null";
            }
            return HIDE_VALUE ? HIDDEN : Value.fromByteArray(valueBytes).toString();
        }
        return HIDE_VALUE ? HIDDEN : value.toString();
    }

    public static ParameterListener getParamListener() {
        return PARAM_SETTER;
    }

    private static class ParamSetter
    implements ParameterListener {
        private ParamSetter() {
        }

        @Override
        public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
            boolean hideData = newMap.getOrDefault("hideUserData").asBoolean();
            UserDataControl.setKeyHiding(hideData);
            UserDataControl.setValueHiding(hideData);
        }
    }
}

