/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.registry.ServerSocketFactory;

public class SSLServerSocketFactory
extends ServerSocketFactory {
    private static final int HANDSHAKE_THREAD_MAX = 10;
    private static final int HANDSHAKE_QUEUE_MAX = 10;
    private static final long KEEPALIVE_MS = 10000L;
    private static final AtomicInteger hsThreadCounter = new AtomicInteger(0);
    private final Map<Integer, ServerSocket> pendingSocketMap;
    private final SSLControl sslControl;

    public SSLServerSocketFactory(SSLControl sslControl, String name, int backlog, int startPort, int endPort) {
        super(name, backlog, startPort, endPort);
        if (sslControl == null) {
            throw new IllegalArgumentException("sslControl may not be null");
        }
        this.sslControl = sslControl;
        this.pendingSocketMap = new HashMap<Integer, ServerSocket>();
    }

    public String toString() {
        return "<SSLServerSocketFactory name=" + this.name + " backlog=" + this.backlog + " port range=" + this.startPort + "," + this.endPort + " ssl control = " + this.sslControl + ">";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.sslControl.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SSLServerSocketFactory)) {
            return false;
        }
        SSLServerSocketFactory other = (SSLServerSocketFactory)obj;
        return this.sslControl.equals(other.sslControl);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket ss;
        if (port != 0 && (ss = this.retrievePendingSocket(port)) != null) {
            return ss;
        }
        return this.commonCreateServerSocket(port);
    }

    @Override
    public synchronized ServerSocket prepareServerSocket() throws IOException {
        if (!this.doBackgroundAccept()) {
            return null;
        }
        ServerSocket ss = this.createServerSocket(0);
        this.pendingSocketMap.put(ss.getLocalPort(), ss);
        return ss;
    }

    @Override
    public synchronized void discardServerSocket(ServerSocket ss) {
        Set<Map.Entry<Integer, ServerSocket>> entries = this.pendingSocketMap.entrySet();
        for (Map.Entry<Integer, ServerSocket> entry : entries) {
            if (entry.getValue() != ss) continue;
            this.pendingSocketMap.remove(entry.getKey());
            break;
        }
        try {
            ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SSLServerSocketFactory create(SSLControl sslControl, String name, int backlog, String portRange) {
        if (portRange == null || PortRange.isUnconstrained((String)portRange)) {
            return new SSLServerSocketFactory(sslControl, name, backlog, 0, 0);
        }
        List range = PortRange.getRange((String)portRange);
        return new SSLServerSocketFactory(sslControl, name, backlog, (Integer)range.get(0), (Integer)range.get(1));
    }

    private boolean doBackgroundAccept() {
        return this.sslControl.peerAuthenticator() != null;
    }

    private synchronized ServerSocket retrievePendingSocket(int port) {
        return this.pendingSocketMap.remove(port);
    }

    @Override
    protected ServerSocket instantiateServerSocket(int port) throws IOException {
        return new SSLInternalServerSocket(port);
    }

    @Override
    protected ServerSocket instantiateServerSocket(int port, int backlog1) throws IOException {
        return new SSLInternalServerSocket(port, backlog1);
    }

    class SSLInternalServerSocket
    extends ServerSocket {
        private final ThreadPoolExecutor handshakeExecutor;
        private final Thread rawAcceptor;
        private final BlockingQueue<AcceptEvent> acceptEvents;
        private final BlockingQueue<Runnable> handshakeExecutionQueue;
        private final int listenPort;

        SSLInternalServerSocket(int port) throws IOException {
            this(port, 0);
        }

        SSLInternalServerSocket(int port, int backlog) throws IOException {
            super(port, backlog);
            this.listenPort = this.getLocalPort();
            if (SSLServerSocketFactory.this.doBackgroundAccept()) {
                this.handshakeExecutionQueue = new LinkedBlockingQueue<Runnable>(10);
                this.handshakeExecutor = new ThreadPoolExecutor(1, 10, 10000L, TimeUnit.MILLISECONDS, this.handshakeExecutionQueue, new HandshakeThreadFactory());
                this.acceptEvents = new LinkedBlockingQueue<AcceptEvent>();
                String acceptorName = "SSLAccept-" + this.listenPort;
                this.rawAcceptor = new Thread((Runnable)new RawAcceptor(), acceptorName);
                this.rawAcceptor.setDaemon(true);
                this.rawAcceptor.start();
            } else {
                this.handshakeExecutionQueue = null;
                this.handshakeExecutor = null;
                this.acceptEvents = null;
                this.rawAcceptor = null;
            }
        }

        @Override
        public Socket accept() throws IOException {
            SSLSocket sslSocket;
            if (this.acceptEvents != null) {
                while (true) {
                    try {
                        AcceptEvent event = this.acceptEvents.take();
                        return event.yieldSocket();
                    }
                    catch (InterruptedException ie) {
                        if (SSLServerSocketFactory.this.connectionLogger == null) continue;
                        SSLServerSocketFactory.this.connectionLogger.info("Interrupted while waiting for acceptEvent");
                        continue;
                    }
                    break;
                }
            }
            while (!this.authenticateNewSocket(sslSocket = this.acceptSocket())) {
            }
            return sslSocket;
        }

        private boolean authenticateNewSocket(SSLSocket sslSocket) {
            if (SSLServerSocketFactory.this.sslControl.peerAuthenticator() == null) {
                return true;
            }
            try {
                sslSocket.startHandshake();
                if (SSLServerSocketFactory.this.sslControl.peerAuthenticator().isTrusted(sslSocket.getSession())) {
                    return true;
                }
                if (SSLServerSocketFactory.this.connectionLogger != null) {
                    SSLServerSocketFactory.this.connectionLogger.info("Rejecting client connection");
                }
                this.forceCloseSocket(sslSocket);
            }
            catch (IOException ioe) {
                if (SSLServerSocketFactory.this.connectionLogger != null) {
                    SSLServerSocketFactory.this.connectionLogger.info("error while handshaking: " + ioe);
                }
                this.forceCloseSocket(sslSocket);
            }
            return false;
        }

        private SSLSocket acceptSocket() throws IOException {
            Socket socket = super.accept();
            SSLSocket sslSocket = (SSLSocket)SSLServerSocketFactory.this.sslControl.sslContext().getSocketFactory().createSocket(socket, socket.getInetAddress().toString(), socket.getPort(), true);
            sslSocket.setUseClientMode(false);
            SSLServerSocketFactory.this.sslControl.applySSLParameters(sslSocket);
            return sslSocket;
        }

        private void forceCloseSocket(Socket socket) {
            block2: {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    if (SSLServerSocketFactory.this.connectionLogger == null) break block2;
                    SSLServerSocketFactory.this.connectionLogger.info("Exception closing socket: " + ioe);
                }
            }
        }

        private void queueAcceptedSocket(SSLSocket newSocket) {
            try {
                this.acceptEvents.put(new SocketEvent(newSocket));
            }
            catch (InterruptedException ie) {
                if (SSLServerSocketFactory.this.connectionLogger != null) {
                    SSLServerSocketFactory.this.connectionLogger.info("Interrupted while queueing new socket - discarding:" + ie);
                }
                this.forceCloseSocket(newSocket);
            }
        }

        private class HandshakeThreadFactory
        implements ThreadFactory {
            private HandshakeThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                String tName = "SSLHandshake-" + SSLInternalServerSocket.this.listenPort + "-" + hsThreadCounter.getAndIncrement();
                Thread t = new Thread(r, tName);
                t.setDaemon(true);
                return t;
            }
        }

        private class ExceptionEvent
        extends AcceptEvent {
            private final IOException ioe;

            ExceptionEvent(IOException ioe) {
                this.ioe = ioe;
            }

            @Override
            Socket yieldSocket() throws IOException {
                throw this.ioe;
            }
        }

        private class SocketEvent
        extends AcceptEvent {
            private final Socket socket;

            SocketEvent(Socket socket) {
                this.socket = socket;
            }

            @Override
            Socket yieldSocket() throws IOException {
                return this.socket;
            }
        }

        private abstract class AcceptEvent {
            private AcceptEvent() {
            }

            abstract Socket yieldSocket() throws IOException;
        }

        private final class RawAcceptor
        implements Runnable {
            private RawAcceptor() {
            }

            @Override
            public void run() {
                while (true) {
                    SSLSocket sslSocket = null;
                    try {
                        sslSocket = SSLInternalServerSocket.this.acceptSocket();
                    }
                    catch (IOException ioe) {
                        block10: {
                            try {
                                SSLInternalServerSocket.this.acceptEvents.put(new ExceptionEvent(ioe));
                            }
                            catch (InterruptedException ie) {
                                if (SSLServerSocketFactory.this.connectionLogger == null) break block10;
                                SSLServerSocketFactory.this.connectionLogger.info("Unable to queue ExecptionEvent while terminating");
                            }
                        }
                        SSLInternalServerSocket.this.handshakeExecutor.shutdown();
                        if (SSLServerSocketFactory.this.connectionLogger != null) {
                            SSLServerSocketFactory.this.connectionLogger.info("Queued shutdown event for port " + SSLInternalServerSocket.this.listenPort);
                        }
                        return;
                    }
                    if (sslSocket == null) continue;
                    if (SSLServerSocketFactory.this.sslControl.peerAuthenticator() != null) {
                        try {
                            SSLInternalServerSocket.this.handshakeExecutor.execute(new HandshakeAndVerify(sslSocket));
                        }
                        catch (RejectedExecutionException ie) {
                            if (SSLServerSocketFactory.this.connectionLogger != null) {
                                SSLServerSocketFactory.this.connectionLogger.info("Unable to queue socket for verification - interrupted.");
                            }
                            SSLInternalServerSocket.this.forceCloseSocket(sslSocket);
                        }
                        continue;
                    }
                    SSLInternalServerSocket.this.queueAcceptedSocket(sslSocket);
                }
            }

            private final class HandshakeAndVerify
            implements Runnable {
                private SSLSocket sslSocket;

                private HandshakeAndVerify(SSLSocket sslSocket) {
                    this.sslSocket = sslSocket;
                }

                @Override
                public void run() {
                    if (SSLInternalServerSocket.this.authenticateNewSocket(this.sslSocket)) {
                        SSLInternalServerSocket.this.queueAcceptedSocket(this.sslSocket);
                    }
                }
            }
        }
    }
}

