/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.EntityModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.Key;
import oracle.kv.LoginCredentials;
import oracle.kv.Value;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.TableMetadataProxy;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataStore;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.metadata.SecurityMetadataProxy;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.server.LoggerUtils;
import oracle.kv.util.shell.ShellException;

public class Load
implements KVStoreLogin.CredentialsProvider {
    public static final String COMMAND_NAME = "load";
    public static final String COMMAND_DESC = "loads data into a store from a backup";
    public static final String COMMAND_ARGS = "-source <backupDir> " + CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + "\n\t" + CommandParser.getStoreUsage() + " " + CommandParser.optional((String)CommandParser.getUserUsage()) + " " + CommandParser.optional((String)CommandParser.getSecurityUsage()) + "\n\t" + CommandParser.optional((String)"-load-admin ") + CommandParser.optional((String)"-force ") + CommandParser.optional((String)"-status <pathToFile>");
    File envDir;
    Environment env;
    Topology topo;
    File statusFile;
    HashSet<String> loadedDatabases;
    PrintStream output;
    boolean verboseOutput;
    RecordListMap recordList;
    int maxPartitionBytes;
    long totalBytesThreshold;
    private KVStoreLogin storeLogin;
    private LoginCredentials loginCreds;
    KVStore userStore;
    KVStore internalStore;
    ExecutorService threadPool;
    BlockingQueue<FutureHolder> taskWaitQueue;
    Future<Long> taskWait;
    private static final int NUM_THREADS = 20;
    private static final int TASK_QUEUE_SIZE = 40;
    private static final int DEFAULT_MAX_PARTITION_BYTES = 5000000;
    private static final int RETRY_COUNT = 5;

    public Load(File env, String storeName, String targetHost, int targetPort, String user, String securityFile, String statusFile, boolean verboseOutput, PrintStream output) throws Exception {
        this.envDir = env;
        this.statusFile = statusFile != null ? new File(statusFile) : null;
        this.verboseOutput = verboseOutput;
        this.output = output;
        String[] hosts = new String[]{targetHost + ":" + targetPort};
        this.prepareAuthentication(user, securityFile);
        KVStoreConfig kvConfig = new KVStoreConfig(storeName, hosts[0]);
        kvConfig.setSecurityProperties(this.storeLogin.getSecurityProperties());
        this.userStore = KVStoreFactory.getStore(kvConfig, this.loginCreds, KVStoreLogin.makeReauthenticateHandler(this));
        this.internalStore = KVStoreImpl.makeInternalHandle(this.userStore);
        this.verbose("Opened store " + storeName);
        this.topo = TopologyLocator.get(hosts, 10, KVStoreImpl.getLoginManager(this.userStore), null);
        this.threadPool = Executors.newFixedThreadPool(20, new KVThreadFactory("Load", null));
        this.taskWaitQueue = new ArrayBlockingQueue<FutureHolder>(40);
        this.taskWait = this.threadPool.submit(new TaskWaiter());
        this.recordList = new RecordListMap();
        this.totalBytesThreshold = Runtime.getRuntime().maxMemory() / 4L;
        this.maxPartitionBytes = 5000000;
        this.verbose("Using byte threshold of " + this.totalBytesThreshold);
    }

    @Override
    public LoginCredentials getCredentials() {
        return this.loginCreds;
    }

    public void setStatusFile(File status) {
        this.statusFile = status;
    }

    public File getStatusFile() {
        return this.statusFile;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setVerbose(boolean verboseOutput) {
        this.verboseOutput = verboseOutput;
    }

    public boolean getVerbose() {
        return this.verboseOutput;
    }

    public void setPartitionBytes(int value) {
        this.maxPartitionBytes = value;
    }

    public int getPartitionBytes() {
        return this.maxPartitionBytes;
    }

    private void message(String msg) {
        if (this.output != null) {
            this.output.println(msg);
        }
    }

    private void verbose(String msg) {
        if (this.verboseOutput) {
            this.message(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long run() throws Exception {
        try {
            this.env = Load.open(this.envDir);
            this.verbose("Opened source backup directory " + this.envDir);
            this.loadStatusFile();
        }
        catch (Exception e) {
            System.err.println("Could not open backup source directory: " + e);
            return 0L;
        }
        try {
            List dbs = this.env.getDatabaseNames();
            for (String db : dbs) {
                if (!PartitionId.isPartitionName(db)) {
                    this.verbose("Skipping non-partition database: " + db);
                    continue;
                }
                if (this.isLoaded(db)) {
                    this.verbose("Skipping already loaded database: " + db);
                    continue;
                }
                this.verbose("Starting database scan: " + db);
                this.scanDatabase(db);
                this.setLoaded(db);
                this.verbose("Completed database scan: " + db);
            }
            this.recordList.createTasks();
            this.verbose("Done scanning databases, waiting for write tasks");
            long l = this.waitForTasks();
            return l;
        }
        finally {
            this.writeStatusFile();
            this.close();
        }
    }

    private void prepareAuthentication(String user, String securityFile) throws Exception {
        this.storeLogin = new KVStoreLogin(user, securityFile);
        try {
            this.storeLogin.loadSecurityProperties();
        }
        catch (IllegalArgumentException iae) {
            this.message(iae.getMessage());
        }
        if (this.storeLogin.foundSSLTransport()) {
            this.loginCreds = this.storeLogin.makeShellLoginCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDatabase(String dbName) throws Exception {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(false);
        dbConfig.setReadOnly(true);
        Database db = null;
        DiskOrderedCursor cursor = null;
        try {
            db = this.env.openDatabase(null, dbName, dbConfig);
            cursor = db.openCursor(new DiskOrderedCursorConfig());
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                if (this.taskWait.isDone()) {
                    this.message("Task Waiter has exited, aborting load");
                    this.waitForTasks();
                }
                this.recordList.insert(key, data);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    private long waitForTasks() throws Exception {
        this.verbose("Collecting results from write tasks");
        try {
            this.taskWaitQueue.put(new FutureHolder(null));
            return this.taskWait.get();
        }
        catch (ExecutionException e) {
            this.message("waitForTasks: exception from a task: " + e);
            throw e;
        }
        catch (InterruptedException ie) {
            this.message("waitForTasks: task was interrupted: " + ie);
            throw ie;
        }
    }

    private void close() {
        this.env.close();
        if (this.userStore != null) {
            this.userStore.close();
        }
    }

    private void setLoaded(String dbname) {
        if (this.loadedDatabases != null) {
            this.loadedDatabases.add(dbname);
        }
    }

    private boolean isLoaded(String dbname) {
        return this.loadedDatabases != null && this.loadedDatabases.contains(dbname);
    }

    private void loadStatusFile() {
        if (this.statusFile != null) {
            this.loadedDatabases = new HashSet();
            if (this.statusFile.exists()) {
                try {
                    String inputLine;
                    FileReader fr = new FileReader(this.statusFile);
                    BufferedReader br = new BufferedReader(fr);
                    while ((inputLine = br.readLine()) != null) {
                        this.loadedDatabases.add(inputLine);
                    }
                    br.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load from status file " + this.statusFile, e);
                }
                this.verbose("Loaded status from file " + this.statusFile);
            }
        }
    }

    private void writeStatusFile() {
        if (this.loadedDatabases != null) {
            try (PrintWriter writer = null;){
                FileOutputStream fos = new FileOutputStream(this.statusFile);
                writer = new PrintWriter(fos);
                for (String dbname : this.loadedDatabases) {
                    writer.printf("%s\n", dbname);
                }
            }
        }
    }

    private static Environment open(File envDir) {
        if (!envDir.isDirectory()) {
            System.err.println("Environment path is not a directory or does not exist: " + envDir);
            throw new IllegalArgumentException("Bad environment directory: " + envDir);
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(false);
        envConfig.setAllowCreate(false);
        envConfig.setReadOnly(true);
        try {
            Environment env = new Environment(envDir, envConfig);
            return env;
        }
        catch (EnvironmentNotFoundException e) {
            throw new IllegalArgumentException("Cannot find valid Environment in directory: " + envDir);
        }
    }

    private int writeListToStore(List<KV> list) {
        int num = 0;
        block2: for (KV kv : list) {
            for (int i = 0; i < 5; ++i) {
                try {
                    this.internalStore.putIfAbsent(kv.key, kv.value);
                    ++num;
                    continue block2;
                }
                catch (FaultException fe) {
                    if (i != 4) continue;
                    throw fe;
                }
            }
        }
        return num;
    }

    public static void main(String[] args) throws Exception {
        LoadParser lp = new LoadParser(args);
        lp.parseArgs();
        if (lp.getLoadAdmin()) {
            Load.loadAdmin(lp);
            return;
        }
        Load load = new Load(new File(lp.getSourceDir()), lp.getStoreName(), lp.getHostname(), lp.getRegistryPort(), lp.getUserName(), lp.getSecurityFile(), lp.getStatusFile(), lp.getVerbose(), System.out);
        try {
            long total = load.run();
            System.out.println("Load succeeded, wrote " + total + " records");
        }
        catch (Exception e) {
            System.err.println("Load operation failed with exception: " + LoggerUtils.getStackTrace((Throwable)e));
        }
    }

    private static void loadAdmin(LoadParser lp) {
        Load.loadAdmin(new File(lp.getSourceDir()), lp.getHostname(), lp.getRegistryPort(), lp.getUserName(), lp.getSecurityFile(), lp.getVerbose(), lp.getForceLoadAdmin(), System.out);
    }

    public static void loadAdmin(File envDir, String targetHost, int targetPort, String user, String securityFile, boolean verboseOutput, boolean forceLoad, PrintStream output) {
        try {
            LoadAdmin load = new LoadAdmin(envDir, targetHost, targetPort, user, securityFile, verboseOutput, forceLoad, output);
            load.loadMetadata();
        }
        catch (Exception e) {
            System.err.println("Admin load operation failed with exception: " + LoggerUtils.getStackTrace((Throwable)e));
        }
    }

    public static class LoadParser
    extends CommandParser {
        private static final String SOURCE_FLAG = "-source";
        private static final String STATUS_FLAG = "-status";
        private static final String ADMIN_LOAD_FLAG = "-load-admin";
        private static final String FORCE_ADMIN_FLAG = "-force";
        private String source = null;
        private String status = null;
        private boolean loadAdmin = false;
        private boolean forceLoadAdmin = false;

        LoadParser(String[] args) {
            super(args);
        }

        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar load\n\t" + COMMAND_ARGS);
            System.exit(-1);
        }

        protected boolean checkArg(String arg) {
            if (arg.equals(SOURCE_FLAG)) {
                this.source = this.nextArg(arg);
                return true;
            }
            if (arg.equals(STATUS_FLAG)) {
                this.status = this.nextArg(arg);
                return true;
            }
            if (arg.equals(ADMIN_LOAD_FLAG)) {
                this.loadAdmin = true;
                return true;
            }
            if (arg.equals(FORCE_ADMIN_FLAG)) {
                this.forceLoadAdmin = true;
                return true;
            }
            return false;
        }

        protected void verifyArgs() {
            if (this.getHostname() == null) {
                this.missingArg("-host");
            }
            if (this.getRegistryPort() == 0) {
                this.missingArg("-port");
            }
            if (this.getStoreName() == null && !this.loadAdmin) {
                this.missingArg("-store");
            }
            if (this.source == null) {
                this.missingArg(SOURCE_FLAG);
            }
        }

        public String getStatusFile() {
            return this.status;
        }

        public String getSourceDir() {
            return this.source;
        }

        public boolean getLoadAdmin() {
            return this.loadAdmin;
        }

        public boolean getForceLoadAdmin() {
            return this.forceLoadAdmin;
        }
    }

    private static class LoadAdmin {
        private final Environment env;
        private final EntityStore estore;
        private final boolean verboseOutput;
        private final PrintStream output;
        private final String securityFile;
        private final String user;
        private final String targetHost;
        private final int targetPort;
        private final boolean forceLoad;

        public LoadAdmin(File envDir, String targetHost, int targetPort, String user, String securityFile, boolean verboseOutput, boolean forceLoad, PrintStream output) {
            this.env = Load.open(envDir);
            this.estore = this.initEstore(envDir);
            this.output = output;
            this.verboseOutput = verboseOutput;
            this.securityFile = securityFile;
            this.user = user;
            this.targetHost = targetHost;
            this.targetPort = targetPort;
            this.forceLoad = forceLoad;
            this.verbose("Opened environment for admin load: " + envDir);
        }

        public void loadMetadata() {
            SecurityMetadata smd;
            TableMetadata tmd = (TableMetadata)MetadataStore.read(TableMetadata.class, (Metadata.MetadataType)Metadata.MetadataType.TABLE, (EntityStore)this.estore, null);
            if (tmd != null) {
                List<String> tablesToLoad;
                this.verbose("Found table metadata");
                if (this.verboseOutput && !(tablesToLoad = tmd.listTables()).isEmpty()) {
                    this.message("Writing tables:");
                    for (String s : tablesToLoad) {
                        this.message("\t" + s);
                    }
                }
            } else {
                this.message("No tables to write");
            }
            if ((smd = (SecurityMetadata)MetadataStore.read(SecurityMetadata.class, (Metadata.MetadataType)Metadata.MetadataType.SECURITY, (EntityStore)this.estore, null)) != null) {
                this.verbose("Found security metadata");
            }
            if (tmd != null || smd != null) {
                this.writeMetadata(tmd, smd);
            }
            this.estore.close();
            this.env.close();
        }

        private void writeMetadata(TableMetadata tmd, SecurityMetadata smd) {
            ArrayList<String> argList = new ArrayList<String>();
            argList.add("-host");
            argList.add(this.targetHost);
            argList.add("-port");
            argList.add(Integer.toString(this.targetPort));
            if (this.securityFile != null) {
                argList.add("-admin-security");
                argList.add(this.securityFile);
            }
            if (this.user != null) {
                argList.add("-admin-username");
                argList.add(this.user);
            }
            CommandShell shell = new CommandShell(null, this.output);
            shell.parseArgs(argList.toArray(new String[argList.size()]));
            shell.init();
            try {
                CommandServiceAPI cs = shell.getAdmin();
                TableMetadata existingTableMD = null;
                SecurityMetadata existingSecMD = null;
                if (tmd != null) {
                    existingTableMD = (TableMetadata)cs.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
                }
                if (smd != null) {
                    existingSecMD = (SecurityMetadata)cs.getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
                }
                if (!(existingTableMD == null && existingSecMD == null || this.forceLoad)) {
                    this.message("Metadata exists, use -force flag to overwrite");
                    return;
                }
                if (tmd != null) {
                    cs.putMetadata((Metadata)tmd);
                    this.verbose("Wrote table metadata");
                }
                if (smd != null) {
                    cs.putMetadata((Metadata)smd);
                    this.verbose("Wrote security metadata");
                }
            }
            catch (RemoteException re) {
                this.message("Failed to acquire admin interface or write metadata: " + re.getMessage());
            }
            catch (ShellException se) {
                this.message("Failed to acquire admin interface or write metadata: " + se.getMessage());
            }
        }

        private EntityStore initEstore(File envDir) {
            AnnotationModel model = new AnnotationModel();
            model.registerClass(TableMetadataProxy.class);
            model.registerClass(SecurityMetadataProxy.class);
            StoreConfig stConfig = new StoreConfig();
            stConfig.setAllowCreate(false);
            stConfig.setTransactional(false);
            stConfig.setReadOnly(true);
            stConfig.setModel((EntityModel)model);
            try {
                return new EntityStore(this.env, "AdminEntityStore", stConfig);
            }
            catch (StoreNotFoundException snf) {
                throw new IllegalArgumentException("Cannot find an admin database in the directory: " + envDir);
            }
        }

        private void message(String msg) {
            this.output.println(msg);
        }

        private void verbose(String msg) {
            if (this.verboseOutput) {
                this.message(msg);
            }
        }
    }

    private class TaskWaiter
    implements Callable<Long> {
        long totalRecords;

        @Override
        public Long call() throws Exception {
            while (true) {
                FutureHolder holder;
                try {
                    holder = Load.this.taskWaitQueue.take();
                }
                catch (InterruptedException e) {
                    Load.this.verbose("Load program was interrupted");
                    throw new IllegalStateException(e);
                }
                if (holder == null || holder.getFuture() == null) {
                    Load.this.verbose("TaskWaitThread returning");
                    return this.totalRecords;
                }
                Future<Integer> future = holder.getFuture();
                try {
                    int result = future.get();
                    this.totalRecords += (long)result;
                }
                catch (ExecutionException e) {
                    Load.this.message("TaskWaiter: exception from a task: " + e);
                    throw e;
                }
                catch (InterruptedException ie) {
                    Load.this.message("TaskWaiter: task was interrupted: " + ie);
                    throw ie;
                }
            }
        }
    }

    class FutureHolder {
        Future<Integer> future;

        public FutureHolder(Future<Integer> future) {
            this.future = future;
        }

        public Future<Integer> getFuture() {
            return this.future;
        }
    }

    private class WriteTask
    implements Callable<Integer> {
        List<KV> list;

        public WriteTask(List<KV> list) {
            this.list = list;
        }

        @Override
        public Integer call() {
            return Load.this.writeListToStore(this.list);
        }
    }

    class RecordListMap {
        private final ConcurrentMap<PartitionId, RecordList> map = new ConcurrentHashMap<PartitionId, RecordList>();
        int totalBytes = 0;

        public void insert(DatabaseEntry key, DatabaseEntry data) {
            byte[] keyBytes = key.getData();
            byte[] valBytes = data.getData();
            PartitionId targetPartition = Load.this.topo.getPartitionId(keyBytes);
            RecordList list = (RecordList)this.map.get(targetPartition);
            if (list == null) {
                list = new RecordList();
                this.map.put(targetPartition, list);
            }
            list.add(keyBytes, valBytes);
            this.totalBytes += list.byteSize();
            if (list.byteSize() > Load.this.maxPartitionBytes) {
                this.createTaskFromList(list, targetPartition);
            }
            if ((long)this.totalBytes > Load.this.totalBytesThreshold) {
                this.createTasks();
            }
        }

        public void createTaskFromList(RecordList list, PartitionId id) {
            this.createTask(list.getList());
            this.totalBytes -= list.byteSize();
            this.map.remove(id);
        }

        public void createTasks() {
            for (Map.Entry entry : this.map.entrySet()) {
                this.createTaskFromList((RecordList)entry.getValue(), (PartitionId)entry.getKey());
            }
        }

        private void createTask(List<KV> list) {
            Load.this.verbose("Creating a task to write " + list.size() + " records");
            Future<Integer> future = Load.this.threadPool.submit(new WriteTask(list));
            try {
                Load.this.taskWaitQueue.put(new FutureHolder(future));
            }
            catch (InterruptedException e) {
                Load.this.verbose("Load program was interrupted");
                throw new IllegalStateException(e);
            }
        }

        class RecordList {
            private final List<KV> list = new ArrayList<KV>();
            private int bytes = 0;

            public void add(byte[] keyBytes, byte[] valBytes) {
                this.bytes += keyBytes.length + valBytes.length;
                Key kvkey = Key.fromByteArray(keyBytes);
                Value kvvalue = Value.fromByteArray(valBytes);
                this.list.add(new KV(kvkey, kvvalue));
            }

            public List<KV> getList() {
                return this.list;
            }

            public int byteSize() {
                return this.bytes;
            }
        }
    }

    class KV {
        public Key key;
        public Value value;

        public KV(Key key, Value value) {
            this.key = key;
            this.value = value;
        }
    }
}

