/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import java.io.IOException;
import java.io.PrintStream;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.CommandService;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.registry.RegistryUtils;

public class Ping {
    public static final String COMMAND_NAME = "ping";
    public static final String COMMAND_DESC = "attempts to contact a store to get status of running services";
    public static final String COMMAND_ARGS = CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + " " + CommandParser.getUserUsage() + "\n\t" + CommandParser.getSecurityUsage();
    private static boolean verbose = false;
    private static boolean isSecured = false;
    private static PasswordCredentials loginCreds = null;

    public static void main(String[] args) throws RemoteException {
        Topology topology;
        class PingParser
        extends CommandParser {
            PingParser(String[] args1) {
                super(args1);
            }

            public void usage(String errorMsg) {
                if (errorMsg != null) {
                    System.err.println(errorMsg);
                }
                System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar ping\n\t" + COMMAND_ARGS);
                System.exit(-1);
            }

            protected boolean checkArg(String arg) {
                return false;
            }

            protected void verifyArgs() {
                if (this.getHostname() == null) {
                    this.missingArg("-host");
                }
                if (this.getRegistryPort() == 0) {
                    this.missingArg("-port");
                }
            }
        }
        PingParser pp = new PingParser(args);
        pp.parseArgs();
        verbose = pp.getVerbose();
        KVStoreLogin storeLogin = new KVStoreLogin(pp.getUserName(), pp.getSecurityFile());
        Ping.prepareAuthentication(storeLogin);
        if (isSecured) {
            try {
                loginCreds = storeLogin.makeShellLoginCredentials();
            }
            catch (IOException ioe) {
                System.err.println("Failed to get login credentials: " + ioe.getMessage());
                return;
            }
        }
        if ((topology = Ping.getTopology(pp.getHostname(), pp.getRegistryPort())) == null) {
            return;
        }
        Ping.pingTopology(topology, System.err);
    }

    private static void prepareAuthentication(KVStoreLogin storeLogin) {
        try {
            storeLogin.loadSecurityProperties();
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        isSecured = storeLogin.foundSSLTransport();
        storeLogin.prepareRegistryCSF();
    }

    public static String displayStorageNode(Topology topology, StorageNode sn, StorageNodeStatus status) {
        Datacenter dc = topology.get(sn.getDatacenterId());
        String dcName = dc != null ? dc.getName() : "?";
        String dcType = dc != null ? String.valueOf((Object)dc.getDatacenterType()) : "?";
        String snStatus = status != null ? "   Status: " + (Object)((Object)status.getServiceStatus()) + "   Ver: " + status.getKVVersion() : "UNREACHABLE";
        return "Storage Node [" + sn.getResourceId() + "] on " + sn.getHostname() + ":" + sn.getRegistryPort() + "    Zone: [name=" + dcName + " id=" + sn.getDatacenterId() + " type=" + dcType + "] " + snStatus;
    }

    private static void outputStorageNode(Topology topology, StorageNode sn, StorageNodeStatus status, PrintStream out) {
        out.println(Ping.displayStorageNode(topology, sn, status));
    }

    public static String displayRepNode(RepNode rn, RepNodeStatus status) {
        return "\tRep Node [" + rn.getResourceId() + "]\tStatus: " + (status != null ? status + String.format(" at sequence number: %,d", status.getVlsn()) + " haPort: " + status.getHAPort() : "UNREACHABLE");
    }

    private static void outputRepNode(RepNode rn, RepNodeStatus status, PrintStream out) {
        out.println(Ping.displayRepNode(rn, status));
    }

    public static void pingTopology(Topology topology, PrintStream out) {
        final HashMap snmap = new HashMap();
        final HashMap rnmap = new HashMap();
        out.println("Pinging components of store " + topology.getKVStoreName() + " based upon topology sequence #" + topology.getSequenceNumber());
        out.println("Time: " + FormatUtils.formatDateAndTime(System.currentTimeMillis()));
        out.println(topology.getKVStoreName() + " comprises " + topology.getPartitionMap().getNPartitions() + " partitions and " + topology.getStorageNodeMap().size() + " Storage Nodes");
        Ping.forEachStorageNode(topology, new StorageNodeCallback(){

            @Override
            public void nodeCallback(StorageNode sn, StorageNodeStatus status) {
                snmap.put(sn, status);
            }
        });
        Ping.forEachRepNode(topology, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                rnmap.put(rn, status);
            }
        });
        ArrayList sns = new ArrayList(snmap.keySet());
        Collections.sort(sns, new Comparator<StorageNode>(){

            @Override
            public int compare(StorageNode o1, StorageNode o2) {
                return o1.getStorageNodeId().getStorageNodeId() - o2.getStorageNodeId().getStorageNodeId();
            }
        });
        for (StorageNode sn : sns) {
            StorageNodeStatus status = (StorageNodeStatus)snmap.get(sn);
            Ping.outputStorageNode(topology, sn, status, out);
            for (Map.Entry rentry : rnmap.entrySet()) {
                RepNode rn = (RepNode)rentry.getKey();
                if (!sn.getStorageNodeId().equals(rn.getStorageNodeId())) continue;
                Ping.outputRepNode(rn, (RepNodeStatus)rentry.getValue(), out);
            }
        }
    }

    public static Map<ResourceId, ConfigurableService.ServiceStatus> getTopologyStatus(Topology topology) {
        final HashMap<ResourceId, ConfigurableService.ServiceStatus> ret = new HashMap<ResourceId, ConfigurableService.ServiceStatus>();
        Ping.forEachStorageNode(topology, new StorageNodeCallback(){

            @Override
            public void nodeCallback(StorageNode sn, StorageNodeStatus status) {
                ret.put(sn.getResourceId(), status != null ? status.getServiceStatus() : ConfigurableService.ServiceStatus.UNREACHABLE);
            }
        });
        Ping.forEachRepNode(topology, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                ret.put(rn.getResourceId(), status != null ? status.getServiceStatus() : ConfigurableService.ServiceStatus.UNREACHABLE);
            }
        });
        return ret;
    }

    public static RepNode getMaster(Topology topology, RepGroupId rgId) {
        final ArrayList master = new ArrayList();
        Ping.forEachRepNode(topology, rgId, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                if (status != null && status.getReplicationState().isMaster()) {
                    master.add(rn);
                }
            }
        });
        return master.size() == 1 ? (RepNode)master.get(0) : null;
    }

    public static RepNodeStatus getMasterStatus(Topology topology, RepGroupId rgId) {
        final ArrayList master = new ArrayList();
        Ping.forEachRepNode(topology, rgId, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                if (status != null && status.getReplicationState().isMaster()) {
                    master.add(status);
                }
            }
        });
        return master.size() == 1 ? (RepNodeStatus)master.get(0) : null;
    }

    public static Map<RepNodeId, RepNodeStatus> getRepNodeStatus(Topology topology, RepGroupId rgId) {
        final HashMap<RepNodeId, RepNodeStatus> statusMap = new HashMap<RepNodeId, RepNodeStatus>();
        Ping.forEachRepNode(topology, rgId, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                statusMap.put(rn.getResourceId(), status);
            }
        });
        return statusMap;
    }

    private static void forEachStorageNode(Topology topology, StorageNodeCallback callback) {
        RegistryUtils regUtils = new RegistryUtils(topology, null);
        for (StorageNode sn : topology.getStorageNodeMap().getAll()) {
            StorageNodeStatus status;
            block5: {
                status = null;
                try {
                    StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent((StorageNodeId)sn.getResourceId());
                    status = sna.ping();
                }
                catch (RemoteException re) {
                    if (verbose) {
                        System.err.println("Ping failed for " + sn.getResourceId() + ": " + re.getMessage());
                        re.printStackTrace();
                    }
                }
                catch (NotBoundException e) {
                    if (!verbose) break block5;
                    System.err.println("No RMI service for SN: " + sn.getResourceId() + " message: " + e.getMessage());
                }
            }
            callback.nodeCallback(sn, status);
        }
    }

    private static void forEachRepNode(Topology topology, RepNodeCallback callback) {
        RegistryUtils regUtils = new RegistryUtils(topology, null);
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeStatus status;
                block6: {
                    status = null;
                    try {
                        RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                        status = rna.ping();
                    }
                    catch (RemoteException re) {
                        if (verbose) {
                            System.err.println("Ping failed for " + rn.getResourceId() + ": " + re.getMessage());
                            re.printStackTrace();
                        }
                    }
                    catch (NotBoundException e) {
                        if (!verbose) break block6;
                        System.err.println("No RMI service for RN: " + rn.getResourceId() + " message: " + e.getMessage());
                    }
                }
                callback.nodeCallback(rn, status);
            }
        }
    }

    private static void forEachRepNode(Topology topology, RepGroupId rgId, RepNodeCallback callback) {
        RepGroup group = topology.get(rgId);
        if (group == null) {
            return;
        }
        RegistryUtils regUtils = new RegistryUtils(topology, null);
        for (RepNode rn : group.getRepNodes()) {
            RepNodeStatus status;
            block6: {
                status = null;
                try {
                    RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                    status = rna.ping();
                }
                catch (RemoteException re) {
                    if (verbose) {
                        System.err.println("Ping failed for " + rn.getResourceId() + ": " + re.getMessage());
                        re.printStackTrace();
                    }
                }
                catch (NotBoundException e) {
                    if (!verbose) break block6;
                    System.err.println("No RMI service for RN: " + rn.getResourceId() + " message: " + e.getMessage());
                }
            }
            callback.nodeCallback(rn, status);
        }
    }

    public static Topology getTopology(String snHostname, int snRegistryPort) throws RemoteException, AccessException {
        RemoteException exception = null;
        try {
            Registry snRegistry = RegistryUtils.getRegistry(snHostname, snRegistryPort, null);
            for (String serviceName : snRegistry.list()) {
                if ("snaService".equals(serviceName)) {
                    System.err.println("SNA at hostname: " + snHostname + ", registry port: " + snRegistryPort + " is not registered." + "\n\tNo further information is available");
                    return null;
                }
                Remote stub = null;
                try {
                    Topology topology;
                    Object admin;
                    HostPort target;
                    Object loginMgr;
                    stub = snRegistry.lookup(serviceName);
                    if (stub instanceof CommandService) {
                        loginMgr = null;
                        if (isSecured) {
                            loginMgr = KVStoreLogin.getAdminLoginMgr(snHostname, snRegistryPort, loginCreds);
                        }
                        target = new HostPort(snHostname, snRegistryPort);
                        admin = CommandServiceAPI.wrap((CommandService)((CommandService)stub), (LoginHandle)Ping.getLogin((LoginManager)loginMgr, target, ResourceId.ResourceType.ADMIN));
                        return admin.getTopology();
                    }
                    if (!(stub instanceof RepNodeAdmin)) continue;
                    loginMgr = null;
                    if (isSecured) {
                        loginMgr = KVStoreLogin.getRepNodeLoginMgr(snHostname, snRegistryPort, loginCreds, null);
                    }
                    if ((topology = ((RepNodeAdminAPI)(admin = RepNodeAdminAPI.wrap((RepNodeAdmin)stub, Ping.getLogin((LoginManager)loginMgr, target = new HostPort(snHostname, snRegistryPort), ResourceId.ResourceType.REP_NODE)))).getTopology()) == null) continue;
                    return topology;
                }
                catch (AuthenticationFailureException afe) {
                    System.err.println("Login failed.");
                    return null;
                }
                catch (Exception e) {
                    if (!verbose) continue;
                    System.err.println("Failed to " + (stub == null ? "lookup" : "connect to") + " service " + serviceName + " Exception message:" + e.getMessage());
                    e.printStackTrace();
                }
            }
            System.err.println("SNA at hostname: " + snHostname + " registry port: " + snRegistryPort + " has no available Admins or RNs registered.");
        }
        catch (ConnectIOException cioe) {
            exception = cioe;
        }
        catch (ConnectException ce) {
            exception = ce;
        }
        if (exception != null) {
            System.err.println("Could not connect to registry at " + snHostname + ":" + snRegistryPort + ": " + ((Throwable)exception).getMessage());
        }
        return null;
    }

    private static LoginHandle getLogin(LoginManager loginMgr, HostPort target, ResourceId.ResourceType rtype) {
        if (loginMgr == null) {
            return null;
        }
        return loginMgr.getHandle(target, rtype);
    }

    private static interface RepNodeCallback {
        public void nodeCallback(RepNode var1, RepNodeStatus var2);
    }

    private static interface StorageNodeCallback {
        public void nodeCallback(StorageNode var1, StorageNodeStatus var2);
    }
}

