/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriter;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriterException;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import java.io.IOException;
import java.util.Map;

public class JsonConfigWriter
implements ConfigWriter {
    private final JsonGenerator writer;

    public JsonConfigWriter(JsonGenerator writer) {
        this.writer = writer;
    }

    public void writeStartDocument() throws ConfigWriterException {
        try {
            this.writer.writeStartObject();
            this.writer.writeObjectFieldStart("config");
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }

    public void writeEndDocument() throws ConfigWriterException {
        try {
            this.writer.writeEndObject();
            this.writer.writeEndObject();
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }

    public void writeGlobalProperties(Map<String, String> props) throws ConfigWriterException {
        try {
            if (!props.isEmpty()) {
                this.writer.writeObjectFieldStart("global-properties");
                for (Map.Entry<String, String> e : props.entrySet()) {
                    this.writer.writeStringField(e.getKey(), e.getValue());
                }
                this.writer.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }

    public void writeSerializedObjects(Map<String, SerializedObject> map) throws ConfigWriterException {
        try {
            if (!map.isEmpty()) {
                this.writer.writeArrayFieldStart("serialized-objects");
                for (Map.Entry<String, SerializedObject> e : map.entrySet()) {
                    this.writer.writeStartObject();
                    this.writer.writeStringField("name", e.getValue().getName());
                    this.writer.writeStringField("type", e.getValue().getClassName());
                    this.writer.writeStringField("location", e.getValue().getLocation());
                    this.writer.writeEndObject();
                }
                this.writer.writeEndArray();
            }
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }

    public void writeStartComponents() throws ConfigWriterException {
        try {
            this.writer.writeArrayFieldStart("components");
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }

    public void writeComponent(Map<String, String> attributes, Map<String, Property> properties) {
        try {
            this.writer.writeStartObject();
            this.writer.writeStringField("name", attributes.get("name"));
            this.writer.writeStringField("type", attributes.get("type"));
            this.writer.writeStringField("export", attributes.get("export"));
            this.writer.writeStringField("import", attributes.get("import"));
            if (attributes.containsKey("entries")) {
                this.writer.writeStringField("entries", attributes.get("entries"));
            }
            if (attributes.containsKey("leasetime")) {
                this.writer.writeStringField("leasetime", attributes.get("leasetime"));
            }
            if (attributes.containsKey("serialized")) {
                this.writer.writeStringField("serialized", attributes.get("serialized"));
            }
            if (!properties.isEmpty()) {
                this.writer.writeObjectFieldStart("properties");
                for (Map.Entry<String, Property> property : properties.entrySet()) {
                    String key = property.getKey();
                    Property value = property.getValue();
                    if (value instanceof ListProperty) {
                        this.writer.writeArrayFieldStart(key);
                        for (SimpleProperty simpleProperty : ((ListProperty)value).getSimpleList()) {
                            this.writer.writeStartObject();
                            this.writer.writeStringField("item", simpleProperty.getValue());
                            this.writer.writeEndObject();
                        }
                        for (Class clazz : ((ListProperty)value).getClassList()) {
                            this.writer.writeStartObject();
                            this.writer.writeStringField("type", clazz.getName());
                            this.writer.writeEndObject();
                        }
                        this.writer.writeEndArray();
                        continue;
                    }
                    if (value instanceof MapProperty) {
                        this.writer.writeObjectFieldStart(key);
                        for (Map.Entry entry : ((MapProperty)value).getMap().entrySet()) {
                            this.writer.writeStringField((String)entry.getKey(), ((SimpleProperty)entry.getValue()).getValue());
                        }
                        this.writer.writeEndObject();
                        continue;
                    }
                    this.writer.writeStringField(key, value.toString());
                }
                this.writer.writeEndObject();
            }
            this.writer.writeEndObject();
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }

    public void writeEndComponents() throws ConfigWriterException {
        try {
            this.writer.writeEndArray();
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }

    public void close() throws ConfigWriterException {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new ConfigWriterException((Exception)e);
        }
    }
}

