/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.oracle.labs.mlrg.olcut.config.ConfigurationData;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoader;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoaderException;
import com.oracle.labs.mlrg.olcut.config.io.URLLoader;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperties;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsonLoader
implements ConfigLoader {
    private static final Logger logger = Logger.getLogger(JsonLoader.class.getName());
    private final JsonFactory factory;
    private final URLLoader parent;
    private final Map<String, ConfigurationData> rpdMap;
    private final Map<String, ConfigurationData> existingRPD;
    private final Map<String, SerializedObject> serializedObjects;
    private final GlobalProperties globalProperties;
    private String workingDir;

    public JsonLoader(JsonFactory factory, URLLoader parent, Map<String, ConfigurationData> rpdMap, Map<String, ConfigurationData> existingRPD, Map<String, SerializedObject> serializedObjects, GlobalProperties globalProperties) {
        this.factory = factory;
        this.parent = parent;
        this.rpdMap = rpdMap;
        this.existingRPD = existingRPD;
        this.serializedObjects = serializedObjects;
        this.globalProperties = globalProperties;
    }

    public final void load(URL url) throws ConfigLoaderException {
        AccessController.doPrivileged(() -> {
            if (url.getProtocol().equals("file")) {
                this.workingDir = new File(url.getFile()).getParent();
            } else {
                if (IOUtil.isDisallowedProtocol((URL)url)) {
                    throw new ConfigLoaderException("Unable to load configurations from URLs with protocol: " + url.getProtocol());
                }
                this.workingDir = "";
            }
            try (JsonParser parser = this.factory.createParser(url);){
                parser.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
                this.parseJson(parser);
            }
            catch (IOException e) {
                String msg = "Error while parsing " + url.toString() + ": " + e.getMessage();
                throw new ConfigLoaderException((Exception)e, msg);
            }
            return null;
        });
    }

    public void load(InputStream stream) throws ConfigLoaderException {
        try (JsonParser parser = this.factory.createParser(stream);){
            parser.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
            this.parseJson(parser);
        }
        catch (IOException e) {
            String msg = "Error while parsing input: " + e.getMessage();
            throw new ConfigLoaderException((Exception)e, msg);
        }
    }

    public Map<String, ConfigurationData> getPropertyMap() {
        return this.rpdMap;
    }

    public Map<String, SerializedObject> getSerializedObjects() {
        return this.serializedObjects;
    }

    public GlobalProperties getGlobalProperties() {
        return this.globalProperties;
    }

    protected void parseJson(JsonParser parser) {
        block14: {
            ObjectMapper mapper = new ObjectMapper();
            try {
                parser.nextToken();
                if (parser.nextToken() == null) {
                    throw new ConfigLoaderException("Failed to parse JSON, did not start with config object.");
                }
                if (parser.currentName().equals("config")) {
                    parser.nextToken();
                    ObjectNode node = (ObjectNode)mapper.readTree(parser);
                    ObjectNode globalPropertiesNode = (ObjectNode)node.get("global-properties");
                    ArrayNode filesNode = (ArrayNode)node.get("config-files");
                    ArrayNode serializedObjectsNode = (ArrayNode)node.get("serialized-objects");
                    ArrayNode componentsNode = (ArrayNode)node.get("components");
                    if (globalPropertiesNode != null) {
                        Iterator itr = globalPropertiesNode.fields();
                        while (itr.hasNext()) {
                            Map.Entry e = (Map.Entry)itr.next();
                            try {
                                this.globalProperties.setValue((String)e.getKey(), ((JsonNode)e.getValue()).textValue());
                            }
                            catch (PropertyException ex) {
                                throw new ConfigLoaderException("Invalid global property name: " + (String)e.getKey());
                            }
                        }
                    }
                    if (filesNode != null) {
                        for (JsonNode file : filesNode) {
                            this.parseFile((ObjectNode)file);
                        }
                    }
                    if (serializedObjectsNode != null) {
                        for (JsonNode serialized : serializedObjectsNode) {
                            this.parseSerializedObject((ObjectNode)serialized);
                        }
                    }
                    if (componentsNode != null) {
                        for (JsonNode component : componentsNode) {
                            this.parseComponent((ObjectNode)component);
                        }
                    }
                    break block14;
                }
                throw new ConfigLoaderException("Did not start with config object.");
            }
            catch (IOException | ClassCastException e) {
                throw new ConfigLoaderException(e);
            }
        }
    }

    protected void parseComponent(ObjectNode node) {
        ConfigurationData rpd;
        String serializedForm;
        JsonNode entriesNameNode;
        boolean overriding = false;
        JsonNode curComponentNode = node.get("name");
        JsonNode curTypeNode = node.get("type");
        JsonNode overrideNode = node.get("inherit");
        if (curComponentNode == null || curTypeNode == null && overrideNode == null) {
            throw new ConfigLoaderException("Component element must specify 'name' and either 'type' or 'inherit' attributes, found " + node.toString());
        }
        String curComponent = curComponentNode.textValue();
        String curType = curTypeNode != null ? curTypeNode.textValue() : null;
        String override = overrideNode != null ? overrideNode.textValue() : null;
        JsonNode export = node.get("export");
        boolean exportable = export != null && Boolean.parseBoolean(export.textValue());
        JsonNode impNode = node.get("import");
        boolean importable = impNode != null && Boolean.parseBoolean(impNode.textValue());
        JsonNode lt = node.get("leasetime");
        if (export == null && lt != null) {
            throw new ConfigLoaderException("lease timeout " + lt + " specified for component that does not have export set, at node " + node.toString());
        }
        long leaseTime = -1L;
        if (lt != null) {
            try {
                leaseTime = Long.parseLong(lt.textValue());
                if (leaseTime < 0L) {
                    throw new ConfigLoaderException("lease timeout " + lt + " must be greater than 0, for component " + curComponent);
                }
            }
            catch (NumberFormatException nfe) {
                throw new ConfigLoaderException("lease timeout " + lt + " must be a long, for component " + curComponent);
            }
        }
        String entriesName = (entriesNameNode = node.get("entries")) != null ? entriesNameNode.textValue() : null;
        JsonNode serializedFormNode = node.get("serialized");
        String string = serializedForm = serializedFormNode != null ? serializedFormNode.textValue() : null;
        if (override != null) {
            ConfigurationData spd = this.rpdMap.get(override);
            if (spd == null && (spd = this.existingRPD.get(override)) == null) {
                throw new ConfigLoaderException("Override for undefined component: " + override + ", with name " + curComponent);
            }
            if (curType != null && !curType.equals(spd.getClassName())) {
                logger.log(Level.FINE, String.format("Overriding component %s with component %s, new type is %s overridden type was %s", spd.getName(), curComponent, curType, spd.getClassName()));
            }
            if (curType == null) {
                curType = spd.getClassName();
            }
            rpd = new ConfigurationData(curComponent, curType, spd.getProperties(), serializedForm, entriesName, exportable, importable, leaseTime);
            overriding = true;
        } else {
            if (this.rpdMap.get(curComponent) != null) {
                throw new ConfigLoaderException("duplicate definition for " + curComponent);
            }
            rpd = new ConfigurationData(curComponent, curType, serializedForm, entriesName, exportable, importable, leaseTime);
        }
        ObjectNode properties = (ObjectNode)node.get("properties");
        if (properties != null) {
            Iterator fieldsItr = properties.fields();
            while (fieldsItr.hasNext()) {
                Map.Entry e = (Map.Entry)fieldsItr.next();
                String propName = (String)e.getKey();
                if (e.getValue() instanceof ArrayNode) {
                    ArrayList<SimpleProperty> listOutput = new ArrayList<SimpleProperty>();
                    ArrayList classListOutput = new ArrayList();
                    ArrayNode listNode = (ArrayNode)e.getValue();
                    for (JsonNode element : listNode) {
                        if (element.size() > 1) {
                            throw new ConfigLoaderException("Too many elements in a propertylist item, found " + element);
                        }
                        Iterator listElementItr = element.fields();
                        block14: while (listElementItr.hasNext()) {
                            String elementName;
                            Map.Entry elementEntry = (Map.Entry)listElementItr.next();
                            switch (elementName = (String)elementEntry.getKey()) {
                                case "item": {
                                    listOutput.add(new SimpleProperty(((JsonNode)elementEntry.getValue()).textValue()));
                                    continue block14;
                                }
                                case "type": {
                                    try {
                                        classListOutput.add(Class.forName(((JsonNode)elementEntry.getValue()).textValue()));
                                        continue block14;
                                    }
                                    catch (ClassNotFoundException cnfe) {
                                        throw new ConfigLoaderException("Unable to find class " + ((JsonNode)elementEntry.getValue()).textValue() + " in component " + curComponent + ", propertylist " + propName);
                                    }
                                }
                            }
                            throw new ConfigLoaderException("Unknown node in component " + curComponent + ", propertylist " + propName + ", node = " + ((JsonNode)e.getValue()).toString());
                        }
                    }
                    ListProperty listProp = classListOutput.isEmpty() ? new ListProperty(listOutput) : new ListProperty(listOutput, classListOutput);
                    rpd.add(propName, (Property)listProp);
                    continue;
                }
                if (e.getValue() instanceof ObjectNode) {
                    HashMap mapOutput = new HashMap();
                    Iterator mapElementItr = ((JsonNode)e.getValue()).fields();
                    while (mapElementItr.hasNext()) {
                        Map.Entry mapEntry = (Map.Entry)mapElementItr.next();
                        if (((JsonNode)mapEntry.getValue()).isTextual()) {
                            mapOutput.put(mapEntry.getKey(), new SimpleProperty(((JsonNode)mapEntry.getValue()).textValue()));
                            continue;
                        }
                        throw new ConfigLoaderException("Unknown node in component " + curComponent + ", propertymap " + propName + ", node = " + ((JsonNode)e.getValue()).toString());
                    }
                    rpd.add(propName, (Property)new MapProperty(mapOutput));
                    continue;
                }
                rpd.add(propName, (Property)new SimpleProperty(((JsonNode)e.getValue()).textValue()));
            }
        }
        this.rpdMap.put(rpd.getName(), rpd);
    }

    protected void parseFile(ObjectNode node) {
        JsonNode name = node.get("name");
        JsonNode value = node.get("value");
        if (name == null || value == null) {
            throw new ConfigLoaderException("File element must have 'name' and 'value' attributes, found " + node.toString());
        }
        try {
            String path = value.textValue();
            URL newURL = ConfigurationManager.class.getResource(path);
            if (newURL == null) {
                File newFile = new File(path);
                if (!newFile.isAbsolute()) {
                    newFile = new File(this.workingDir, path);
                }
                newURL = newFile.toURI().toURL();
            }
            this.parent.addURL(newURL);
        }
        catch (MalformedURLException ex) {
            throw new ConfigLoaderException((Exception)ex, "Incorrectly formatted file element " + name.textValue() + " with value " + value.textValue());
        }
    }

    protected void parseSerializedObject(ObjectNode node) {
        JsonNode name = node.get("name");
        JsonNode type = node.get("type");
        JsonNode location = node.get("location");
        if (name == null || type == null || location == null) {
            throw new ConfigLoaderException("Serialized element must have 'name', 'type' and 'location' elements, found " + node.toString());
        }
        this.serializedObjects.put(name.textValue(), new SerializedObject(name.textValue(), location.textValue(), type.textValue()));
    }
}

