/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.oracle.labs.mlrg.olcut.provenance.io.FlatMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ListMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.MapMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.MarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ObjectMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.SimpleMarshalledProvenance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonProvenanceDeserializer
extends StdDeserializer<MarshalledProvenance> {
    public JsonProvenanceDeserializer(Class<? extends MarshalledProvenance> provClass) {
        super(provClass);
    }

    public MarshalledProvenance deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        JsonNode classNode = node.get("marshalled-class");
        if (classNode != null) {
            String className = classNode.textValue();
            if (ListMarshalledProvenance.class.getName().equals(className)) {
                JsonNode arrayNode = node.get("list");
                if (arrayNode != null) {
                    ArrayList<FlatMarshalledProvenance> list = new ArrayList<FlatMarshalledProvenance>();
                    for (JsonNode n : arrayNode) {
                        FlatMarshalledProvenance fmp = (FlatMarshalledProvenance)oc.treeToValue((TreeNode)n, MarshalledProvenance.class);
                        list.add(fmp);
                    }
                    return new ListMarshalledProvenance(list);
                }
                throw new JsonParseException(jsonParser, "list field not found in ListMarshalledProvenance.");
            }
            if (MapMarshalledProvenance.class.getName().equals(className)) {
                JsonNode objectNode = node.get("map");
                if (objectNode != null) {
                    HashMap map = new HashMap();
                    Iterator it = objectNode.fields();
                    while (it.hasNext()) {
                        Map.Entry n = (Map.Entry)it.next();
                        map.put(n.getKey(), (FlatMarshalledProvenance)oc.treeToValue((TreeNode)n.getValue(), MarshalledProvenance.class));
                    }
                    return new MapMarshalledProvenance(map);
                }
                throw new JsonParseException(jsonParser, "map field not found in MapMarshalledProvenance.");
            }
            if (ObjectMarshalledProvenance.class.getName().equals(className)) {
                if (node.has("object-name") && node.has("object-class-name") && node.has("provenance-class") && node.has("map")) {
                    String objectName = node.get("object-name").textValue();
                    String objectClassName = node.get("object-class-name").textValue();
                    String provenanceClass = node.get("provenance-class").textValue();
                    JsonNode objectNode = node.get("map");
                    HashMap map = new HashMap();
                    Iterator it = objectNode.fields();
                    while (it.hasNext()) {
                        Map.Entry n = (Map.Entry)it.next();
                        map.put(n.getKey(), (FlatMarshalledProvenance)oc.treeToValue((TreeNode)n.getValue(), MarshalledProvenance.class));
                    }
                    return new ObjectMarshalledProvenance(objectName, map, objectClassName, provenanceClass);
                }
                throw new JsonParseException(jsonParser, "ObjectMarshalledProvenance was missing a required field.");
            }
            if (SimpleMarshalledProvenance.class.getName().equals(className)) {
                if (node.has("key") && node.has("value") && node.has("provenance-class") && node.has("additional") && node.has("is-reference")) {
                    String key = node.get("key").textValue();
                    String value = node.get("value").textValue();
                    String provenanceClass = node.get("provenance-class").textValue();
                    String additional = node.get("additional").textValue();
                    boolean isReference = node.get("is-reference").asBoolean();
                    return new SimpleMarshalledProvenance(key, value, provenanceClass, isReference, additional);
                }
                throw new JsonParseException(jsonParser, "SimpleMarshalledProvenance was missing a required field.");
            }
            throw new JsonParseException(jsonParser, "Unexpected marshalled provenance class, found " + className);
        }
        throw new JsonParseException(jsonParser, "Marshalled provenance json did not contain subclass name.");
    }
}

