/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.oracle.labs.mlrg.olcut.config.json.JsonProvenanceModule;
import com.oracle.labs.mlrg.olcut.provenance.io.MarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ObjectMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ProvenanceSerialization;
import com.oracle.labs.mlrg.olcut.provenance.io.ProvenanceSerializationException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class JsonProvenanceSerialization
implements ProvenanceSerialization {
    private static final TypeReference<List<MarshalledProvenance>> typeRef = new TypeReference<List<MarshalledProvenance>>(){};
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonProvenanceSerialization(boolean indentOutput) {
        this.mapper.registerModule((Module)new JsonProvenanceModule());
        if (indentOutput) {
            this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public String getFileExtension() {
        return "json";
    }

    public List<ObjectMarshalledProvenance> deserializeFromFile(Path path) throws ProvenanceSerializationException, IOException {
        try {
            List jsonProvenances = (List)this.mapper.readValue(path.toFile(), typeRef);
            return JsonProvenanceSerialization.convertMarshalledProvenanceList(jsonProvenances);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ProvenanceSerializationException("Failed to parse JSON", (Exception)e);
        }
    }

    public List<ObjectMarshalledProvenance> deserializeFromString(String input) throws ProvenanceSerializationException {
        try {
            List jsonProvenances = (List)this.mapper.readValue(input, typeRef);
            return JsonProvenanceSerialization.convertMarshalledProvenanceList(jsonProvenances);
        }
        catch (JsonProcessingException e) {
            throw new ProvenanceSerializationException("Failed to deserialize provenance", (Exception)((Object)e));
        }
    }

    private static List<ObjectMarshalledProvenance> convertMarshalledProvenanceList(List<MarshalledProvenance> provenances) {
        ArrayList<ObjectMarshalledProvenance> jps = new ArrayList<ObjectMarshalledProvenance>();
        for (MarshalledProvenance mp : provenances) {
            if (mp instanceof ObjectMarshalledProvenance) {
                jps.add((ObjectMarshalledProvenance)mp);
                continue;
            }
            throw new IllegalArgumentException("Invalid provenance found, expected ObjectMarshalledProvenance, found " + mp);
        }
        return jps;
    }

    public String serializeToString(List<ObjectMarshalledProvenance> marshalledProvenances) {
        try {
            return this.mapper.writeValueAsString(marshalledProvenances);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize provenance", e);
        }
    }

    public void serializeToFile(List<ObjectMarshalledProvenance> marshalledProvenances, Path path) throws IOException {
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(path.toFile())));){
            writer.println(this.serializeToString(marshalledProvenances));
        }
    }
}

