/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.oracle.labs.mlrg.olcut.provenance.io.FlatMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ListMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.MapMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.MarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.ObjectMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.io.SimpleMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.IOException;
import java.util.Map;

public class JsonProvenanceSerializer
extends StdSerializer<MarshalledProvenance> {
    public JsonProvenanceSerializer(Class<MarshalledProvenance> provClass) {
        super(provClass);
    }

    public void serialize(MarshalledProvenance marshalledProvenance, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Class<?> provClass = marshalledProvenance.getClass();
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("marshalled-class", provClass.getName());
        if (marshalledProvenance instanceof ListMarshalledProvenance) {
            ListMarshalledProvenance lmp = (ListMarshalledProvenance)marshalledProvenance;
            jsonGenerator.writeArrayFieldStart("list");
            for (FlatMarshalledProvenance e : lmp) {
                jsonGenerator.writeObject((Object)e);
            }
            jsonGenerator.writeEndArray();
        } else if (marshalledProvenance instanceof MapMarshalledProvenance) {
            MapMarshalledProvenance mmp = (MapMarshalledProvenance)marshalledProvenance;
            jsonGenerator.writeObjectFieldStart("map");
            for (Pair e : mmp) {
                jsonGenerator.writeObjectField((String)e.getA(), e.getB());
            }
            jsonGenerator.writeEndObject();
        } else if (marshalledProvenance instanceof ObjectMarshalledProvenance) {
            ObjectMarshalledProvenance omp = (ObjectMarshalledProvenance)marshalledProvenance;
            jsonGenerator.writeStringField("object-name", omp.getName());
            jsonGenerator.writeStringField("object-class-name", omp.getObjectClassName());
            jsonGenerator.writeStringField("provenance-class", omp.getProvenanceClassName());
            jsonGenerator.writeObjectFieldStart("map");
            for (Map.Entry e : omp.getMap().entrySet()) {
                jsonGenerator.writeObjectField((String)e.getKey(), e.getValue());
            }
            jsonGenerator.writeEndObject();
        } else if (marshalledProvenance instanceof SimpleMarshalledProvenance) {
            SimpleMarshalledProvenance smp = (SimpleMarshalledProvenance)marshalledProvenance;
            jsonGenerator.writeStringField("key", smp.getKey());
            jsonGenerator.writeStringField("value", smp.getValue());
            jsonGenerator.writeStringField("provenance-class", smp.getProvenanceClassName());
            jsonGenerator.writeStringField("additional", smp.getAdditional());
            jsonGenerator.writeBooleanField("is-reference", smp.isReference());
        } else {
            throw new IOException("Unexpected provenance class, found " + provClass.getName());
        }
        jsonGenerator.writeEndObject();
    }
}

