/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.common;

import com.oracle.microtx.common.MicroTxLinkHeaderVal;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.tmm.tcc.TccCoordintorClient;

public abstract class AbstractMicroTxInterceptor {
    public static final String AUTHORIZATION_HEADER = "authorization";
    public static final String ORACLE_TMM_AUTHZ_TOKEN = "oracle-tmm-authz-token";
    public static final String ORACLE_TMM_CUSTOM_AUTHZ_TOKEN = "oracle-tmm-custom-authz-token";
    public static final String HEADER_TRANSACTION_TOKEN = "oracle-tmm-tx-token";
    public static final String HEADER_TRANSACTION_START_TIME = "oracle-tmm-req-start-time";
    public static final String[] TRACE_HEADERS = new String[]{"x-request-id", "x-ot-span-context", "x-datadog-trace-id", "x-datadog-parent-id", "x-datadog-sampling-priority", "traceparent", "tracestate", "x-cloud-trace-context", "grpc-trace-bin", "x-b3-traceid", "x-b3-spanid", "x-b3-parentspanid", "x-b3-sampled", "x-b3-flags", "end-user"};
    public static final String[] AUTHZ_HEADERS = new String[]{"oracle-tmm-tx-token", "authorization", "refresh-token", "oracle-tmm-authz-token"};

    public static <K, V> String getSanitizedHeaders(Map<K, V> headers) {
        if (headers != null && !headers.isEmpty()) {
            Map<String, String> sanitizedHeaders = headers.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString().toLowerCase(), entry -> entry.getValue().toString()));
            Arrays.stream(AUTHZ_HEADERS).forEach(authzHeader -> sanitizedHeaders.remove(authzHeader));
            sanitizedHeaders.remove(ORACLE_TMM_CUSTOM_AUTHZ_TOKEN);
            return sanitizedHeaders.toString();
        }
        return "";
    }

    public static StringBuilder buildLinkHeader(StringBuilder linkHeaderBuilder, String uriPrefix, String linkVal, String rel) {
        if (linkVal != null && rel != null) {
            String linkUri = uriPrefix == null ? linkVal : String.format("%s%s", uriPrefix, linkVal);
            String linkUriVal = "<" + linkUri + ">; rel=" + rel;
            return linkHeaderBuilder.length() != 0 ? linkHeaderBuilder.append(',').append(linkUriVal) : linkHeaderBuilder.append(linkUriVal);
        }
        return linkHeaderBuilder;
    }

    public String buildTccParticipantsAsLinkHeader(TccCoordintorClient tccTransaction) {
        StringBuilder linkHeaderValue = new StringBuilder();
        tccTransaction.getTccParticipants().forEach(participant -> {
            MicroTxLinkHeaderVal link = new MicroTxLinkHeaderVal.Builder().baseUri(participant.getUri()).rel("https://otmm.oracle.com/tcc-participant").param("timeLimit", String.valueOf(participant.getTimeLimit())).build();
            linkHeaderValue.append(",").append(link.toString());
        });
        AbstractMicroTxInterceptor.buildLinkHeader(linkHeaderValue, null, tccTransaction.getTransactionUrl(), "https://otmm.oracle.com/tcc-transaction");
        return linkHeaderValue.length() > 1 ? linkHeaderValue.substring(1) : "";
    }
}

