/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.common;

import com.oracle.microtx.common.AbstractMicroTxInterceptor;
import feign.RequestTemplate;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ClientRequest;

@Service
public class HeaderPropagation {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void propagateTraceHeaders(HttpRequest request, Map<String, List<String>> transactionRequestHeaders) {
        if (request != null && transactionRequestHeaders != null) {
            for (String header : AbstractMicroTxInterceptor.TRACE_HEADERS) {
                if (!transactionRequestHeaders.containsKey(header)) continue;
                List<String> values = transactionRequestHeaders.get(header);
                request.getHeaders().add(header, values.size() == 1 ? values.get(0) : values.toString());
                LOGGER.debug("Header Propagated: {} : {}", (Object)header, (Object)(values.size() == 1 ? values.get(0) : values.toString()));
            }
        }
    }

    public void propagateTraceHeaders(RequestTemplate request, Map<String, List<String>> transactionRequestHeaders) {
        if (request != null && transactionRequestHeaders != null) {
            for (String header : AbstractMicroTxInterceptor.TRACE_HEADERS) {
                if (!transactionRequestHeaders.containsKey(header)) continue;
                List<String> values = transactionRequestHeaders.get(header);
                request.header(header, new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                LOGGER.debug("Header Propagated: {} : {}", (Object)header, (Object)(values.size() == 1 ? values.get(0) : values.toString()));
            }
        }
    }

    public void propagateAuthzHeaders(HttpRequest request, Map<String, List<String>> transactionRequestHeaders) {
        if (request != null && transactionRequestHeaders != null) {
            for (String header : AbstractMicroTxInterceptor.AUTHZ_HEADERS) {
                if (!transactionRequestHeaders.containsKey(header)) continue;
                List<String> values = transactionRequestHeaders.get(header);
                if (header.equals("authorization") && transactionRequestHeaders.containsKey("oracle-tmm-authz-token") && request.getHeaders().containsKey((Object)"oracle-tmm-txn-id")) {
                    request.getHeaders().add("authorization", transactionRequestHeaders.get("oracle-tmm-authz-token").get(0));
                    request.getHeaders().add("oracle-tmm-custom-authz-token", values.size() == 1 ? values.get(0) : values.toString());
                    LOGGER.debug("Authz Header Propagated: " + header);
                    continue;
                }
                if (header.equals("authorization") && request.getHeaders().containsKey((Object)header)) {
                    request.getHeaders().add("oracle-tmm-authz-token", values.size() == 1 ? values.get(0) : values.toString());
                    LOGGER.debug("Added custom Authz Header Propagated: oracle-tmm-authz-token");
                    continue;
                }
                if (request.getHeaders().containsKey((Object)header)) continue;
                request.getHeaders().add(header, values.size() == 1 ? values.get(0) : values.toString());
                LOGGER.debug("Authz Header Propagated: {}", (Object)header);
            }
        }
    }

    public void propagateAuthzHeaders(RequestTemplate request, Map<String, List<String>> transactionRequestHeaders) {
        if (request != null && transactionRequestHeaders != null) {
            for (String header : AbstractMicroTxInterceptor.AUTHZ_HEADERS) {
                if (!transactionRequestHeaders.containsKey(header)) continue;
                List<String> values = transactionRequestHeaders.get(header);
                if (header.equals("authorization") && transactionRequestHeaders.containsKey("oracle-tmm-authz-token") && request.headers().containsKey("oracle-tmm-txn-id")) {
                    request.header("authorization", new String[]{transactionRequestHeaders.get("oracle-tmm-authz-token").get(0)});
                    request.header("oracle-tmm-custom-authz-token", new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                    LOGGER.debug("Authz Header Propagated: " + header);
                    continue;
                }
                if (header.equals("authorization") && request.headers().containsKey(header)) {
                    request.header("oracle-tmm-authz-token", new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                    LOGGER.debug("Added custom Authz Header Propagated: oracle-tmm-authz-token");
                    continue;
                }
                if (request.headers().containsKey(header)) continue;
                request.header(header, new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                LOGGER.debug("Authz Header Propagated: {}", (Object)header);
            }
        }
    }

    public void propagateTraceHeaders(ClientRequest request, ClientRequest.Builder requestBuilder, Map<String, List<String>> transactionRequestHeaders) {
        if (requestBuilder != null && transactionRequestHeaders != null) {
            for (String header : AbstractMicroTxInterceptor.TRACE_HEADERS) {
                if (!transactionRequestHeaders.containsKey(header)) continue;
                List<String> values = transactionRequestHeaders.get(header);
                requestBuilder.header(header, new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                LOGGER.debug("Header Propagated: " + header + ": " + (values.size() == 1 ? values.get(0) : values.toString()));
            }
        }
    }

    public void propagateAuthzHeaders(ClientRequest request, ClientRequest.Builder requestBuilder, Map<String, List<String>> transactionRequestHeaders) {
        if (requestBuilder != null && transactionRequestHeaders != null) {
            for (String header : AbstractMicroTxInterceptor.AUTHZ_HEADERS) {
                if (!transactionRequestHeaders.containsKey(header)) continue;
                List<String> values = transactionRequestHeaders.get(header);
                if (header.equals("authorization") && transactionRequestHeaders.containsKey("oracle-tmm-authz-token") && request.headers().containsKey((Object)"oracle-tmm-txn-id")) {
                    requestBuilder.header("authorization", new String[]{transactionRequestHeaders.get("oracle-tmm-authz-token").get(0)});
                    requestBuilder.header("oracle-tmm-custom-authz-token", new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                    LOGGER.debug("Authz Header Propagated: " + header);
                    continue;
                }
                if (header.equals("authorization") && request.headers().containsKey((Object)header)) {
                    requestBuilder.header("oracle-tmm-authz-token", new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                    LOGGER.debug("Added custom Authz Header Propagated: oracle-tmm-authz-token");
                    continue;
                }
                if (request.headers().containsKey((Object)header)) continue;
                requestBuilder.header(header, new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                LOGGER.debug("Authz Header Propagated: {}", (Object)header);
            }
        }
    }

    public void propagateMicroTxTransactionTokenHeader(ClientRequest request, ClientRequest.Builder requestBuilder, Map<String, List<String>> transactionRequestHeaders) {
        String header;
        if (requestBuilder != null && transactionRequestHeaders != null && transactionRequestHeaders.containsKey(header = "oracle-tmm-tx-token")) {
            List<String> values = transactionRequestHeaders.get(header);
            if (!request.headers().containsKey((Object)header)) {
                requestBuilder.header(header, new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                LOGGER.debug("Transaction Promotion Use Case ,Oracle Transaction token Header Propagated: {}", (Object)header);
            }
        }
    }

    public void propagateMicroTxTransactionTokenHeader(HttpRequest request, Map<String, List<String>> transactionRequestHeaders) {
        String header;
        if (request != null && transactionRequestHeaders != null && transactionRequestHeaders.containsKey(header = "oracle-tmm-tx-token")) {
            List<String> values = transactionRequestHeaders.get(header);
            if (!request.getHeaders().containsKey((Object)header)) {
                request.getHeaders().add(header, values.size() == 1 ? values.get(0) : values.toString());
                LOGGER.debug("Transaction Promotion Use Case ,Oracle Transaction token Header Propagated: {}", (Object)header);
            }
        }
    }

    public void propagateMicroTxTransactionTokenHeader(RequestTemplate request, Map<String, List<String>> transactionRequestHeaders) {
        String header;
        if (request != null && transactionRequestHeaders != null && transactionRequestHeaders.containsKey(header = "oracle-tmm-tx-token")) {
            List<String> values = transactionRequestHeaders.get(header);
            if (!request.headers().containsKey(header)) {
                request.header(header, new String[]{values.size() == 1 ? values.get(0) : values.toString()});
                LOGGER.debug("Transaction Promotion Use Case ,Oracle Transaction token Header Propagated: {}", (Object)header);
            }
        }
    }
}

