/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.common;

import jakarta.persistence.EntityManagerFactory;
import javax.sql.XADataSource;
import oracle.tmm.jta.common.DataSourceInfo;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.TrmXAResourceType;
import oracle.ucp.jdbc.PoolXADataSourceImpl;

public class MicroTxConfig {
    public static final String DEFAULT_RMID_STRING = "default";
    public static final String MDC_TXN_KEY = "microtx-txnId";
    public static final String HEADER_LINK_TEXT = "Link";
    public static final String HEADER_ORACLE_TMM_TXN_ID_TEXT = "oracle-tmm-txn-id";
    public static String resourceManagerId;
    public static String coordinatorUrl;
    public static String participantCallBackUrl;
    public static long llrDeleteCommitRecordTimeInterval;
    public static boolean xaPromotableActive;
    public static int transactionTimeout;
    public static Boolean propagateTraceHeaders;
    public static TrmXAResourceType trmXAResourceType;
    public static Boolean xaRacActive;
    public static Boolean xaWeblogicTransactionSupport;
    public static int httpClientConnectionPoolSize;
    public static Boolean xaXaSupport;
    public static Boolean xaLLRSupport;
    public static Boolean xaLRCSupport;
    public static String wlsNamespace;

    private MicroTxConfig() {
    }

    public static String getResourceManagerId() {
        return resourceManagerId;
    }

    public static void setResourceManagerId(String resourceManagerId) {
        MicroTxConfig.resourceManagerId = resourceManagerId;
    }

    public static String getCoordinatorUrl() {
        return coordinatorUrl;
    }

    public static void setCoordinatorUrl(String coordinatorUrl) {
        MicroTxConfig.coordinatorUrl = coordinatorUrl;
    }

    public static String getParticipantCallBackUrl() {
        return participantCallBackUrl;
    }

    public static void setParticipantCallBackUrl(String participantCallBackUrl) {
        MicroTxConfig.participantCallBackUrl = participantCallBackUrl;
    }

    public static int getHttpClientConnectionPoolSize() {
        return httpClientConnectionPoolSize;
    }

    public static void setHttpClientConnectionPoolSize(int httpClientConnectionPoolSize) {
        MicroTxConfig.httpClientConnectionPoolSize = httpClientConnectionPoolSize;
    }

    public static String getWlsNamespace() {
        return wlsNamespace;
    }

    public static void setWlsNamespace(String wlsNamespace) {
        MicroTxConfig.wlsNamespace = wlsNamespace;
    }

    public static long getLlrDeleteCommitRecordTimeInterval() {
        return llrDeleteCommitRecordTimeInterval;
    }

    public static void setLlrDeleteCommitRecordTimeInterval(long llrCommitRecordTimeInterval) {
        llrDeleteCommitRecordTimeInterval = llrCommitRecordTimeInterval;
    }

    public static boolean isXaPromotableActive() {
        return xaPromotableActive;
    }

    public static void setXaPromotableActive(boolean xaPromotableActive) {
        MicroTxConfig.xaPromotableActive = xaPromotableActive;
    }

    public static int getXaTransactionTimeout() {
        return transactionTimeout;
    }

    public static void setTransactionTimeout(int transactionTimeout) {
        MicroTxConfig.transactionTimeout = transactionTimeout;
    }

    public static Boolean isPropagateTraceHeadersActive() {
        return propagateTraceHeaders;
    }

    public static void setPropagateTraceHeaders(Boolean propagateTraceHeaders) {
        MicroTxConfig.propagateTraceHeaders = propagateTraceHeaders;
    }

    public static TrmXAResourceType getTrmXAResourceType() {
        return trmXAResourceType;
    }

    public static void setTrmXAResourceType(TrmXAResourceType trmXAResourceType) {
        MicroTxConfig.trmXAResourceType = trmXAResourceType;
    }

    public static Boolean isXaRacActive() {
        return xaRacActive;
    }

    public static void setXaRacActive(Boolean xaRacActive) {
        MicroTxConfig.xaRacActive = xaRacActive;
    }

    public static Boolean getXaWeblogicTransactionSupport() {
        return xaWeblogicTransactionSupport;
    }

    public static void setXaWeblogicTransactionSupport(Boolean xaWeblogicTransactionSupport) {
        MicroTxConfig.xaWeblogicTransactionSupport = xaWeblogicTransactionSupport;
    }

    public static Boolean isXaXaSupport() {
        return xaXaSupport;
    }

    public static void setXaXaSupport(Boolean xaXaSupport) {
        MicroTxConfig.xaXaSupport = xaXaSupport;
    }

    public static Boolean isXaLLRSupport() {
        return xaLLRSupport;
    }

    public static void setXaLLRSupport(Boolean xaLLRSupport) {
        MicroTxConfig.xaLLRSupport = xaLLRSupport;
    }

    public static Boolean isXaLRCSupport() {
        return xaLRCSupport;
    }

    public static void setXaLRCSupport(Boolean xaLRCSupport) {
        MicroTxConfig.xaLRCSupport = xaLRCSupport;
    }

    public static XADataSource getXaDataSource(String rmid) {
        return TrmXAResourceManager.getXaDS(rmid);
    }

    public static XADataSource getXaDataSource() {
        return TrmXAResourceManager.getXaDS(resourceManagerId);
    }

    public static TrmXAResourceType getXaDataSourceType(XADataSource xaDataSource) {
        if (xaDataSource.getClass().getName().contains("PGXADataSource") || xaDataSource instanceof PoolXADataSourceImpl && ((PoolXADataSourceImpl)xaDataSource).getConnectionFactoryClassName().equalsIgnoreCase("org.postgresql.xa.PGXADataSource")) {
            return TrmXAResourceType.PostgreSQL;
        }
        return TrmXAResourceType.Oracle;
    }

    public static void initXaDataSource(XADataSource xaDataSource, String rmid) {
        DataSourceInfo dataSourceInfo = new DataSourceInfo(rmid);
        dataSourceInfo.setDatabaseType(MicroTxConfig.getXaDataSourceType(xaDataSource));
        dataSourceInfo.setRAC(xaRacActive);
        TrmXAResourceManager.init(xaDataSource, dataSourceInfo);
    }

    public static void initXaDataSource(XADataSource xaDataSource) {
        DataSourceInfo dataSourceInfo = new DataSourceInfo(resourceManagerId);
        dataSourceInfo.setDatabaseType(MicroTxConfig.getXaDataSourceType(xaDataSource));
        dataSourceInfo.setRAC(xaRacActive);
        TrmXAResourceManager.init(xaDataSource, dataSourceInfo);
    }

    public static void initXaDataSource(XADataSource xaDataSource, DataSourceInfo dataSourceInfo) {
        dataSourceInfo.setDatabaseType(MicroTxConfig.getXaDataSourceType(xaDataSource));
        dataSourceInfo.setRAC(xaRacActive);
        TrmXAResourceManager.init(xaDataSource, dataSourceInfo);
    }

    public static void initEntityManagerFactory(EntityManagerFactory entityManagerFactory, String dataSourceName, String rmid) {
        DataSourceInfo dataSourceInfo = new DataSourceInfo(rmid);
        dataSourceInfo.setDataSourceName(dataSourceName);
        dataSourceInfo.setRAC(xaRacActive);
        TrmXAResourceManager.init(entityManagerFactory, dataSourceInfo);
    }

    public static void initEntityManagerFactory(EntityManagerFactory entityManagerFactory, DataSourceInfo dataSourceInfo) {
        TrmXAResourceManager.init(entityManagerFactory, dataSourceInfo);
    }

    public static void initEntityManagerFactory(EntityManagerFactory entityManagerFactory, String dataSourceName, String rmid, TrmXAResourceType resourceType) {
        DataSourceInfo dataSourceInfo = new DataSourceInfo(rmid);
        dataSourceInfo.setDataSourceName(dataSourceName);
        dataSourceInfo.setDatabaseType(resourceType);
        dataSourceInfo.setRAC(xaRacActive);
        TrmXAResourceManager.init(entityManagerFactory, dataSourceInfo);
    }

    public static void initEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        MicroTxConfig.initEntityManagerFactory(entityManagerFactory, "", resourceManagerId);
    }

    public static void initEntityManagerFactory(EntityManagerFactory entityManagerFactory, TrmXAResourceType resourceType) {
        DataSourceInfo dataSourceInfo = new DataSourceInfo(resourceManagerId);
        dataSourceInfo.setDatabaseType(resourceType);
        dataSourceInfo.setRAC(xaRacActive);
        TrmXAResourceManager.init(entityManagerFactory, dataSourceInfo);
    }

    public static void initEntityManagerFactory(EntityManagerFactory entityManagerFactory, String rmid) {
        MicroTxConfig.initEntityManagerFactory(entityManagerFactory, "", rmid);
    }

    static {
        trmXAResourceType = TrmXAResourceType.Oracle;
        xaRacActive = false;
        xaWeblogicTransactionSupport = false;
    }
}

