/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.common;

import com.oracle.microtx.exception.MicroTxException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class MicroTxLinkHeaderVal {
    private URI uri;
    private Map<String, String> linkParams;

    public MicroTxLinkHeaderVal(URI uri, Map<String, String> linkParams) {
        this.uri = uri;
        this.linkParams = linkParams;
    }

    private MicroTxLinkHeaderVal(Builder builder) {
        this.setUri(builder.baseUri);
        this.setLinkParams(builder.linkParams);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getRel() {
        return this.linkParams.get("rel");
    }

    public List<String> getRels() {
        String rels = this.linkParams.get("rel");
        return rels == null ? Collections.emptyList() : Arrays.asList(rels.split(" +"));
    }

    public String getTitle() {
        return this.linkParams.get("title");
    }

    public String getType() {
        return this.linkParams.get("type");
    }

    public Map<String, String> getlinkParams() {
        return this.linkParams;
    }

    public void setLinkParams(Map<String, String> params) {
        this.linkParams = params;
    }

    public String toString() {
        if (this.uri == null) {
            throw new MicroTxException("URI is null , Cannot form String");
        }
        Map<String, String> map = this.getlinkParams();
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(this.getUri()).append('>');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("; ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MicroTxLinkHeaderVal)) {
            return false;
        }
        MicroTxLinkHeaderVal otherLink = (MicroTxLinkHeaderVal)other;
        return this.uri.equals(otherLink.getUri()) && this.linkParams.equals(otherLink.getlinkParams());
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 89 * hash + (this.linkParams != null ? this.linkParams.hashCode() : 0);
        return hash;
    }

    public static class Builder {
        private URI baseUri = null;
        private Map<String, String> linkParams = new HashMap<String, String>();

        private static void checkParamToken(StringTokenizer st, String expected) throws IllegalArgumentException {
            String token;
            while ((token = st.nextToken().trim()).length() == 0) {
            }
            if (!token.equals(expected)) {
                throw new IllegalArgumentException("Expected token " + expected + " but found " + token);
            }
        }

        private static String nonEmptyTokenNext(StringTokenizer st) throws IllegalArgumentException {
            String token;
            while ((token = st.nextToken().trim()).length() == 0) {
            }
            return token;
        }

        public Builder baseUri(URI uri) {
            this.baseUri = uri;
            return this;
        }

        public Builder baseUri(String uri) {
            this.baseUri = URI.create(uri);
            return this;
        }

        public Builder rel(String rel) {
            String rels = this.linkParams.get("rel");
            this.param("rel", rels == null ? rel : rels + " " + rel);
            return this;
        }

        public Builder title(String title) {
            this.param("title", title);
            return this;
        }

        public Builder type(String type) {
            this.param("type", type);
            return this;
        }

        public Builder param(String name, String value) {
            if (name != null && value != null) {
                this.linkParams.put(name, value);
                return this;
            }
            throw new IllegalArgumentException("Link parameter name or value is null");
        }

        public Builder valueOf(String value) {
            if (value == null || value.isEmpty()) {
                throw new MicroTxException("The provided participant String not valid");
            }
            try {
                value = value.trim();
                if (!value.startsWith("<")) {
                    throw new IllegalArgumentException("Missing starting token < in " + value);
                }
                int gtIndex = value.indexOf(62);
                if (gtIndex == -1) {
                    throw new IllegalArgumentException("Missing token > in " + value);
                }
                this.baseUri = URI.create(value.substring(1, gtIndex).trim());
                String params = value.substring(gtIndex + 1).trim();
                StringTokenizer st = new StringTokenizer(params, ";=\"", true);
                while (st.hasMoreTokens()) {
                    Builder.checkParamToken(st, ";");
                    String n = st.nextToken().trim();
                    Builder.checkParamToken(st, "=");
                    String v = Builder.nonEmptyTokenNext(st);
                    if (v.equals("\"")) {
                        v = st.nextToken();
                        Builder.checkParamToken(st, "\"");
                    }
                    this.param(n, v);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse link " + value + " error: " + e.getMessage());
            }
            return this;
        }

        public MicroTxLinkHeaderVal build() {
            return new MicroTxLinkHeaderVal(this);
        }
    }
}

