/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.common;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAResourceManager;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.tmm.jta.common.DataSourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroTxNonXAConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private MicroTxNonXAConfig() {
    }

    public static void initNonXaDataSource(DataSource dataSource, DataSourceInfo dataSourceInfo) throws SQLException {
        if (!dataSourceInfo.isLRCSupport().booleanValue() && !dataSourceInfo.isLLRSupport().booleanValue()) {
            LOGGER.error("initNonXaDataSource is called for non LLR/LRC branch. Make sure to set the branch as LLR/LRC only");
        }
        MicroTxNonXAResourceManager.registerNonXaDataSource(dataSource, dataSourceInfo);
    }

    public static void initNonXaDataSource(DataSource dataSource) throws SQLException {
        if (!MicroTxNonXAResourceManager.isLLRBranch() && !MicroTxNonXAResourceManager.isLRCBranch()) {
            LOGGER.error("initNonXaDataSource is called for non LLR/LRC branch. Make sure to set the branch as LLR/LRC only");
        }
        DataSourceInfo dataSourceInfo = new DataSourceInfo(MicroTxConfig.resourceManagerId);
        if (MicroTxNonXAResourceManager.isLLRBranch()) {
            dataSourceInfo.setLLRSupport();
        } else if (MicroTxNonXAResourceManager.isLRCBranch()) {
            dataSourceInfo.setLRCSupport();
        }
        MicroTxNonXAResourceManager.registerNonXaDataSource(dataSource, dataSourceInfo);
    }
}

