/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.common;

import com.oracle.microtx.springboot.MicroTxClientMain;
import com.oracle.microtx.springboot.interceptor.MicroTxInterceptorService;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.coordinator.CoordinatorEnlistResponse;
import com.oracle.microtx.xa.coordinator.MicroTxCoordinatorClient;
import com.oracle.microtx.xa.rm.MicroTxResourceManagerClient;
import com.oracle.microtx.xa.rm.MicroTxUserTransaction;
import jakarta.persistence.EntityManager;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.Xid;
import oracle.jdbc.xa.OracleXAResource;
import oracle.tmm.common.TmsHostCache;
import oracle.tmm.jta.CoordinatorPayloadBuilder;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.exceptions.TrmEnlistmentException;
import oracle.tmm.jta.exceptions.TrmPromoteException;
import oracle.tmm.jta.pojo.TcsEnlistedResponsePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.RequestScope;

@Service
@RequestScope
public class MicroTxPromoteTransaction {
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    MicroTxClientMain microTxClientMain;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxResourceManagerClient microTxResourceManagerClient;
    @Autowired
    MicroTxCoordinatorClient microTxCoordinatorClient;
    @Autowired
    MicroTxInterceptorService microTxInterceptorService;

    public void promoteUserTransaction() throws TrmEnlistmentException {
        MicroTxUserTransaction userTransaction = this.microTxXaTxnStoreService.getLocalUserTransaction();
        this.microTxXaTxnStoreService.removeLocalUserTransaction();
        this.microTxXaTxnStoreService.setIsPromotable(false);
        LOGGER.info("Promote local user transaction to global transaction");
        try {
            this.microTxXaTxnStoreService.setIsLocalTransactionAvailable(false);
            userTransaction.startTCSGlobalTransaction();
            this.microTxXaTxnStoreService.setUserTransaction(userTransaction);
            this.removeLocalContext();
        }
        catch (Exception e) {
            LOGGER.error("Error starting the global transaction");
            LOGGER.trace("Failed to start global transaction", (Throwable)e);
        }
    }

    public void promoteLocalTransaction(String rmid) throws TrmPromoteException {
        LOGGER.debug("Starting the global enlistment");
        PooledConnection localXaConnection = null;
        EntityManager entityManager = null;
        String requestId = this.microTxXaTxnStoreService.getRequestId();
        String newGtrid = UUID.randomUUID().toString();
        CoordinatorEnlistResponse enlistResponse = new CoordinatorEnlistResponse();
        TcsEnlistedResponsePayload xaTransactionResponse = new TcsEnlistedResponsePayload();
        MicroTxUserTransaction userTransaction = this.microTxXaTxnStoreService.getLocalUserTransaction();
        LOGGER.info("Promote Local Transaction To Global transaction for rmid {} ", (Object)this.microTxXaTxnStoreService.getLocalTransactionRmid());
        try {
            this.microTxXaTxnStoreService.setIsLocalTransactionAvailable(false);
            this.microTxXaTxnStoreService.setIsPromotable(false);
            TrmXAResource trmXAResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
            if (trmXAResource.getEntityManagerFactory() != null) {
                TrmXaContext localCtx = this.microTxXaTxnStoreService.getLocalTransactionContext();
                localXaConnection = localCtx.xaCon;
            } else {
                localXaConnection = this.microTxXaTxnStoreService.getLocalTransactionContext().xaCon;
            }
            LOGGER.info("XA Start");
            try {
                enlistResponse = this.microTxCoordinatorClient.beginWithEnlist(newGtrid, userTransaction.getTransactionTimeout(), userTransaction.getInsProperties(), rmid, requestId, CoordinatorPayloadBuilder.getRmInstanceName(rmid, (XAConnection)localXaConnection));
            }
            catch (Exception e) {
                localXaConnection.close();
                LOGGER.error(e.getMessage());
                throw new TrmPromoteException(e.getMessage());
            }
            xaTransactionResponse = enlistResponse.getTcsEnlistedResponsePayload();
            LOGGER.info("begin response from TCS: {} --- {}", (Object)xaTransactionResponse, (Object)enlistResponse.getHttpStatusCode());
            this.microTxInterceptorService.setTransactionTokenHeader(enlistResponse.getTransactionTokenHeader());
            userTransaction.txnInternalUrl = xaTransactionResponse.internal;
            userTransaction.txnExternalUrl = xaTransactionResponse.external;
            this.microTxXaTxnStoreService.setInternalURI(userTransaction.txnInternalUrl);
            this.microTxXaTxnStoreService.setExternalURI(userTransaction.txnInternalUrl);
            userTransaction.txnUrl = TmsHostCache.checkTmsHostReachable(userTransaction.txnInternalUrl) ? userTransaction.txnInternalUrl : userTransaction.txnExternalUrl;
            String[] temp = userTransaction.txnInternalUrl.split("/");
            userTransaction.gtrid = temp[temp.length - 1];
            this.microTxXaTxnStoreService.setGlobalTransactionId(userTransaction.gtrid);
            LOGGER.info("begin {}", (Object)xaTransactionResponse.toString());
            this.microTxXaTxnStoreService.setUserTransaction(userTransaction);
            TrmXid xid = this.microTxResourceManagerClient.afterEnlist(rmid, userTransaction.gtrid, enlistResponse, (XAConnection)localXaConnection, requestId, entityManager, null, null);
            this.microTxXaTxnStoreService.setEnlistedXid(rmid, xid);
            TrmXaContext ctx = TrmXAResourceManager.addXaContext(rmid, xid, (XAConnection)localXaConnection, requestId, entityManager, null, null);
            this.microTxXaTxnStoreService.setTrmXaContext(rmid, ctx);
            LOGGER.debug("rmid {} : enlisted ", (Object)rmid);
            OracleXAResource xaResource = (OracleXAResource)ctx.xaRes;
            xaResource.start((Xid)xid, 8);
            this.removeLocalContext();
        }
        catch (Exception e) {
            LOGGER.error("Error Starting The Global Transaction with TCS");
            LOGGER.trace("Error Starting The Global Transaction with TCS", (Throwable)e);
            throw new TrmPromoteException("Error Starting The Global Transaction with TCS");
        }
        finally {
            try {
                localXaConnection.close();
            }
            catch (SQLException e) {
                throw new TrmPromoteException("Unable to promote transaction , Error :" + e.getMessage());
            }
        }
    }

    private void removeLocalContext() {
        this.microTxXaTxnStoreService.setIsPromotable(false);
        this.microTxXaTxnStoreService.setIsLocalTransactionAvailable(false);
        this.microTxXaTxnStoreService.removeLocalUserTransaction();
    }

    public void removeLocalConnection() {
        try {
            TrmXaContext ctx = this.microTxXaTxnStoreService.getLocalTransactionContext();
            if (ctx != null) {
                ctx.connection.close();
                ctx.xaCon.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unable to close the local connection {}", (Object)e.getMessage());
        }
        this.removeLocalContext();
    }
}

