/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.common;

import com.oracle.microtx.store.MicroTxXaTxnStore;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientRequest;

@Component
public class SpringBootTransactionUtils {
    @Autowired
    MicroTxXaTxnStore microTxXaTxnStore;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setTxIdToThreadLocal(String txnId) {
        if (!StringUtils.hasLength((String)this.microTxXaTxnStore.getTransactionId())) {
            this.microTxXaTxnStore.setTransactionId(txnId);
        }
    }

    public void setTxIdToThreadLocal(HttpServletRequest request) {
        if (!StringUtils.hasLength((String)this.microTxXaTxnStore.getTransactionId())) {
            String txnId = request.getHeader("oracle-tmm-txn-id");
            if (StringUtils.hasLength((String)txnId)) {
                this.microTxXaTxnStore.setTransactionId(txnId);
            } else if (StringUtils.hasLength((String)request.getHeader("Link"))) {
                txnId = this.getGtridFromLinkHeader(request.getHeader("Link"));
                this.microTxXaTxnStore.setTransactionId(txnId);
            }
        }
    }

    public void setTxIdToThreadLocal(ClientRequest request) {
        if (!StringUtils.hasLength((String)this.microTxXaTxnStore.getTransactionId())) {
            List txnIdList = request.headers().get((Object)"oracle-tmm-txn-id");
            if (txnIdList != null && !txnIdList.isEmpty()) {
                String txnId = (String)txnIdList.get(0);
                if (StringUtils.hasLength((String)txnId)) {
                    this.microTxXaTxnStore.setTransactionId(txnId);
                } else if (StringUtils.hasLength((String)((String)request.headers().get((Object)"Link").get(0)))) {
                    txnId = this.getGtridFromLinkHeader((String)request.headers().get((Object)"Link").get(0));
                    this.microTxXaTxnStore.setTransactionId(txnId);
                }
            } else {
                return;
            }
        }
    }

    public void setTxIdToThreadLocal(HttpRequest request) {
        if (!StringUtils.hasLength((String)this.microTxXaTxnStore.getTransactionId())) {
            String txnId;
            String string = txnId = request.getHeaders().get((Object)"oracle-tmm-txn-id") == null ? null : (String)request.getHeaders().get((Object)"oracle-tmm-txn-id").get(0);
            if (StringUtils.hasLength(txnId)) {
                this.microTxXaTxnStore.setTransactionId(txnId);
            } else if (request.getHeaders().get((Object)"Link") != null && StringUtils.hasLength((String)((String)request.getHeaders().get((Object)"Link").get(0)))) {
                txnId = this.getGtridFromLinkHeader((String)request.getHeaders().get((Object)"Link").get(0));
                this.microTxXaTxnStore.setTransactionId(txnId);
            }
        }
    }

    public void setTxIdToThreadLocal(RequestTemplate request) {
        if (!StringUtils.hasLength((String)this.microTxXaTxnStore.getTransactionId())) {
            String txnId;
            String string = txnId = request.headers().get("oracle-tmm-txn-id") == null ? null : (String)((Collection)request.headers().get("oracle-tmm-txn-id")).stream().findFirst().orElse(null);
            if (StringUtils.hasLength(txnId)) {
                this.microTxXaTxnStore.setTransactionId(txnId);
            } else if (request.headers().get("Link") != null && StringUtils.hasLength((String)((Collection)request.headers().get("Link")).stream().findFirst().orElse(null))) {
                txnId = this.getGtridFromLinkHeader(((Collection)request.headers().get("Link")).stream().findFirst().orElse(null));
                this.microTxXaTxnStore.setTransactionId(txnId);
            }
        }
    }

    private String getGtridFromLinkHeader(String linkHeader) {
        URI intTxnUrl = this.parseLinkHeaderRelUri(linkHeader, "https://otmm.oracle.com/xa-transaction/internal");
        URI extTxnUrl = this.parseLinkHeaderRelUri(linkHeader, "https://otmm.oracle.com/xa-transaction/external");
        String gtrid = null;
        if (intTxnUrl != null) {
            return intTxnUrl.toString().substring(intTxnUrl.toString().lastIndexOf("/") + 1);
        }
        if (extTxnUrl != null && (gtrid == null || gtrid.isEmpty())) {
            return extTxnUrl.toString().substring(extTxnUrl.toString().lastIndexOf("/") + 1);
        }
        return null;
    }

    public URI parseLinkHeaderRelUri(String linkHeader, String rel) {
        URI uri = null;
        if (linkHeader != null && rel != null) {
            String[] linkArr;
            for (String linkVal : linkArr = linkHeader.split(",")) {
                if (!linkVal.contains(rel)) continue;
                String[] linkValArr = linkVal.split(";");
                String uriVal = linkValArr[0].replaceFirst("<", "").replaceFirst(">", "");
                try {
                    uri = new URI(uriVal);
                }
                catch (URISyntaxException e) {
                    LOGGER.warn("failed to parse the link header{} with uri {}", (Object)linkHeader, (Object)uri);
                }
            }
        }
        return uri;
    }
}

