/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.springboot.MicroTxConfigProperties;
import oracle.tmm.jta.common.TrmXAResourceType;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MicroTxConfigProperties.class})
public class MicroTxClientMain {
    public static TrmXAResourceType trmXAResourceType = TrmXAResourceType.Oracle;
    private final MicroTxConfigProperties microTxConfigProperties;

    public MicroTxClientMain(MicroTxConfigProperties microTxConfigProperties) {
        this.microTxConfigProperties = microTxConfigProperties;
        this.populateDefaultConfig();
    }

    public static void main(String[] args) {
        SpringApplication.run(MicroTxClientMain.class, (String[])args);
    }

    public final void populateDefaultConfig() {
        MicroTxConfig.setResourceManagerId(this.microTxConfigProperties.getCoordinatorUrl());
        MicroTxConfig.setCoordinatorUrl(this.microTxConfigProperties.getCoordinatorUrl());
        MicroTxConfig.setParticipantCallBackUrl(this.microTxConfigProperties.getParticipantUrl());
        MicroTxConfig.setXaPromotableActive(this.microTxConfigProperties.isXaPromotableActive());
        MicroTxConfig.setPropagateTraceHeaders(this.microTxConfigProperties.isPropagationActive());
        MicroTxConfig.setHttpClientConnectionPoolSize(this.microTxConfigProperties.getHttpClientConnectionPoolSize());
        MicroTxConfig.setTransactionTimeout(this.microTxConfigProperties.getXaTransactionTimeout());
        MicroTxConfig.setResourceManagerId(this.microTxConfigProperties.getXaResourceManagerId());
        MicroTxConfig.setXaXaSupport(this.microTxConfigProperties.isXaXaSupport());
        MicroTxConfig.setXaLLRSupport(this.microTxConfigProperties.isXaLlrSupport());
        MicroTxConfig.setXaLRCSupport(this.microTxConfigProperties.isXaLrcSupport());
        MicroTxConfig.setXaRacActive(this.microTxConfigProperties.isXaRacActive());
        MicroTxConfig.setXaWeblogicTransactionSupport(this.microTxConfigProperties.isXaWeblogicTransactionSupport());
        MicroTxConfig.setWlsNamespace(this.microTxConfigProperties.getXaWeblogicNamespace());
        MicroTxConfig.setLlrDeleteCommitRecordTimeInterval(this.microTxConfigProperties.getXaLlrDeleteCommitRecordInterval());
    }

    public long xaLlrDeleteCommitRecordInterval() {
        return MicroTxConfig.getLlrDeleteCommitRecordTimeInterval();
    }
}

