/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.bean.factory;

import com.oracle.microtx.common.MicroTxPromoteTransaction;
import com.oracle.microtx.springboot.MicroTxClientMain;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.rm.MicroTxResourceManagerClient;
import jakarta.persistence.EntityManager;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.tmm.jta.common.ThreadLocalXAConnection;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.TrmXAResourceType;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.exceptions.TrmConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class MicroTxEntityManagerBeanFactory {
    @Autowired
    MicroTxClientMain microTxClientMain;
    @Autowired
    MicroTxPromoteTransaction microTxPromoteTransaction;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxResourceManagerClient microTxResourceManagerClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Bean(name={"microTxEntityManager"})
    @Scope(value="prototype")
    public EntityManager microTxEntityManager(@Autowired(required=false) String dataSourceName) throws SQLException {
        if (!this.microTxXaTxnStoreService.isMicroTxXaTrn() && !this.microTxXaTxnStoreService.isPromotable().booleanValue()) {
            LOGGER.trace("Not able to find the transactional context loging a non transaction entity manager");
            return this.NonActiveXAEntityManager(dataSourceName);
        }
        return this.getEntityManagerByName(dataSourceName);
    }

    public EntityManager NonActiveXAEntityManager(String dataSourceName) throws TrmConnectionException {
        try {
            if (dataSourceName == null) {
                dataSourceName = "";
            }
            String rmid = TrmXAResourceManager.getDsToRmidMapWithDefault(dataSourceName);
            TrmXAResource xaResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
            EntityManager localEntityManager = xaResource.entityMgrFactory.createEntityManager();
            if (localEntityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource") != null) {
                XADataSource xaDataSource = (XADataSource)localEntityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource");
                XAConnection xaConnection = xaDataSource.getXAConnection();
                TrmXaContext localCtx = new TrmXaContext(xaConnection, null, null, localEntityManager);
                MicroTxXaTxnStoreService.setNonActiveXaContext(rmid, localCtx);
            } else {
                TrmXaContext localCtx = MicroTxXaTxnStoreService.getNonActiveXaContext(rmid);
                localCtx.entityManager = localEntityManager;
                MicroTxXaTxnStoreService.setNonActiveXaContext(rmid, localCtx);
            }
            return localEntityManager;
        }
        catch (SQLException e) {
            LOGGER.error("Unable to provide Active Entity Manager", (Object)e.getMessage());
            throw new TrmConnectionException("message :" + e.getMessage());
        }
    }

    public EntityManager getEntityManagerByName(String dataSourceName) throws SQLException {
        if (!this.microTxXaTxnStoreService.isMicroTxXaTrn() && !this.microTxXaTxnStoreService.isInitiatorAsParticipant()) {
            LOGGER.trace("Not able to find the microtx transaction info");
            return null;
        }
        if (dataSourceName == null) {
            dataSourceName = "";
        }
        String rmid = TrmXAResourceManager.getDsToRmidMapWithDefault(dataSourceName);
        if (this.microTxXaTxnStoreService.isLocalTransactionPresent() && this.microTxXaTxnStoreService.getLocalTransactionRmid().equals(rmid)) {
            return this.microTxXaTxnStoreService.getLocalTransactionContext().entityManager;
        }
        TrmXAResource xaResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
        if (this.microTxXaTxnStoreService.isInitiatorAsParticipant() && xaResource.trmXAResourceType.equals((Object)TrmXAResourceType.Oracle) && this.microTxXaTxnStoreService.isPromotable().booleanValue() && !this.microTxXaTxnStoreService.isLocalTransactionPresent()) {
            try {
                LOGGER.info("Provided local entity manager for rmid {}", (Object)rmid);
                EntityManager localEntityManager = xaResource.entityMgrFactory.createEntityManager();
                this.microTxXaTxnStoreService.setLocalTransactionRmid(rmid);
                if (localEntityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource") != null) {
                    XADataSource xaDataSource = (XADataSource)localEntityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource");
                    XAConnection xaConnection = xaDataSource.getXAConnection();
                    TrmXaContext localCtx = new TrmXaContext(xaConnection, null, null, localEntityManager);
                    this.microTxXaTxnStoreService.setLocalTransactionContext(localCtx);
                    localEntityManager.getTransaction().begin();
                    LOGGER.info("xaConnection: {}", (Object)xaConnection);
                    localCtx.connection.setAutoCommit(false);
                    this.microTxXaTxnStoreService.setLocalTransactionContext(localCtx);
                    return localEntityManager;
                }
                XAConnection xaConnection = ThreadLocalXAConnection.get(rmid);
                localEntityManager.getTransaction().begin();
                if (xaConnection != null && this.microTxXaTxnStoreService.isLocalTransactionPresent()) {
                    TrmXaContext localCtx = this.microTxXaTxnStoreService.getLocalTransactionContext();
                    localCtx.entityManager = localEntityManager;
                    localCtx.connection = localCtx.xaCon.getConnection();
                    localCtx.connection.setAutoCommit(false);
                    LOGGER.info("xaConnection set by eclipselink connector: {}", (Object)xaConnection);
                } else if (xaResource.getXaDS() != null) {
                    XADataSource xaDataSource = xaResource.getXaDS();
                    xaConnection = xaDataSource.getXAConnection();
                    TrmXaContext localCtx = new TrmXaContext(xaConnection, null, null, localEntityManager);
                    localCtx.connection.setAutoCommit(false);
                    this.microTxXaTxnStoreService.setLocalTransactionContext(localCtx);
                    LOGGER.info("xaConnection: {}", (Object)xaConnection);
                } else {
                    LOGGER.warn("JPA provider not identified");
                }
                return localEntityManager;
            }
            catch (SQLException e) {
                LOGGER.error("Initiator database connection doesn't support delayed commit {}", (Object)e.getMessage());
                throw new TrmConnectionException("message :" + e.getMessage());
            }
        }
        if (this.microTxXaTxnStoreService.isLocalTransactionPresent()) {
            this.microTxPromoteTransaction.promoteLocalTransaction(this.microTxXaTxnStoreService.getLocalTransactionRmid());
        }
        if (!this.microTxXaTxnStoreService.containsThreadLocalXaContext(rmid)) {
            try {
                this.microTxResourceManagerClient.enlist(rmid, false);
            }
            catch (Exception e) {
                LOGGER.error("rmid {} is not valid. {}", (Object)rmid, (Object)e.getMessage());
                throw new TrmConnectionException(e.getMessage());
            }
        }
        return this.microTxXaTxnStoreService.getTrmXaContext((String)rmid).entityManager;
    }
}

