/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.bean.factory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAResourceManager;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.exceptions.TrmEnlistmentException;
import oracle.tmm.jta.nonxa.internal.TrmNonXAContext;
import oracle.tmm.jta.pojo.TcsEnlistErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class MicroTxNonXASqlConnectionFactory {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxNonXAResourceManager microTxNonXAResourceManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Bean(name={"microTxNonXASqlConnection"})
    @Scope(value="prototype")
    public Connection connection() throws SQLException {
        TrmNonXAContext context;
        if (!this.microTxXaTxnStoreService.isMicroTxXaTrn()) {
            LOGGER.trace("Not able to find the microtx transaction info returning connection for non transactional purpose ");
            return this.nonActiveNonXASQLConnection();
        }
        if (this.microTxXaTxnStoreService.getNonXaContext() == null) {
            String rmid = MicroTxNonXAResourceManager.getResourceManagerId();
            String internalTransactionUrl = this.microTxXaTxnStoreService.getInternalURI();
            String externalTransactionUrl = this.microTxXaTxnStoreService.getExternalURI();
            String requestId = this.microTxXaTxnStoreService.getRequestId();
            try {
                TrmXid xid = this.microTxNonXAResourceManager.enlistNonXA(MicroTxNonXAResourceManager.getResourceManagerId(), internalTransactionUrl, externalTransactionUrl, requestId);
                LOGGER.debug("Resource manager Id {} enlisted successfully with xid {}", (Object)rmid, (Object)xid.contextString());
            }
            catch (Exception e) {
                LOGGER.error("Enlistment Failed for resource manager Id : {}", (Object)rmid, (Object)e);
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    throw new TrmEnlistmentException(((TcsEnlistErrorResponse)objectMapper.readValue(e.getMessage(), TcsEnlistErrorResponse.class)).getError());
                }
                catch (JsonProcessingException ex) {
                    throw new TrmEnlistmentException(e.getMessage());
                }
            }
        }
        if ((context = this.microTxXaTxnStoreService.getNonXaContext()) == null || context.connection == null) {
            throw new SQLException("TrmNonXASQLConnection: No active connections found");
        }
        return context.connection;
    }

    Connection nonActiveNonXASQLConnection() {
        try {
            if (this.microTxXaTxnStoreService.IsNonActiveNonXaConnectionEmpty()) {
                Connection nonXaConnection = this.microTxNonXAResourceManager.getNonXADatasource().getConnection();
                this.microTxXaTxnStoreService.setNonActiveNonXaConnection(nonXaConnection);
            }
            return this.microTxXaTxnStoreService.getNonActiveNonXaConnection();
        }
        catch (SQLException e) {
            LOGGER.error("Error Creating the Non Transaction Connection {}", (Object)e.getMessage());
            return null;
        }
    }
}

