/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.bean.factory;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.MicroTxPromoteTransaction;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.rm.MicroTxResourceManagerClient;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.TrmXAResourceType;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.exceptions.TrmConnectionException;
import oracle.tmm.jta.exceptions.TrmPromoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class MicroTxSqlConnectionBeanFactory {
    @Autowired
    MicroTxPromoteTransaction microTxPromoteTransaction;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxResourceManagerClient microTxResourceManagerClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Bean(name={"microTxSqlConnection"})
    @Scope(value="prototype")
    public Connection microTxSqlConnection(@Autowired(required=false) String dataSourceName) {
        if (!this.microTxXaTxnStoreService.isMicroTxXaTrn() && !this.microTxXaTxnStoreService.isPromotable().booleanValue()) {
            return this.NonActiveXAConnection(dataSourceName);
        }
        return this.getConnection(dataSourceName);
    }

    public Connection NonActiveXAConnection(String dataSourceName) throws TrmConnectionException {
        try {
            if (dataSourceName == null) {
                dataSourceName = "";
            }
            String rmid = TrmXAResourceManager.getDsToRmidMapWithDefault(dataSourceName);
            TrmXAResource xaResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
            XADataSource xaDataSource = xaResource.getXaDS();
            XAConnection xaConnection = xaDataSource.getXAConnection();
            TrmXaContext localCtx = new TrmXaContext(xaConnection, null, null, null);
            MicroTxXaTxnStoreService.setNonActiveXaContext(rmid, localCtx);
            return localCtx.connection;
        }
        catch (SQLException e) {
            LOGGER.error("Unable to provide Active Entity Manager {}", (Object)e.getMessage());
            throw new TrmConnectionException("message :" + e.getMessage());
        }
    }

    public Connection getConnection(String dataSourceName) {
        String rmid;
        if (!this.microTxXaTxnStoreService.isMicroTxXaTrn() && !this.microTxXaTxnStoreService.isInitiatorAsParticipant()) {
            LOGGER.trace("Not able to find the microtx transaction info");
            return null;
        }
        if (dataSourceName == null || dataSourceName.equals("default")) {
            rmid = MicroTxConfig.getResourceManagerId();
        } else if (TrmXAResourceManager.getDsToRmidMapWithDefault(dataSourceName.trim()) != null) {
            rmid = TrmXAResourceManager.getDsToRmidMapWithDefault(dataSourceName.trim());
        } else {
            LOGGER.error("The provided data source name : {} is not valid", (Object)dataSourceName);
            throw new TrmConnectionException("The DataSource name " + dataSourceName + "is not valid");
        }
        TrmXAResource xaResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
        if (this.microTxXaTxnStoreService.isInitiatorAsParticipant() && xaResource.trmXAResourceType.equals((Object)TrmXAResourceType.Oracle) && this.microTxXaTxnStoreService.isPromotable().booleanValue() && !this.microTxXaTxnStoreService.isLocalTransactionPresent()) {
            try {
                Connection localConnection;
                LOGGER.debug("Provided local connection for rmid {}", (Object)rmid);
                this.microTxXaTxnStoreService.setLocalTransactionRmid(rmid);
                TrmXaContext localCtx = new TrmXaContext(xaResource.xaPds.getXAConnection(), null, null, null);
                this.microTxXaTxnStoreService.setLocalTransactionContext(localCtx);
                localCtx.connection = localConnection = localCtx.xaCon.getConnection();
                localConnection.setAutoCommit(false);
                return localConnection;
            }
            catch (SQLException e) {
                LOGGER.error("Initiator database connection doesn't support delayed commit {}", (Object)e.getMessage());
                throw new TrmConnectionException("message :" + e.getMessage());
            }
        }
        if (this.microTxXaTxnStoreService.isLocalTransactionPresent()) {
            try {
                this.microTxPromoteTransaction.promoteLocalTransaction(this.microTxXaTxnStoreService.getLocalTransactionRmid());
            }
            catch (TrmPromoteException e) {
                LOGGER.trace("Transaction promotion exception {}", (Object)e.getMessage());
                throw e;
            }
        }
        if (!this.microTxXaTxnStoreService.containsThreadLocalXaContext(rmid)) {
            try {
                this.microTxResourceManagerClient.enlist(rmid, false);
            }
            catch (Exception e) {
                LOGGER.error("rmid {} is not valid. {}", (Object)rmid, (Object)e.getMessage());
                throw new TrmConnectionException(e.getMessage());
            }
        }
        return this.microTxXaTxnStoreService.getTrmXaContext((String)rmid).connection;
    }
}

