/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.bean.factory;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.MicroTxPromoteTransaction;
import com.oracle.microtx.springboot.MicroTxClientMain;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.rm.MicroTxResourceManagerClient;
import jakarta.jms.XATopicSession;
import java.lang.invoke.MethodHandles;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.exceptions.TrmConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class MicroTxXATopicSessionFactory {
    @Autowired
    MicroTxClientMain microTxClientMain;
    @Autowired
    MicroTxPromoteTransaction microTxPromoteTransaction;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxResourceManagerClient microTxResourceManagerClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Bean(name={"microTxXATopicSession"})
    @Scope(value="prototype")
    public XATopicSession microTxXATopicSession(@Autowired(required=false) String dataSourceName) {
        if (!this.microTxXaTxnStoreService.isMicroTxXaTrn() && !this.microTxXaTxnStoreService.isInitiatorAsParticipant()) {
            LOGGER.trace("Not able to find the microtx transaction info");
            return null;
        }
        return this.getSession(dataSourceName);
    }

    public XATopicSession getSession(String dataSourceName) {
        String rmid;
        if (!this.microTxXaTxnStoreService.isMicroTxXaTrn() && !this.microTxXaTxnStoreService.isInitiatorAsParticipant()) {
            LOGGER.trace("Not able to find the microtx transaction info");
            return null;
        }
        if (dataSourceName == null || dataSourceName.equals("default")) {
            rmid = MicroTxConfig.getResourceManagerId();
        } else if (TrmXAResourceManager.getDsToRmidMapWithDefault(dataSourceName.trim()) != null) {
            rmid = TrmXAResourceManager.getDsToRmidMapWithDefault(dataSourceName.trim());
        } else {
            LOGGER.error("The provided data source name : {} is not valid", (Object)dataSourceName);
            throw new TrmConnectionException("The DataSource name " + dataSourceName + "is not valid");
        }
        if (!this.microTxXaTxnStoreService.containsThreadLocalXaContext(rmid)) {
            try {
                this.microTxResourceManagerClient.enlist(rmid, true);
            }
            catch (Exception e) {
                LOGGER.error("rmid {} is not valid. {}", (Object)rmid, (Object)e.getMessage());
                throw new TrmConnectionException(e.getMessage());
            }
        }
        return this.microTxXaTxnStoreService.getTrmXaContext((String)rmid).xaTopicSession;
    }
}

