/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.callbacks;

import com.oracle.microtx.xa.rm.CallbackResponse;
import com.oracle.microtx.xa.rm.XaCallBack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/microtx"})
public class XACallbackResource {
    @Autowired
    private XaCallBack xaCallBack;

    @RequestMapping(value={"/{gtrid}/prepare"}, method={RequestMethod.PUT})
    public ResponseEntity<?> prepare(@RequestHeader(value="x-request-id", required=false) String requestId, @RequestHeader(value="microtx-instr", required=false) String microTxInstr, @PathVariable(value="gtrid") String gtrid, @RequestBody String payload) {
        CallbackResponse callbackResponse = this.xaCallBack.prepare(requestId, microTxInstr, gtrid, payload);
        return new ResponseEntity((Object)callbackResponse.getResponseString(), (HttpStatusCode)HttpStatus.valueOf((int)callbackResponse.getResponseCode()));
    }

    @RequestMapping(value={"/{gtrid}/commit"}, method={RequestMethod.PUT})
    public ResponseEntity<?> commit(@RequestHeader(value="x-request-id", required=false) String requestId, @RequestHeader(value="microtx-instr", required=false) String microTxInstr, @PathVariable(value="gtrid") String gtrid, @RequestParam(value="onePhase", required=false) boolean onePhase, @RequestParam(value="finalRetry", required=false) boolean finalRetry, @RequestBody String payload) {
        CallbackResponse callbackResponse = this.xaCallBack.commit(requestId, microTxInstr, gtrid, onePhase, finalRetry, payload);
        return new ResponseEntity((Object)callbackResponse.getResponseString(), (HttpStatusCode)HttpStatus.valueOf((int)callbackResponse.getResponseCode()));
    }

    @RequestMapping(value={"/{gtrid}/rollback"}, method={RequestMethod.PUT})
    public ResponseEntity<?> rollback(@RequestHeader(value="x-request-id", required=false) String requestId, @RequestHeader(value="microtx-instr", required=false) String microTxInstr, @PathVariable(value="gtrid") String gtrid, @RequestParam(value="finalRetry", required=false) boolean finalRetry, @RequestBody String payload) {
        CallbackResponse callbackResponse = this.xaCallBack.rollback(requestId, microTxInstr, gtrid, finalRetry, payload);
        return new ResponseEntity((Object)callbackResponse.getResponseString(), (HttpStatusCode)HttpStatus.valueOf((int)callbackResponse.getResponseCode()));
    }

    @RequestMapping(value={"/{tmmid}/recover"}, method={RequestMethod.GET})
    public ResponseEntity<?> recover(@RequestHeader(value="x-request-id", required=false) String requestId, @PathVariable(value="tmmid") String tmmId, @RequestParam(value="rmids", required=false) String rmidParameter, @RequestParam(value="gtrid", required=false) String gtrid, @RequestParam(value="bqual", required=false) String bqual) {
        CallbackResponse callbackResponse = this.xaCallBack.recover(requestId, tmmId, rmidParameter, gtrid, bqual);
        return new ResponseEntity((Object)callbackResponse.getResponseString(), (HttpStatusCode)HttpStatus.valueOf((int)callbackResponse.getResponseCode()));
    }

    @RequestMapping(value={"/{gtrid}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> forget(@RequestHeader(value="x-request-id", required=false) String requestId, @PathVariable(value="gtrid") String gtrid, @RequestBody String payload) {
        CallbackResponse callbackResponse = this.xaCallBack.forget(requestId, gtrid, payload);
        return new ResponseEntity((Object)callbackResponse.getResponseString(), (HttpStatusCode)HttpStatus.valueOf((int)callbackResponse.getResponseCode()));
    }
}

