/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.callbacks;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXADsConnection;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAResource;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAResourceManager;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.rm.CallbackResponse;
import com.oracle.microtx.xa.rm.XACallbackStatus;
import com.oracle.microtx.xa.rm.XaCallBack;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.transaction.xa.XAException;
import oracle.tmm.jta.XAOperation;
import oracle.tmm.jta.common.InstrUtil;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.common.XAConstants;
import oracle.tmm.jta.exceptions.ExceptionUtils;
import oracle.tmm.jta.nonxa.NonXAException;
import oracle.tmm.jta.pojo.TcsCommitRequestPayload;
import oracle.tmm.jta.pojo.TcsCommitResponsePayload;
import oracle.tmm.jta.pojo.TcsForgetRequestPayload;
import oracle.tmm.jta.pojo.TcsForgetResponsePayload;
import oracle.tmm.jta.pojo.TcsPrepareRequestPayload;
import oracle.tmm.jta.pojo.TcsPrepareResponsePayload;
import oracle.tmm.jta.pojo.TcsRecoveryResponse;
import oracle.tmm.jta.pojo.TcsRollBackRequestPayload;
import oracle.tmm.jta.pojo.TcsRollBackResponsePayload;
import oracle.tmm.util.ObjectMapperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XaCallBackService
implements XaCallBack {
    @Autowired
    private MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired(required=false)
    private MicroTxNonXADsConnection microTxNonXADsConnection;
    @Autowired
    private MicroTxNonXAResource microTxNonXAResource;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallbackResponse prepare(String requestId, String microTxInstr, String gtrid, String payload) {
        LOGGER.trace("received prepare callback request for gtrid {} with payload {} ", (Object)gtrid, (Object)payload);
        TcsPrepareResponsePayload responsePayload = new TcsPrepareResponsePayload();
        ArrayList<TcsPrepareResponsePayload.BranchStatus> branchStatuses = new ArrayList<TcsPrepareResponsePayload.BranchStatus>();
        Boolean allParticipantsSuccessful = true;
        HashSet<String> branchError = new HashSet<String>();
        Map<String, String> instrProp = InstrUtil.getInstrProp(microTxInstr);
        try {
            TcsPrepareRequestPayload preparePayload = ObjectMapperUtil.stringToObject(payload, TcsPrepareRequestPayload.class, false);
            for (TcsPrepareRequestPayload.Branch requestPayloadBranch : preparePayload.branches) {
                String rmid = requestPayloadBranch.resourceManagerId;
                String bqual = requestPayloadBranch.bqual;
                TcsPrepareResponsePayload.BranchStatus responsePayloadBranch = new TcsPrepareResponsePayload.BranchStatus();
                responsePayloadBranch.setBqual(bqual);
                try {
                    if (MicroTxConfig.getXaWeblogicTransactionSupport().booleanValue()) continue;
                    TrmXAResource trmXAResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
                    if (trmXAResource == null) {
                        if (MicroTxNonXAResourceManager.getResourceManagerId() != null && MicroTxNonXAResourceManager.getResourceManagerId().equals(rmid)) {
                            throw new NonXAException("For Rmid : " + rmid + " , prepare state is a not valid LLR/LRC ");
                        }
                        throw new NonXAException("The given Rmid : " + rmid + " , is not valid ");
                    }
                    if (trmXAResource.isLLRBranch() || trmXAResource.isLRCBranch()) {
                        throw new NonXAException("Prepare is not allowed for LLR/LRC branch");
                    }
                    InstrUtil.execInstrBefore(instrProp, XAOperation.PREPARE);
                    String status = trmXAResource.xaop(rmid, gtrid, bqual, XAOperation.PREPARE, requestId, false, null);
                    responsePayloadBranch.setStatus(status);
                    InstrUtil.execInstrAfter(instrProp, XAOperation.PREPARE);
                }
                catch (Exception e) {
                    allParticipantsSuccessful = false;
                    String statusError = this.exceptionError(e, rmid);
                    responsePayloadBranch.setStatus(statusError);
                    branchError.add(statusError);
                }
                finally {
                    branchStatuses.add(responsePayloadBranch);
                }
            }
            responsePayload.branchStatus = branchStatuses;
            return this.afterXAPrepare(allParticipantsSuccessful, responsePayload, branchError);
        }
        catch (Exception e) {
            String failMessage = String.format("Prepare operation failed for transaction [{}] with exception {}", gtrid, ExceptionUtils.getExceptionMetadata(e));
            LOGGER.error(failMessage);
            return new CallbackResponse(failMessage, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallbackResponse commit(String requestId, String microTxInstr, String gtrid, boolean onePhase, boolean isFinalRetry, String payload) {
        LOGGER.trace("received commit callback request for gtrid {} with payload {} ", (Object)gtrid, (Object)payload);
        TcsCommitResponsePayload tcsCommitResponsePayload = new TcsCommitResponsePayload();
        ArrayList<TcsCommitResponsePayload.BranchStatus> responseBranchPayloads = new ArrayList<TcsCommitResponsePayload.BranchStatus>();
        Boolean allParticipantsSuccessful = true;
        HashSet<String> branchError = new HashSet<String>();
        Map<String, String> instrProp = InstrUtil.getInstrProp(microTxInstr);
        try {
            TcsCommitRequestPayload tcsRequestPayload = ObjectMapperUtil.stringToObject(payload, TcsCommitRequestPayload.class, false);
            for (TcsCommitRequestPayload.Branch tcsCommitBranchRequestPayload : tcsRequestPayload.branches) {
                String rmid = tcsCommitBranchRequestPayload.resourceManagerId;
                String bqual = tcsCommitBranchRequestPayload.bqual;
                String status = "default";
                TrmXid xid = new TrmXid(gtrid, 0, bqual);
                TcsCommitResponsePayload.BranchStatus responseBranch = new TcsCommitResponsePayload.BranchStatus();
                responseBranch.setBqual(bqual);
                try {
                    if (!MicroTxConfig.getXaWeblogicTransactionSupport().booleanValue()) {
                        if (rmid.equals(MicroTxNonXAResourceManager.getResourceManagerId())) {
                            if (MicroTxNonXAResourceManager.isLLRBranch()) {
                                byte[] commitRecord;
                                byte[] byArray = commitRecord = tcsCommitBranchRequestPayload.commitRecord != null ? tcsCommitBranchRequestPayload.commitRecord.getBytes(StandardCharsets.UTF_8) : new byte[]{};
                                if (this.microTxNonXAResource.isNonXaResourcePresent()) {
                                    this.microTxNonXAResource.commit(xid, commitRecord, isFinalRetry);
                                } else {
                                    this.microTxNonXADsConnection.commit(xid, commitRecord, isFinalRetry);
                                }
                            } else if (MicroTxNonXAResourceManager.isLRCBranch()) {
                                if (this.microTxNonXAResource.isNonXaResourcePresent()) {
                                    this.microTxNonXAResource.commit(xid, null, isFinalRetry);
                                } else {
                                    this.microTxNonXADsConnection.commit(xid, null, isFinalRetry);
                                }
                            }
                            XACallbackStatus callbackStatus = new XACallbackStatus();
                            status = callbackStatus.getStatus();
                        } else {
                            if (!TrmXAResourceManager.availableRmidToTrmXaResourceMap.containsKey(rmid)) {
                                throw new XAException("The Rmid is not valid");
                            }
                            InstrUtil.execInstrBefore(instrProp, XAOperation.COMMIT);
                            status = TrmXAResourceManager.xaop(rmid, gtrid, bqual, XAOperation.COMMIT, requestId, onePhase, null);
                            InstrUtil.execInstrAfter(instrProp, XAOperation.COMMIT);
                        }
                    }
                    responseBranch.setStatus(status);
                }
                catch (Exception e) {
                    allParticipantsSuccessful = false;
                    String errorStatus = this.exceptionError(e, rmid);
                    responseBranch.setStatus(errorStatus);
                    branchError.add(errorStatus);
                }
                finally {
                    responseBranchPayloads.add(responseBranch);
                }
            }
            tcsCommitResponsePayload.branchStatus = responseBranchPayloads;
            return this.afterXaCommit(allParticipantsSuccessful, tcsCommitResponsePayload, branchError);
        }
        catch (Exception e) {
            String failMessage = String.format("Commit operation failed for transaction [{}] with exception{}", gtrid, ExceptionUtils.getExceptionMetadata(e));
            LOGGER.error(failMessage);
            return new CallbackResponse(failMessage, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallbackResponse rollback(String requestId, String microTxInstr, String gtrid, boolean isFinalRetry, String payload) {
        LOGGER.trace("received rollback callback request for gtrid {} with payload {} ", (Object)gtrid, (Object)payload);
        TcsRollBackResponsePayload tcsRollBackResponsePayload = new TcsRollBackResponsePayload();
        ArrayList<TcsRollBackResponsePayload.BranchStatus> tcsRollBackReponseBranchs = new ArrayList<TcsRollBackResponsePayload.BranchStatus>();
        Boolean allParticipantsSuccessful = true;
        HashSet<String> branchError = new HashSet<String>();
        Map<String, String> instrProp = InstrUtil.getInstrProp(microTxInstr);
        try {
            TcsRollBackRequestPayload tcsRollBackRequestPayloads = ObjectMapperUtil.stringToObject(payload, TcsRollBackRequestPayload.class, false);
            for (TcsRollBackRequestPayload.Branch tcsRollBackRequestBranch : tcsRollBackRequestPayloads.branches) {
                String rmid = tcsRollBackRequestBranch.resourceManagerId;
                String bqual = tcsRollBackRequestBranch.bqual;
                String status = "default";
                TcsRollBackResponsePayload.BranchStatus branchResponse = new TcsRollBackResponsePayload.BranchStatus();
                branchResponse.setBqual(bqual);
                try {
                    if (MicroTxConfig.getXaWeblogicTransactionSupport().booleanValue()) continue;
                    if (rmid.equals(MicroTxNonXAResourceManager.getResourceManagerId())) {
                        if (this.microTxNonXAResource.isNonXaResourcePresent()) {
                            this.microTxNonXAResource.rollback(new TrmXid(gtrid, 0, bqual), isFinalRetry);
                        } else {
                            this.microTxNonXADsConnection.rollback(new TrmXid(gtrid, 0, bqual), isFinalRetry);
                        }
                        XACallbackStatus callbackStatus = new XACallbackStatus();
                        status = callbackStatus.getStatus();
                    } else {
                        if (!TrmXAResourceManager.availableRmidToTrmXaResourceMap.containsKey(rmid)) {
                            throw new NonXAException("The Rmid :" + rmid + " is not valid");
                        }
                        InstrUtil.execInstrBefore(instrProp, XAOperation.ROLLBACK);
                        status = TrmXAResourceManager.xaop(rmid, gtrid, bqual, XAOperation.ROLLBACK, requestId, false, null);
                        InstrUtil.execInstrAfter(instrProp, XAOperation.ROLLBACK);
                    }
                    branchResponse.setStatus(status);
                }
                catch (Exception e) {
                    allParticipantsSuccessful = false;
                    String errorStatus = this.exceptionError(e, rmid);
                    branchResponse.setStatus(errorStatus);
                    branchError.add(errorStatus);
                }
                finally {
                    tcsRollBackReponseBranchs.add(branchResponse);
                }
            }
            tcsRollBackResponsePayload.branchStatus = tcsRollBackReponseBranchs;
            return this.afterXARollback(allParticipantsSuccessful, tcsRollBackResponsePayload, branchError);
        }
        catch (Exception e) {
            String failMessage = String.format("Rollback operation failed for transaction [{}] with exception{}", gtrid, ExceptionUtils.getExceptionMetadata(e));
            LOGGER.error(failMessage);
            return new CallbackResponse(failMessage, 500);
        }
    }

    @Override
    public CallbackResponse recover(String requestId, String tmmId, String rmidParameter, String gtrid, String bqual) {
        String resp = "";
        XACallbackStatus okcallBackStatus = new XACallbackStatus();
        HashSet<String> branchError = new HashSet<String>();
        if (rmidParameter != null) {
            String[] rmids = rmidParameter.split(",");
            TcsRecoveryResponse tcsRecoverResponse = new TcsRecoveryResponse();
            ArrayList<TcsRecoveryResponse.RecoveredTransaction> recoveredTransactionList = new ArrayList<TcsRecoveryResponse.RecoveredTransaction>();
            for (String rmid : rmids) {
                TcsRecoveryResponse.RecoveredTransaction recoveredTransaction = new TcsRecoveryResponse.RecoveredTransaction();
                recoveredTransaction.resourceManagerId = rmid;
                TcsRecoveryResponse.RecoveredTransaction.TransactionStatus transactionStatus = new TcsRecoveryResponse.RecoveredTransaction.TransactionStatus();
                try {
                    if (MicroTxConfig.getXaWeblogicTransactionSupport().booleanValue()) {
                        // empty if block
                    }
                    if (rmid.equals(MicroTxNonXAResourceManager.getResourceManagerId())) {
                        if (MicroTxNonXAResourceManager.isLRCBranch()) {
                            throw new NonXAException("Xa Recovery is not allowed for LRC branch");
                        }
                        if (MicroTxNonXAResourceManager.isLLRBranch()) {
                            String[] commitRecords = this.microTxNonXADsConnection.recover(new TrmXid(gtrid, 0, bqual));
                            if (commitRecords != null && commitRecords.length > 0) {
                                ArrayList<TcsRecoveryResponse.RecoveredTransaction.TransactionStatus> result = new ArrayList<TcsRecoveryResponse.RecoveredTransaction.TransactionStatus>();
                                for (String commitRecord : commitRecords) {
                                    TcsRecoveryResponse.RecoveredTransaction.TransactionStatus transactionStatusBanch = new TcsRecoveryResponse.RecoveredTransaction.TransactionStatus();
                                    transactionStatusBanch.commitRecord = commitRecord;
                                    transactionStatusBanch.xid = null;
                                    result.add(transactionStatusBanch);
                                }
                                recoveredTransaction.transactions = result;
                            } else {
                                recoveredTransaction.transactions = this.recoverListOfTransactions(resp);
                            }
                            recoveredTransaction.status = okcallBackStatus.getStatus();
                        }
                    } else if (TrmXAResourceManager.availableRmidToTrmXaResourceMap.containsKey(rmid)) {
                        resp = TrmXAResourceManager.xaop(rmid, gtrid, bqual, XAOperation.RECOVER, requestId, false, tmmId);
                        recoveredTransaction.transactions = this.recoverListOfTransactions(resp);
                        recoveredTransaction.status = okcallBackStatus.getStatus();
                    } else if (!this.microTxXaTxnStoreService.getAllRmids().contains(rmid)) {
                        recoveredTransaction.transactions.add(transactionStatus);
                        recoveredTransaction.status = XAConstants.XAErrorCode.XAER_NOTA.getMessage();
                        branchError.add(recoveredTransaction.status);
                    }
                }
                catch (Exception e) {
                    recoveredTransaction.status = this.exceptionError(e, rmid);
                    branchError.add(recoveredTransaction.status);
                    LOGGER.error(this.exceptionError(e, rmid));
                }
                recoveredTransactionList.add(recoveredTransaction);
            }
            tcsRecoverResponse.recoveredTransactions = recoveredTransactionList;
            return this.afterXARecover(tcsRecoverResponse, branchError);
        }
        return new CallbackResponse("Internal Server Error", 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallbackResponse forget(String requestId, String gtrid, String payload) {
        Boolean allParticipantsSuccessful = true;
        HashSet<String> branchError = new HashSet<String>();
        TcsForgetResponsePayload tcsForgetResponsePayload = new TcsForgetResponsePayload();
        try {
            TcsForgetRequestPayload tcsForgetRequestPayload = ObjectMapperUtil.stringToObject(payload, TcsForgetRequestPayload.class, false);
            for (TcsForgetRequestPayload.Branch tcsForgetRequestBranch : tcsForgetRequestPayload.branches) {
                String rmid = tcsForgetRequestBranch.resourceManagerId;
                String bqual = tcsForgetRequestBranch.bqual;
                TcsForgetResponsePayload.BranchStatus branchResponse = new TcsForgetResponsePayload.BranchStatus();
                branchResponse.setBqual(bqual);
                try {
                    branchResponse.setStatus("default");
                }
                catch (Exception e) {
                    allParticipantsSuccessful = false;
                    String errorStatus = this.exceptionError(e, rmid);
                    branchResponse.setStatus(errorStatus);
                    branchError.add(errorStatus);
                }
                finally {
                    tcsForgetResponsePayload.branchStatus.add(branchResponse);
                }
            }
            return this.afterXAForget(allParticipantsSuccessful, tcsForgetResponsePayload, branchError);
        }
        catch (Exception e) {
            String failMessage = String.format("Forget operation failed for transaction [{}] with exception {}", gtrid, ExceptionUtils.getExceptionMetadata(e));
            LOGGER.error(failMessage);
            return new CallbackResponse(failMessage, 500);
        }
    }
}

