/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.interceptor;

import com.oracle.microtx.common.AbstractMicroTxInterceptor;
import com.oracle.microtx.common.HeaderPropagation;
import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ClientRequest;

@Service
public class MicroTxInterceptorService
extends AbstractMicroTxInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    HeaderPropagation headerPropogation;

    public Map<String, List<String>> getRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), h -> Collections.list(request.getHeaders(h))));
    }

    public Map<String, List<String>> getResponseHeaders(HttpServletResponse response) {
        return null;
    }

    public void logRequest(HttpServletRequest request) throws IOException {
        this.transactionUtils.setTxIdToThreadLocal(request);
        this.microTxXaTxnStoreService.setRequestId(request.getHeader("x-request-id"));
        Map<String, List<String>> headersMap = this.getRequestHeaders(request);
        this.microTxXaTxnStoreService.setRequestHeaders(headersMap);
        String reqId = request.getHeader("x-request-id");
        double timestamp = System.currentTimeMillis();
        request.setAttribute("oracle-tmm-req-start-time", (Object)timestamp);
        LOGGER.info("Received the request with timestamp: {}, reqId: {}", (Object)timestamp, (Object)reqId);
    }

    public void logResponse(HttpServletRequest request, HttpServletResponse response) {
        this.transactionUtils.setTxIdToThreadLocal(request);
        String reqId = request.getHeader("x-request-id");
        double timestamp = System.currentTimeMillis();
        Object startObj = request.getAttribute("oracle-tmm-req-start-time");
        Double startTime = null;
        Double duration = null;
        if (startObj != null) {
            startTime = (Double)startObj;
            duration = timestamp - startTime;
        }
        LOGGER.info("MicroTxInterceptorService response  with duration: {}, reqId: {}", duration, (Object)reqId);
    }

    public String getGtridFromTransactionLink(String transactionLink) {
        return transactionLink == null ? transactionLink : transactionLink.substring(transactionLink.lastIndexOf(47) + 1);
    }

    public void propagateTraceHeaders(HttpRequest request) {
        if (request != null) {
            this.headerPropogation.propagateTraceHeaders(request, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateAuthzHeaders(HttpRequest request) {
        if (request != null) {
            this.headerPropogation.propagateAuthzHeaders(request, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateTransactionTokenHeaders(HttpRequest request) {
        if (request != null) {
            this.headerPropogation.propagateMicroTxTransactionTokenHeader(request, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateTraceHeaders(ClientRequest request, ClientRequest.Builder requestBuilder) {
        if (requestBuilder != null) {
            this.headerPropogation.propagateTraceHeaders(request, requestBuilder, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateAuthzHeaders(ClientRequest request, ClientRequest.Builder requestBuilder) {
        if (requestBuilder != null) {
            this.headerPropogation.propagateAuthzHeaders(request, requestBuilder, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateTransactionTokenHeader(ClientRequest request, ClientRequest.Builder requestBuilder) {
        if (requestBuilder != null) {
            this.headerPropogation.propagateMicroTxTransactionTokenHeader(request, requestBuilder, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateTraceHeaders(RequestTemplate request) {
        if (request != null) {
            this.headerPropogation.propagateTraceHeaders(request, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateAuthzHeaders(RequestTemplate request) {
        if (request != null) {
            this.headerPropogation.propagateAuthzHeaders(request, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void propagateTransactionTokenHeaders(RequestTemplate request) {
        if (request != null) {
            this.headerPropogation.propagateMicroTxTransactionTokenHeader(request, this.microTxXaTxnStoreService.getRequestHeaders());
        }
    }

    public void setTransactionTokenHeader(List<String> txnTokenHeader) {
        if (txnTokenHeader != null) {
            Map<String, List<String>> headersMap = this.microTxXaTxnStoreService.getRequestHeaders();
            headersMap.put("oracle-tmm-tx-token", txnTokenHeader);
            this.microTxXaTxnStoreService.setRequestHeaders(headersMap);
        }
    }
}

