/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.interceptor;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.MicroTxPromoteTransaction;
import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.springboot.interceptor.MicroTxInterceptorService;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.rm.MicroTxUserTransaction;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAException;
import oracle.tmm.jta.common.TrmXaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
public class MicroTxXaFeignReqInterceptor
implements RequestInterceptor {
    @Autowired
    MicroTxInterceptorService microTxInterceptorService;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    MicroTxPromoteTransaction microTxPromoteTransaction;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void apply(RequestTemplate request) {
        this.transactionUtils.setTxIdToThreadLocal(request);
        LOGGER.info("executing MicroTxXaFeignReqInterceptor");
        if (MicroTxConfig.isPropagateTraceHeadersActive().booleanValue()) {
            this.microTxInterceptorService.propagateTraceHeaders(request);
        }
        this.microTxInterceptorService.propagateAuthzHeaders(request);
        String txnInternalUrl = null;
        String txnExternalUrl = null;
        String transactionID = null;
        if (MicroTxConfig.getXaWeblogicTransactionSupport().booleanValue()) {
            return;
        }
        if (this.microTxXaTxnStoreService.isLocalTransactionPresent() && this.microTxXaTxnStoreService.getIsLocalTransactionAvailable().booleanValue()) {
            String rmid = this.microTxXaTxnStoreService.getLocalTransactionRmid();
            this.microTxPromoteTransaction.promoteLocalTransaction(rmid);
            this.microTxXaTxnStoreService.removeLocalUserTransaction();
            this.microTxInterceptorService.propagateTransactionTokenHeaders(request);
        }
        if (this.microTxXaTxnStoreService.isPromotable().booleanValue() && this.microTxXaTxnStoreService.getIsLocalTransactionAvailable().booleanValue()) {
            this.microTxPromoteTransaction.promoteUserTransaction();
        }
        this.microTxXaTxnStoreService.setIsPromotable(false);
        MicroTxUserTransaction userTransaction = this.microTxXaTxnStoreService.getUserTransaction();
        if (!this.microTxXaTxnStoreService.isInitiatorAsParticipant() && userTransaction != null) {
            txnInternalUrl = userTransaction.getTxnInternalUrl();
            txnExternalUrl = userTransaction.getTxnExternalUrl();
            transactionID = userTransaction.getTransactionID();
        } else {
            txnInternalUrl = this.microTxXaTxnStoreService.getInternalURI();
            txnExternalUrl = this.microTxXaTxnStoreService.getExternalURI();
            transactionID = this.microTxInterceptorService.getGtridFromTransactionLink(txnInternalUrl);
            if (transactionID == null) {
                transactionID = this.microTxInterceptorService.getGtridFromTransactionLink(txnExternalUrl);
            }
        }
        if (txnInternalUrl == null && txnExternalUrl == null) {
            return;
        }
        Set<Object> rmids = new HashSet();
        boolean isTCSUri = userTransaction != null && userTransaction.getTxnUrl().equals(request.url());
        try {
            if (!isTCSUri) {
                rmids = this.microTxXaTxnStoreService.getAllRmids();
                for (String string : rmids) {
                    TrmXaContext trmXaContext = this.microTxXaTxnStoreService.getTrmXaContext(string);
                    if (trmXaContext == null) continue;
                    trmXaContext.xaRes.end(trmXaContext.trmXid, 0x2000000);
                    LOGGER.trace("rmid {} , XaResource end(TMSUSPEND) for xid {} ", (Object)string, (Object)trmXaContext.trmXid.contextString());
                }
            }
        }
        catch (XAException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        MicroTxInterceptorService.buildLinkHeader(linkHeaderValue, null, txnInternalUrl, "https://otmm.oracle.com/xa-transaction/internal");
        MicroTxInterceptorService.buildLinkHeader(linkHeaderValue, null, txnExternalUrl, "https://otmm.oracle.com/xa-transaction/external");
        request.header("Link", new String[]{linkHeaderValue.toString()});
        if (!request.headers().containsKey("oracle-tmm-txn-id")) {
            request.header("oracle-tmm-txn-id", new String[]{transactionID});
        }
    }
}

