/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.interceptor;

import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.rm.MicroTxUserTransaction;
import feign.InvocationContext;
import feign.Request;
import feign.Response;
import feign.ResponseInterceptor;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import javax.transaction.xa.XAException;
import oracle.tmm.jta.common.TrmXaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
public class MicroTxXaFeignResInterceptor
implements ResponseInterceptor {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Object intercept(InvocationContext invocationContext, ResponseInterceptor.Chain chain) throws Exception {
        LOGGER.info("executing MicroTxXaFeignResInterceptor");
        Response response = invocationContext.response();
        Request request = response.request();
        MicroTxUserTransaction userTransaction = this.microTxXaTxnStoreService.getUserTransaction();
        boolean isTCSUri = userTransaction != null && userTransaction.getTxnUrl().equals(request.url());
        try {
            if (!isTCSUri) {
                Set<String> rmids = this.microTxXaTxnStoreService.getAllRmids();
                for (String rmid : rmids) {
                    TrmXaContext trmXaContext = this.microTxXaTxnStoreService.getTrmXaContext(rmid);
                    if (trmXaContext == null) continue;
                    trmXaContext.xaRes.start(trmXaContext.trmXid, 0x8000000);
                }
            }
        }
        catch (XAException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
        return invocationContext.proceed();
    }
}

