/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.interceptor;

import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.springboot.interceptor.MicroTxInterceptorService;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAInstance;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class MicroTxXaServerInterceptor
implements HandlerInterceptor {
    @Autowired
    MicroTxInterceptorService microTxInterceptorService;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxNonXAInstance microTxNonXAInstance;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.microTxInterceptorService.logRequest(request);
        URI intTxnUrl = this.transactionUtils.parseLinkHeaderRelUri(request.getHeader("Link"), "https://otmm.oracle.com/xa-transaction/internal");
        URI extTxnUrl = this.transactionUtils.parseLinkHeaderRelUri(request.getHeader("Link"), "https://otmm.oracle.com/xa-transaction/external");
        String gtrid = null;
        if (intTxnUrl != null) {
            this.microTxXaTxnStoreService.setInternalURI(intTxnUrl.toString());
            gtrid = intTxnUrl.toString().substring(intTxnUrl.toString().lastIndexOf("/") + 1);
        }
        if (extTxnUrl != null) {
            this.microTxXaTxnStoreService.setExternalURI(extTxnUrl.toString());
            if (gtrid == null || gtrid.isEmpty()) {
                gtrid = extTxnUrl.toString().substring(extTxnUrl.toString().lastIndexOf("/") + 1);
            }
        }
        if (gtrid != null) {
            this.microTxXaTxnStoreService.setGlobalTransactionId(gtrid);
            this.transactionUtils.setTxIdToThreadLocal(gtrid);
        }
        if (intTxnUrl == null && extTxnUrl == null) {
            return true;
        }
        if (request.getRequestURI().getClass().getName().contains("XAResourceCallbacks")) {
            return true;
        }
        if (this.microTxNonXAInstance.isNonXAInstancePresent()) {
            if (this.microTxNonXAInstance.enlistMicroTxNonXAResource(intTxnUrl, extTxnUrl)) {
                LOGGER.info("NonXA instance enlisted");
            } else {
                LOGGER.error("Unable to enlistNonXa");
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.microTxInterceptorService.logResponse(request, response);
        LOGGER.info("MicroTxXaServerInterceptor Response Status :" + response.getStatus());
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        this.transactionUtils.setTxIdToThreadLocal(request);
        LOGGER.debug("Request and Response are completed");
        this.microTxXaTxnStoreService.removeTransactionId();
    }
}

