/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.interceptor;

import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.tmm.jta.common.ThreadLocalXAConnection;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.TrmXAResourceType;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.common.XAConstants;
import oracle.tmm.jta.exceptions.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyFilter<T>
implements ResponseBodyAdvice<T> {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T beforeBodyWrite(T body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        boolean isXAResourceCallbacks;
        this.transactionUtils.setTxIdToThreadLocal((HttpRequest)request);
        ResponseBodyFilter responseBodyFilter = this;
        responseBodyFilter.microTxXaTxnStoreService.closeNonAciveXAConnection();
        try {
            this.microTxXaTxnStoreService.closeNonAciveNonXAConnection();
        }
        catch (SQLException e) {
            LOGGER.error("Error closing the non transactional non xa connection{}", (Object)e.getMessage());
        }
        if (!this.microTxXaTxnStoreService.isXaConnectionEmpty()) {
            HashMap<String, XAConnection> connections = this.microTxXaTxnStoreService.getXaConnections();
            connections.forEach((rmid, connection) -> {
                try {
                    if (connection != null) {
                        connection.close();
                        LOGGER.trace("connection closed on rmid {} ", rmid);
                    }
                }
                catch (SQLException ex) {
                    LOGGER.error("error while closing connection.", (Throwable)ex);
                }
            });
        }
        if (isXAResourceCallbacks = request.getClass().getName().contains("XAResourceCallbacks")) {
            this.microTxXaTxnStoreService.clear();
            return body;
        }
        TrmXaContext xaContext = this.microTxXaTxnStoreService.getLocalTransactionContext();
        if (xaContext != null) {
            xaContext.close();
        }
        try {
            for (String rmid2 : this.microTxXaTxnStoreService.getAllEnlistedRmids()) {
                TrmXid xid = this.microTxXaTxnStoreService.getEnlistedXid(rmid2);
                TrmXAResource trmXAResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid2);
                if (xid == null && this.microTxXaTxnStoreService.getTrmXaContext(rmid2) != null) {
                    xid = this.microTxXaTxnStoreService.getTrmXaContext((String)rmid2).trmXid;
                }
                if (xid == null) continue;
                try {
                    LOGGER.trace("cleanup in response filter: {} with rmid: {}", (Object)xid, (Object)rmid2);
                    if (trmXAResource != null && trmXAResource.trmXAResourceType == TrmXAResourceType.PostgreSQL) {
                        this.microTxXaTxnStoreService.getTrmXaContext((String)rmid2).xaRes.end(xid, 0x4000000);
                        LOGGER.trace("rmid {} , XaResource end(TMSUCCESS) for xid {} ", (Object)rmid2, (Object)xid.contextString());
                        continue;
                    }
                    if (this.microTxXaTxnStoreService.getTrmXaContext(rmid2) == null) continue;
                    this.microTxXaTxnStoreService.getTrmXaContext((String)rmid2).xaRes.end(xid, 0x2000000);
                    LOGGER.trace("rmid {} , XaResource end(TMSUSPEND) for xid {} ", (Object)rmid2, (Object)xid.contextString());
                }
                catch (XAException e) {
                    response.setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                    String message = e.getMessage() + " " + e.errorCode;
                    try {
                        response.getBody().write(message.getBytes());
                    }
                    catch (Exception ioe) {
                        LOGGER.error("ResponseBodyAdvice unable to write error message : {} error : {}", (Object)message, (Object)ioe.getMessage());
                    }
                    LOGGER.error("MicroTxXaServerInterceptor XAException Error Code : {} error : {} {}", new Object[]{e.errorCode, XAConstants.XAErrorCode.getErrorMessage(e.errorCode), ExceptionUtils.getExceptionMetadata(e)});
                }
                catch (Exception e) {
                    response.setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                    try {
                        response.getBody().write(e.getMessage().getBytes());
                    }
                    catch (Exception ioe) {
                        LOGGER.error("ResponseBodyAdvice unable to write error message : {} error : {}", (Object)e.getMessage(), (Object)ioe.getMessage());
                    }
                    LOGGER.error("MicroTxXaServerInterceptor Exception: {}", (Object)ExceptionUtils.getExceptionMetadata(e));
                }
                finally {
                    TrmXaContext ctx = this.microTxXaTxnStoreService.getTrmXaContext(rmid2);
                    if (ctx == null || trmXAResource != null && trmXAResource.trmXAResourceType == TrmXAResourceType.PostgreSQL) continue;
                    ctx.close();
                    LOGGER.trace("XA CTX closed for XID {} ", (Object)xid);
                }
            }
        }
        finally {
            ThreadLocalXAConnection.remove();
            this.microTxXaTxnStoreService.clear();
        }
        LOGGER.trace("Response Body: {}", (Object)body.toString());
        return body;
    }
}

