/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.nonXA;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import javax.transaction.xa.Xid;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.nonxa.NonXAException;
import oracle.tmm.jta.nonxa.internal.AsyncLLRCommitRecordDeletion;
import oracle.tmm.jta.nonxa.internal.TrmNonXAContext;
import oracle.tmm.jta.nonxa.internal.TrmNonXAInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MicroTxNonXADsConnection
implements TrmNonXAInstance {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    private static DataSource nonXADataSource;
    private static ExecutorService executor;
    private static long timer;
    private static Map<String, Connection> nonXADsConnectionsMap;
    private static final Logger LOGGER;
    private static LinkedList<CommitRecord> inMemoryCommitRecordList;

    public static void setNonXADataSource(DataSource ds) {
        nonXADataSource = ds;
    }

    public static DataSource getNonXADataSource() {
        return nonXADataSource;
    }

    @Override
    public void init(TrmXid xid, String requestId) throws NonXAException {
        if (nonXADataSource == null) {
            throw new NonXAException("Nonxa datasource is not set. Getting non xa ds connection failed for the given XID:" + xid);
        }
        try {
            Connection conn = nonXADataSource.getConnection();
            conn.setSavepoint();
            conn.setAutoCommit(false);
            if (requestId != null && !requestId.isEmpty()) {
                int MAX_OCSID_CLIENTID_LENGTH = 64;
                Properties prop = new Properties();
                prop.setProperty("OCSID.CLIENTID", requestId.substring(0, Math.min(requestId.length(), 64)));
                conn.setClientInfo(prop);
            }
            nonXADsConnectionsMap.put(new String(xid.getGlobalTransactionId()), conn);
            TrmNonXAContext context = new TrmNonXAContext(xid, conn);
            this.microTxXaTxnStoreService.setNonXaContext(context);
        }
        catch (SQLException e) {
            throw new NonXAException("Exception while getting non xa ds connection:" + e.getMessage());
        }
    }

    public static void loadLlrCommitRecord(DataSource nonXADataSource) throws SQLException {
        LinkedList<CommitRecord> inMemoryRecords = new LinkedList<CommitRecord>();
        Connection conn = null;
        try {
            try {
                conn = nonXADataSource.getConnection();
                String query = "SELECT * FROM LLR_COMMIT_RECORD";
                try (PreparedStatement statement = conn.prepareStatement(query);
                     ResultSet dataSet = statement.executeQuery();){
                    while (dataSet.next()) {
                        CommitRecord databaseRecord = new CommitRecord(dataSet.getString("GTRID"), Timestamp.valueOf(dataSet.getString("DATE_COMMITED")));
                        inMemoryRecords.add(databaseRecord);
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("Wrong values in LLR_COMMIT_RECORD", (Throwable)e);
                throw new SQLException("Failed to load loadLlrCommitRecord", e);
            }
            finally {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error in closing the connection");
            throw new SQLException("Failed to load loadLlrCommitRecord", e);
        }
        inMemoryCommitRecordList = inMemoryRecords;
    }

    @Override
    public void commit(TrmXid xid, byte[] commitRecord, boolean isFinalRetry) throws NonXAException {
        LOGGER.info("Commit NonXa ds connection with xid: " + xid.contextString());
        Connection conn = this.getInstance(xid);
        try {
            if (MicroTxConfig.isXaLLRSupport().booleanValue()) {
                Timestamp currentTimestamp = new Timestamp(new Date().getTime());
                CommitRecord record = new CommitRecord(new String(xid.getGlobalTransactionId()), currentTimestamp);
                inMemoryCommitRecordList.add(record);
                String query = "INSERT into LLR_COMMIT_RECORD(GTRID, DATE_COMMITED, RECORDSTR) values(?, ?, ?)";
                try (PreparedStatement statement = conn.prepareStatement(query);){
                    statement.setString(1, new String(xid.getGlobalTransactionId()));
                    statement.setTimestamp(2, currentTimestamp);
                    statement.setString(3, new String(commitRecord));
                    statement.execute();
                }
                if (System.currentTimeMillis() - timer > MicroTxConfig.getLlrDeleteCommitRecordTimeInterval()) {
                    long currentTime = System.currentTimeMillis();
                    HashSet<String> expiredGtrids = new HashSet<String>();
                    ListIterator it = inMemoryCommitRecordList.listIterator();
                    while (it.hasNext()) {
                        CommitRecord currentRecord = (CommitRecord)it.next();
                        if (currentRecord.timestamp.getTime() > timer) continue;
                        expiredGtrids.add("'" + currentRecord.getGtrid() + "'");
                        it.remove();
                    }
                    if (expiredGtrids.size() > 0) {
                        AsyncLLRCommitRecordDeletion asyncDelete = new AsyncLLRCommitRecordDeletion(nonXADataSource, expiredGtrids);
                        executor.execute(asyncDelete);
                    }
                    timer = currentTime;
                }
            }
            conn.commit();
            this.remove(xid);
        }
        catch (SQLException e) {
            throw new NonXAException("Error while committing the local transaction:" + e.getMessage());
        }
        finally {
            if (isFinalRetry && nonXADsConnectionsMap.containsKey(new String(xid.getGlobalTransactionId()))) {
                this.remove(xid);
            }
        }
    }

    @Override
    public void rollback(TrmXid xid, boolean isFinalRetry) throws NonXAException {
        LOGGER.info("Rollback NonXa ds connection with xid: " + xid.contextString());
        Connection conn = this.getInstance(xid);
        try {
            conn.rollback();
            this.remove(xid);
        }
        catch (SQLException e) {
            throw new NonXAException("Error while rolling back the local transaction:" + e.getMessage());
        }
        finally {
            if (isFinalRetry && nonXADsConnectionsMap.containsKey(new String(xid.getGlobalTransactionId()))) {
                this.remove(xid);
            }
        }
    }

    @Override
    public String[] recover(TrmXid xid) throws NonXAException {
        LOGGER.info("Recover NonXa transactions");
        HashSet<String> expiredGtrids = new HashSet<String>();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = nonXADataSource.getConnection();
            String query = "SELECT * FROM LLR_COMMIT_RECORD";
            statement = conn.prepareStatement(query);
            ArrayList<String> commitRecords = new ArrayList<String>();
            long currentTime = System.currentTimeMillis();
            try (ResultSet dataSet = statement.executeQuery();){
                while (dataSet.next()) {
                    Timestamp recordTimeStamp = Timestamp.valueOf(dataSet.getString("DATE_COMMITED"));
                    if (currentTime - recordTimeStamp.getTime() >= MicroTxConfig.getLlrDeleteCommitRecordTimeInterval()) {
                        expiredGtrids.add("'" + dataSet.getString("GTRID") + "'");
                        continue;
                    }
                    commitRecords.add(dataSet.getString("RECORDSTR"));
                }
            }
            if (expiredGtrids.size() > 0) {
                AsyncLLRCommitRecordDeletion asyncDelete = new AsyncLLRCommitRecordDeletion(nonXADataSource, expiredGtrids);
                executor.execute(asyncDelete);
            }
            String[] stringArray = commitRecords.toArray(new String[commitRecords.size()]);
            return stringArray;
        }
        catch (SQLException e) {
            throw new NonXAException("Error while recovering the local transaction details:" + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                LOGGER.error("Error while closing the non xa datasource connection:" + ex.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(TrmXid xid) throws NonXAException {
        Connection conn = this.getInstance(xid);
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing the NonxaSqlConnection : " + e.getMessage());
        }
        finally {
            nonXADsConnectionsMap.remove(new String(xid.getGlobalTransactionId()));
            this.microTxXaTxnStoreService.clear();
        }
    }

    private Connection getInstance(Xid xid) throws NonXAException {
        String gtrid = new String(xid.getGlobalTransactionId());
        if (!nonXADsConnectionsMap.containsKey(gtrid)) {
            throw new NonXAException(String.format("Nonxa sql connection not found for the given XID:%s GTRID:%s", xid, gtrid));
        }
        return nonXADsConnectionsMap.get(gtrid);
    }

    static {
        executor = Executors.newFixedThreadPool(2);
        timer = 0L;
        nonXADsConnectionsMap = new ConcurrentHashMap<String, Connection>();
        LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        inMemoryCommitRecordList = new LinkedList();
    }

    public static class CommitRecord {
        private String gtrid;
        private Timestamp timestamp;

        private CommitRecord(String gtrid, Timestamp timestamp) {
            this.gtrid = gtrid;
            this.timestamp = timestamp;
        }

        public String getGtrid() {
            return this.gtrid;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            CommitRecord other = (CommitRecord)o;
            return other.timestamp.equals(this.timestamp) && other.gtrid.equals(this.gtrid);
        }

        public int hashCode() {
            return this.timestamp.hashCode();
        }

        public int compareTo(Object o) {
            CommitRecord other = (CommitRecord)o;
            if (this.timestamp.equals(other.timestamp)) {
                return this.gtrid.compareTo(other.gtrid);
            }
            return (int)(other.timestamp.getTime() - this.timestamp.getTime());
        }

        public String toString() {
            return this.gtrid;
        }
    }
}

