/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.nonXA;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAResource;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAResourceManager;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import oracle.tmm.jta.nonxa.NonXAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.RequestScope;

@Service
@RequestScope
public class MicroTxNonXAInstance {
    @Autowired(required=false)
    @Qualifier(value="NonXA")
    private NonXAResource trmNonXAInstance;
    @Autowired
    MicroTxNonXAResourceManager microTxNonXAResourceManager;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxNonXAResource microTxNonXAResource;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean isNonXAInstancePresent() {
        return this.trmNonXAInstance != null;
    }

    public MicroTxNonXAResource getTrmNonXAInstance() {
        this.microTxNonXAResource.setNonXAResource(this.trmNonXAInstance);
        return this.microTxNonXAResource;
    }

    public boolean enlistMicroTxNonXAResource(URI intTxnUrl, URI extTxnUrl) {
        MicroTxNonXAResourceManager.setResourceManagerId(MicroTxConfig.getResourceManagerId());
        if (MicroTxConfig.isXaLLRSupport().booleanValue()) {
            MicroTxNonXAResourceManager.setLLRBranch(true);
        }
        if (MicroTxConfig.isXaLRCSupport().booleanValue()) {
            MicroTxNonXAResourceManager.setLRCBranch(true);
        }
        try {
            this.microTxNonXAResourceManager.enlistNonXA(MicroTxNonXAResourceManager.getResourceManagerId(), intTxnUrl.toString(), extTxnUrl.toString(), this.microTxXaTxnStoreService.getRequestId());
        }
        catch (Exception e) {
            LOGGER.error("Failed to enlist NonXAResource  {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

