/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.nonXA;

import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.Xid;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.nonxa.NonXAException;
import oracle.tmm.jta.nonxa.NonXAResource;
import oracle.tmm.jta.nonxa.internal.TrmNonXAContext;
import oracle.tmm.jta.nonxa.internal.TrmNonXAInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MicroTxNonXAResource
implements TrmNonXAInstance {
    private NonXAResource nonXAResource;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    private static Map<String, NonXAResource> nonXAResourcesMap = new ConcurrentHashMap<String, NonXAResource>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setNonXAResource(NonXAResource nonXAResource) {
        this.nonXAResource = nonXAResource;
    }

    public boolean isNonXaResourcePresent() {
        return this.nonXAResource != null;
    }

    @Override
    public void init(TrmXid xid, String requestId) throws NonXAException {
        try {
            if (this.nonXAResource == null) {
                throw new NonXAException("Error getting NonXaResource instance");
            }
            this.nonXAResource.begin(xid);
            nonXAResourcesMap.put(new String(xid.getGlobalTransactionId()), this.nonXAResource);
            TrmNonXAContext context = new TrmNonXAContext(xid, this.nonXAResource);
            this.microTxXaTxnStoreService.setNonXaContext(context);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void commit(TrmXid xid, byte[] commitRecord, boolean isFinalRetry) throws NonXAException {
        LOGGER.info("Commit NonXa transaction with xid: " + xid.contextString());
        NonXAResource nonXAResource = this.getInstance(xid);
        nonXAResource.commit(xid, commitRecord);
    }

    @Override
    public void rollback(TrmXid xid, boolean isFinalRetry) throws NonXAException {
        LOGGER.info("Rollback NonXa transaction with xid: {}", (Object)xid.contextString());
        NonXAResource nonXAResource = this.getInstance(xid);
        nonXAResource.rollback(xid);
    }

    @Override
    public String[] recover(TrmXid xid) throws NonXAException {
        LOGGER.info("Recover NonXa transactions");
        List<byte[]> commitRecordList = this.nonXAResource.recover();
        if (commitRecordList != null && commitRecordList.size() > 0) {
            String[] commitRecords = new String[commitRecordList.size()];
            for (int i = 0; i < commitRecordList.size(); ++i) {
                commitRecords[i] = new String(commitRecordList.get(0));
            }
            return commitRecords;
        }
        return null;
    }

    @Override
    public void remove(TrmXid xid) throws NonXAException {
        nonXAResourcesMap.remove(new String(xid.getGlobalTransactionId()));
    }

    private NonXAResource getInstance(Xid xid) throws NonXAException {
        if (!nonXAResourcesMap.containsKey(new String(xid.getGlobalTransactionId()))) {
            throw new NonXAException("NonXaResource instance not found for the given XID:" + xid);
        }
        return nonXAResourcesMap.get(new String(xid.getGlobalTransactionId()));
    }
}

