/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.nonXA;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXADsConnection;
import com.oracle.microtx.springboot.nonXA.MicroTxNonXAInstance;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.coordinator.MicroTxCoordinatorClient;
import jakarta.transaction.SystemException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import oracle.tmm.common.TmsHostCache;
import oracle.tmm.jta.common.DataSourceInfo;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.nonxa.NonXAException;
import oracle.tmm.jta.nonxa.NonXaResourceManager;
import oracle.tmm.jta.pojo.TcsEnlistedResponsePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MicroTxNonXAResourceManager
extends NonXaResourceManager {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxNonXADsConnection microTxNonXADsConnection;
    @Autowired
    MicroTxNonXAInstance microTxNonXAInstance;
    @Autowired
    MicroTxCoordinatorClient microTxCoordinatorClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Autowired
    MicroTxNonXAResourceManager() {
        llrBranch = MicroTxConfig.isXaLLRSupport();
        lrcBranch = MicroTxConfig.isXaLRCSupport();
    }

    public static void registerNonXaDataSource(DataSource dataSource, DataSourceInfo dataSourceInfo) throws SQLException {
        nonXADataSource = dataSource;
        resourceManagerId = dataSourceInfo.getResourceManagerId();
        llrBranch = dataSourceInfo.isLLRSupport();
        lrcBranch = dataSourceInfo.isLRCSupport();
        dababaseName = dataSourceInfo.getDataSourceName();
        MicroTxNonXADsConnection.loadLlrCommitRecord(nonXADataSource);
        MicroTxNonXADsConnection.setNonXADataSource(dataSource);
    }

    public DataSource getNonXADatasource() {
        return MicroTxNonXADsConnection.getNonXADataSource();
    }

    @Override
    public TrmXid enlistNonXA(String rmid, String internalTransactionUrl, String externalTransactionUrl, String requestId) throws Exception {
        String transactionUrl = TmsHostCache.checkTmsHostReachable(internalTransactionUrl) ? internalTransactionUrl : externalTransactionUrl;
        ObjectMapper objectMapper = new ObjectMapper();
        String gtrid = transactionUrl.substring(transactionUrl.lastIndexOf(47) + 1);
        try {
            ResponseEntity<String> response = this.microTxCoordinatorClient.enlistNonXA(transactionUrl, gtrid, rmid, MicroTxNonXAResourceManager.isLLRBranch(), MicroTxNonXAResourceManager.isLRCBranch());
            HttpStatus httpStatus = HttpStatus.resolve((int)response.getStatusCode().value());
            if (!httpStatus.equals((Object)HttpStatus.CREATED) && !httpStatus.equals((Object)HttpStatus.OK)) {
                throw new IOException("Enlist Failed " + transactionUrl + " Error: " + (String)response.getBody() + " " + response.getStatusCodeValue());
            }
            TcsEnlistedResponsePayload tcsEnlistedResponsePayload = (TcsEnlistedResponsePayload)objectMapper.readValue((String)response.getBody(), TcsEnlistedResponsePayload.class);
            LOGGER.debug("NonXa Enlist status {} with response: {}", (Object)httpStatus, (Object)tcsEnlistedResponsePayload.toString());
            return this.afterEnlist(tcsEnlistedResponsePayload, requestId, gtrid, rmid);
        }
        catch (Exception e) {
            LOGGER.error("Exception while enlisting the nonxa resource: {}", (Object)e.getMessage());
            LOGGER.trace("enlistNonXA failed", (Throwable)e);
            throw e;
        }
    }

    @Override
    public TrmXid afterEnlist(TcsEnlistedResponsePayload tcsEnlistedResponsePayload, String requestId, String gtrid, String rmid) throws NonXAException, SystemException {
        List<TcsEnlistedResponsePayload.Branch> branchList = tcsEnlistedResponsePayload.branches;
        String bqual = branchList.get((int)0).bqual;
        TrmXid xid = new TrmXid(gtrid, 0, bqual);
        this.microTxXaTxnStoreService.setEnlistedXid(rmid, xid);
        LOGGER.info("LLR/LRC participant XID: {}", (Object)xid.contextString());
        if (this.microTxNonXAInstance.isNonXAInstancePresent()) {
            this.microTxNonXAInstance.getTrmNonXAInstance().init(xid, requestId);
        } else {
            this.microTxNonXADsConnection.init(xid, requestId);
        }
        return xid;
    }
}

