/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.springboot.transactional;

import com.oracle.microtx.springboot.transactional.MicroTxTransactionException;
import com.oracle.microtx.springboot.transactional.MicroTxTransactionStatus;
import com.oracle.microtx.springboot.transactional.TransactionalData;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.rm.MicroTxUserTransaction;
import com.oracle.microtx.xa.rm.MicroTxUserTransactionService;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionRequiredException;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.web.context.annotation.RequestScope;

@Controller
@RequestScope
public class MicroTxTransactionManager
implements PlatformTransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Stack<TransactionalData> transactionalDataStack = new Stack();
    @Autowired
    @Lazy
    MicroTxTransactionStatus microTxTransactionStatus;
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    @Lazy
    MicroTxUserTransactionService newMicroTxUserTransactionService;

    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        int propagation = definition.getPropagationBehavior();
        switch (propagation) {
            case 0: {
                return this.microTxTransactionRequired(definition);
            }
            case 1: {
                return this.microTxTransactionSupports(definition);
            }
            case 2: {
                return this.microTxTransactionMandatory(definition);
            }
            case 3: {
                return this.microTxTransactionRequiresNew(definition);
            }
            case 4: {
                return this.microTxTransactionNotSupported(definition);
            }
            case 5: {
                return this.microTxTransactionNever(definition);
            }
            case 6: {
                return this.microTxTransactionNested(definition);
            }
        }
        throw new MicroTxTransactionException("Propagation type not supported");
    }

    public void commit(TransactionStatus status) throws TransactionException {
        TransactionalData txnData = this.transactionalDataStack.pop();
        int propagation = txnData.getDefinition().getPropagationBehavior();
        MicroTxUserTransaction userTransaction = null;
        MicroTxUserTransaction prevUserTransaction = null;
        switch (propagation) {
            case 0: {
                userTransaction = txnData.getCurrentUserTxn();
                break;
            }
            case 1: {
                if (txnData.getCurrentUserTxn() == null) {
                    return;
                }
                userTransaction = txnData.getCurrentUserTxn();
                break;
            }
            case 2: {
                userTransaction = txnData.getCurrentUserTxn();
                break;
            }
            case 3: {
                userTransaction = txnData.getCurrentUserTxn();
                prevUserTransaction = txnData.getPrevUserTxn();
                break;
            }
            case 4: {
                if (txnData.getPrevUserTxn() == null) {
                    return;
                }
                txnData.getPrevUserTxn().resume();
                return;
            }
            case 5: {
                return;
            }
            case 6: {
                return;
            }
            default: {
                throw new MicroTxTransactionException("Propagation type not supported");
            }
        }
        try {
            userTransaction.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException | IllegalStateException | SecurityException e) {
            throw new MicroTxTransactionException(e.getMessage(), e);
        }
        if (prevUserTransaction != null) {
            prevUserTransaction.resume();
        }
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        LOGGER.trace("Inside rollback");
        TransactionalData txnData = this.transactionalDataStack.pop();
        int propagation = txnData.getDefinition().getPropagationBehavior();
        MicroTxUserTransaction userTransaction = null;
        MicroTxUserTransaction prevUserTransaction = null;
        switch (propagation) {
            case 0: {
                userTransaction = txnData.getCurrentUserTxn();
                break;
            }
            case 1: {
                if (txnData.getCurrentUserTxn() == null) {
                    return;
                }
                userTransaction = txnData.getCurrentUserTxn();
                break;
            }
            case 2: {
                userTransaction = txnData.getCurrentUserTxn();
                break;
            }
            case 3: {
                userTransaction = txnData.getCurrentUserTxn();
                prevUserTransaction = txnData.getPrevUserTxn();
                break;
            }
            case 4: {
                if (txnData.getPrevUserTxn() == null) {
                    return;
                }
                txnData.getPrevUserTxn().resume();
                return;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new MicroTxTransactionException("Propagation type not supported");
            }
        }
        try {
            if (Objects.nonNull(userTransaction)) {
                userTransaction.rollback();
            } else {
                LOGGER.error("Transaction propagation {} type is not supported ", (Object)propagation);
            }
        }
        catch (SystemException | IllegalStateException | SecurityException e) {
            throw new MicroTxTransactionException(e.getMessage(), e);
        }
        if (prevUserTransaction != null) {
            prevUserTransaction.resume();
        }
    }

    private MicroTxTransactionStatus microTxTransactionRequired(TransactionDefinition definition) throws TransactionException {
        LOGGER.info("MicroTxTransactionManager Required");
        MicroTxUserTransaction tx = this.microTxXaTxnStoreService.getUserTransaction();
        if (tx == null) {
            tx = this.newMicroTxUserTransactionService;
            try {
                if (definition.getTimeout() != -1) {
                    long timeout = TimeUnit.SECONDS.toMillis(definition.getTimeout());
                    tx.setTransactionTimeout((int)timeout);
                }
                tx.begin();
            }
            catch (NotSupportedException | SystemException e) {
                throw new MicroTxTransactionException(e.getMessage(), e);
            }
        }
        TransactionalData txnData = new TransactionalData(definition, tx);
        this.transactionalDataStack.push(txnData);
        return this.microTxTransactionStatus;
    }

    private TransactionStatus microTxTransactionSupports(TransactionDefinition definition) throws TransactionException {
        LOGGER.info("MicroTxTransactionManager Supports");
        MicroTxUserTransaction tx = this.microTxXaTxnStoreService.getUserTransaction();
        TransactionalData txnData = new TransactionalData(definition, tx);
        this.transactionalDataStack.push(txnData);
        return this.microTxTransactionStatus;
    }

    private TransactionStatus microTxTransactionMandatory(TransactionDefinition definition) throws TransactionException {
        LOGGER.info("MicroTxTransactionManager Mandatory");
        MicroTxUserTransaction tx = this.microTxXaTxnStoreService.getUserTransaction();
        if (tx == null) {
            throw new MicroTxTransactionException("Called outside of Transaction", (Throwable)new TransactionRequiredException());
        }
        TransactionalData txnData = new TransactionalData(definition, tx);
        this.transactionalDataStack.push(txnData);
        return this.microTxTransactionStatus;
    }

    private TransactionStatus microTxTransactionRequiresNew(TransactionDefinition definition) throws TransactionException {
        LOGGER.info("MicroTxTransactionManager RequiresNew");
        MicroTxUserTransaction tx = this.microTxXaTxnStoreService.getUserTransaction();
        MicroTxUserTransaction prev = null;
        if (tx != null) {
            prev = tx;
            prev.suspend();
        }
        tx = this.newMicroTxUserTransactionService;
        try {
            if (definition.getTimeout() != -1) {
                long timeout = TimeUnit.SECONDS.toMillis(definition.getTimeout());
                tx.setTransactionTimeout((int)timeout);
            }
            tx.begin();
        }
        catch (NotSupportedException | SystemException e) {
            throw new MicroTxTransactionException(e.getMessage(), e);
        }
        TransactionalData txnData = new TransactionalData(definition, tx);
        txnData.setPrevUserTxn(prev);
        this.transactionalDataStack.push(txnData);
        return this.microTxTransactionStatus;
    }

    private TransactionStatus microTxTransactionNotSupported(TransactionDefinition definition) throws TransactionException {
        LOGGER.info("MicroTxTransactionManager NotSupported");
        MicroTxUserTransaction tx = this.microTxXaTxnStoreService.getUserTransaction();
        if (tx != null) {
            tx.suspend();
        }
        TransactionalData txnData = new TransactionalData(definition, null);
        txnData.setPrevUserTxn(tx);
        this.transactionalDataStack.push(txnData);
        return this.microTxTransactionStatus;
    }

    private TransactionStatus microTxTransactionNever(TransactionDefinition definition) throws TransactionException {
        LOGGER.info("MicroTxTransactionManager Never");
        MicroTxUserTransaction tx = this.microTxXaTxnStoreService.getUserTransaction();
        if (tx != null) {
            throw new MicroTxTransactionException("Called inside Transaction context", (Throwable)new InvalidTransactionException());
        }
        TransactionalData txnData = new TransactionalData(definition, null);
        this.transactionalDataStack.push(txnData);
        return this.microTxTransactionStatus;
    }

    private TransactionStatus microTxTransactionNested(TransactionDefinition definition) throws TransactionException {
        LOGGER.info("MicroTxTransactionManager Nested");
        throw new MicroTxTransactionException("Nested not supported", (Throwable)new InvalidTransactionException());
    }
}

