/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.store;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.store.MicroTxXaTxnStore;
import com.oracle.microtx.xa.rm.MicroTxUserTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.XAConnection;
import oracle.tmm.jta.common.ThreadLocalXAConnection;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.nonxa.internal.TrmNonXAContext;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.RequestScope;

@Service
@RequestScope
public class MicroTxXaTxnStoreService
implements MicroTxXaTxnStore {
    private static ThreadLocal<HashMap<String, MicroTxUserTransaction>> threadLocalUserTransaction = ThreadLocal.withInitial(() -> new HashMap());
    private static ThreadLocal<Boolean> isPromotable = ThreadLocal.withInitial(() -> false);
    private static ThreadLocal<HashMap<String, String>> threadLocalUrl = ThreadLocal.withInitial(() -> new HashMap());
    private static ThreadLocal<HashMap<String, TrmXaContext>> trmXaContextThreadLocal = ThreadLocal.withInitial(() -> new HashMap());
    private static ThreadLocal<HashMap<String, TrmXaContext>> trmNonActiveXaContextThreadLocal = ThreadLocal.withInitial(() -> new HashMap());
    private static ThreadLocal<Connection> nonActiveTrmNonXAConnection = ThreadLocal.withInitial(() -> null);
    private static ThreadLocal<HashMap<String, String>> transactionDetails = ThreadLocal.withInitial(() -> new HashMap());
    private static ThreadLocal<HashMap<String, String>> localTransactionDetails = ThreadLocal.withInitial(() -> new HashMap());
    private static ThreadLocal<Boolean> isLocalTransactionAvailable = ThreadLocal.withInitial(() -> true);
    private static ThreadLocal<HashMap<String, TrmXid>> threadLocalEnlistedXids = ThreadLocal.withInitial(() -> new HashMap());
    private static ThreadLocal<Map<String, List<String>>> transactionRequestHeadersThreadLocal = new ThreadLocal();
    private static ThreadLocal<TrmNonXAContext> trmNonXaContextThreadLocal = new ThreadLocal();
    private static final ThreadLocal<String> XA_TXN_ID_THREAD_LOCAL = ThreadLocal.withInitial(String::new);

    @Override
    public Boolean isPromotable() {
        return isPromotable.get();
    }

    public static Boolean isPromotableS() {
        return isPromotable.get();
    }

    @Override
    public void setIsPromotable(Boolean isPromotableValue) {
        isPromotable.set(isPromotableValue);
    }

    public void setUserTransaction(MicroTxUserTransaction userTransaction) {
        threadLocalUserTransaction.get().put("default", userTransaction);
    }

    public void setLocalUserTransaction(MicroTxUserTransaction userTransaction) {
        threadLocalUserTransaction.get().put("local_transaction", userTransaction);
    }

    public static void setLocalUserTransactionS(MicroTxUserTransaction userTransaction) {
        threadLocalUserTransaction.get().put("local_transaction", userTransaction);
    }

    public MicroTxUserTransaction getUserTransaction() {
        if (threadLocalUserTransaction.get().containsKey("default")) {
            return threadLocalUserTransaction.get().get("default");
        }
        return null;
    }

    public MicroTxUserTransaction getLocalUserTransaction() {
        if (threadLocalUserTransaction.get().containsKey("local_transaction")) {
            return threadLocalUserTransaction.get().get("local_transaction");
        }
        return null;
    }

    @Override
    public void removeLocalUserTransaction() {
        if (threadLocalUserTransaction.get().containsKey("local_transaction")) {
            threadLocalUserTransaction.get().remove("local_transaction");
        }
    }

    @Override
    public void removeUserTransaction() {
        threadLocalUserTransaction.remove();
    }

    @Override
    public void setXaConnection(XAConnection xaConnection) {
        ThreadLocalXAConnection.set(xaConnection);
    }

    @Override
    public XAConnection getXaConnection() {
        return ThreadLocalXAConnection.get();
    }

    @Override
    public void setXaConnection(String rmid, XAConnection xaConnection) {
        ThreadLocalXAConnection.set(rmid, xaConnection);
    }

    @Override
    public XAConnection getXaConnection(String rmid) {
        return ThreadLocalXAConnection.get(rmid);
    }

    @Override
    public boolean isXaConnectionEmpty() {
        return ThreadLocalXAConnection.isEmpty();
    }

    @Override
    public HashMap<String, XAConnection> getXaConnections() {
        return ThreadLocalXAConnection.getXaConnections();
    }

    @Override
    public void setInternalURI(String internalURI) {
        threadLocalUrl.get().put("internal_uri", internalURI);
    }

    @Override
    public void setExternalURI(String externalUri) {
        threadLocalUrl.get().put("external_uri", externalUri);
    }

    @Override
    public String getInternalURI() {
        return threadLocalUrl.get().get("internal_uri");
    }

    @Override
    public String getExternalURI() {
        return threadLocalUrl.get().get("external_uri");
    }

    @Override
    public String getRequestId() {
        return threadLocalUrl.get().get("request_id");
    }

    @Override
    public void setRequestId(String requestId) {
        threadLocalUrl.get().put(requestId, "request_id");
    }

    @Override
    public boolean isInitiatorAsParticipant() {
        String value = threadLocalUrl.get().get("is_initiator_as_participant");
        return value != null && value.equals("true");
    }

    @Override
    public void setIsInitiatorAsParticipant() {
        threadLocalUrl.get().put("is_initiator_as_participant", "true");
    }

    @Override
    public String getGlobalTransactionId() {
        return transactionDetails.get().get("gtrid");
    }

    @Override
    public void setGlobalTransactionId(String gtrid) {
        transactionDetails.get().put("gtrid", gtrid);
    }

    @Override
    public void setTrmXaContext(TrmXaContext value) {
        trmXaContextThreadLocal.get().put(MicroTxConfig.resourceManagerId, value);
    }

    @Override
    public TrmXaContext getTrmXaContext() {
        return trmXaContextThreadLocal.get().get(MicroTxConfig.resourceManagerId);
    }

    public void setNonActiveNonXaConnection(Connection connection) {
        nonActiveTrmNonXAConnection.set(connection);
    }

    public Connection getNonActiveNonXaConnection() {
        return nonActiveTrmNonXAConnection.get();
    }

    public boolean IsNonActiveNonXaConnectionEmpty() {
        return nonActiveTrmNonXAConnection.get() == null;
    }

    public void closeNonAciveNonXAConnection() throws SQLException {
        if (!this.IsNonActiveNonXaConnectionEmpty()) {
            nonActiveTrmNonXAConnection.get().close();
        }
    }

    public static void setNonActiveXaContext(TrmXaContext value) {
        trmNonActiveXaContextThreadLocal.get().put("default", value);
    }

    public static TrmXaContext getNonActiveXaContext() {
        return trmNonActiveXaContextThreadLocal.get().get("default");
    }

    public static void setNonActiveXaContext(String rmid, TrmXaContext value) {
        trmNonActiveXaContextThreadLocal.get().put(rmid, value);
    }

    public static boolean IsNonActiveXaContextEmpty() {
        return trmNonActiveXaContextThreadLocal.get().isEmpty();
    }

    public static TrmXaContext getNonActiveXaContext(String rmid) {
        return trmNonActiveXaContextThreadLocal.get().get(rmid);
    }

    public static void closeNonAciveXAConnection() {
        if (!trmNonActiveXaContextThreadLocal.get().isEmpty()) {
            trmNonActiveXaContextThreadLocal.get().forEach((rmid, trmXaContext) -> trmXaContext.close());
        }
    }

    @Override
    public Set<String> getAllRmids() {
        return trmXaContextThreadLocal.get().keySet();
    }

    @Override
    public void setTrmXaContext(String rmid, TrmXaContext value) {
        trmXaContextThreadLocal.get().put(rmid, value);
    }

    @Override
    public TrmXaContext getTrmXaContext(String rmid) {
        return trmXaContextThreadLocal.get().get(rmid);
    }

    public static TrmXaContext getTrmXaContextS(String rmid) {
        return trmXaContextThreadLocal.get().get(rmid);
    }

    @Override
    public void setLocalTransactionRmid(String rmid) {
        localTransactionDetails.get().put("local_transaction", rmid);
    }

    public static void setLocalTransactionRmidS(String rmid) {
        localTransactionDetails.get().put("local_transaction", rmid);
    }

    @Override
    public boolean isLocalTransactionPresent() {
        return localTransactionDetails.get().get("local_transaction") != null;
    }

    @Override
    public void setIsLocalTransactionAvailable(Boolean localTransactionAvailablity) {
        isLocalTransactionAvailable.set(localTransactionAvailablity);
    }

    @Override
    public Boolean getIsLocalTransactionAvailable() {
        return isLocalTransactionAvailable.get();
    }

    @Override
    public String getLocalTransactionRmid() {
        return localTransactionDetails.get().get("local_transaction");
    }

    @Override
    public TrmXaContext getLocalTransactionContext() {
        return trmXaContextThreadLocal.get().get(this.getLocalTransactionRmid());
    }

    @Override
    public void setLocalTransactionContext(TrmXaContext ctx) {
        trmXaContextThreadLocal.get().put(this.getLocalTransactionRmid(), ctx);
    }

    public static void setLocalTransactionContextS(TrmXaContext ctx) {
        trmXaContextThreadLocal.get().put(MicroTxXaTxnStoreService.getLocalTransactionRmidS(), ctx);
    }

    @Override
    public boolean containsThreadLocalXaContext(String rmid) {
        return trmXaContextThreadLocal.get().containsKey(rmid);
    }

    @Override
    public void removeTrmXaContext() {
        trmXaContextThreadLocal.remove();
        transactionDetails.remove();
        localTransactionDetails.remove();
    }

    @Override
    public void setEnlistedXid(TrmXid xid) {
        threadLocalEnlistedXids.get().put(MicroTxConfig.resourceManagerId, xid);
    }

    @Override
    public TrmXid getEnlistedXid() {
        return threadLocalEnlistedXids.get().get(MicroTxConfig.resourceManagerId);
    }

    @Override
    public void setEnlistedXid(String rmid, TrmXid xid) {
        threadLocalEnlistedXids.get().put(rmid, xid);
    }

    @Override
    public TrmXid getEnlistedXid(String rmid) {
        return threadLocalEnlistedXids.get().get(rmid);
    }

    @Override
    public Set<String> getAllEnlistedRmids() {
        return threadLocalEnlistedXids.get().keySet();
    }

    @Override
    public void setRequestHeaders(Map<String, List<String>> headers) {
        transactionRequestHeadersThreadLocal.set(headers);
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        return transactionRequestHeadersThreadLocal.get();
    }

    @Override
    public void setNonXaContext(TrmNonXAContext obj) {
        trmNonXaContextThreadLocal.set(obj);
    }

    @Override
    public TrmNonXAContext getNonXaContext() {
        return trmNonXaContextThreadLocal.get();
    }

    @Override
    public String getDefaultRmid() {
        return MicroTxConfig.getResourceManagerId() != null ? MicroTxConfig.getResourceManagerId() : "default";
    }

    public boolean isMicroTxXaTrn() {
        return this.getInternalURI() != null || this.getExternalURI() != null;
    }

    public static boolean isLocalTransactionPresentS() {
        return localTransactionDetails.get().get("local_transaction") != null;
    }

    public static String getLocalTransactionRmidS() {
        return localTransactionDetails.get().get("local_transaction");
    }

    public static TrmXaContext getLocalTransactionContextS() {
        return trmXaContextThreadLocal.get().get(MicroTxXaTxnStoreService.getLocalTransactionRmidS());
    }

    public static boolean isXaConnectionEmptyS() {
        return ThreadLocalXAConnection.isEmpty();
    }

    public static XAConnection getXaConnectionS(String rmid) {
        return ThreadLocalXAConnection.get(rmid);
    }

    @Override
    public void setTransactionId(String txnId) {
        if (Objects.nonNull(txnId)) {
            XA_TXN_ID_THREAD_LOCAL.set(txnId);
            MDC.put((String)"microtx-txnId", (String)txnId);
        }
    }

    @Override
    public String getTransactionId() {
        return XA_TXN_ID_THREAD_LOCAL.get();
    }

    @Override
    public void removeTransactionId() {
        XA_TXN_ID_THREAD_LOCAL.remove();
        MDC.remove((String)"microtx-txnId");
    }

    @Override
    public void clear() {
        ThreadLocalXAConnection.remove();
        nonActiveTrmNonXAConnection.remove();
        threadLocalUrl.remove();
        threadLocalUrl.remove();
        trmXaContextThreadLocal.remove();
        transactionDetails.remove();
        localTransactionDetails.remove();
        threadLocalEnlistedXids.remove();
        transactionRequestHeadersThreadLocal.remove();
        trmNonXaContextThreadLocal.remove();
        threadLocalUserTransaction.remove();
        XA_TXN_ID_THREAD_LOCAL.remove();
        trmNonActiveXaContextThreadLocal.remove();
    }
}

