/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc;

import com.oracle.microtx.tcc.TccClient;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import java.util.ArrayList;
import java.util.List;
import oracle.tmm.tcc.TccCoordintorClient;
import oracle.tmm.tcc.exception.TccException;
import oracle.tmm.tcc.exception.TccHeuristicException;
import oracle.tmm.tcc.exception.TccUnknownTransactionException;
import oracle.tmm.tcc.vo.CancelRequest;
import oracle.tmm.tcc.vo.CancelResponse;
import oracle.tmm.tcc.vo.ConfirmRequest;
import oracle.tmm.tcc.vo.ConfirmResponse;
import oracle.tmm.tcc.vo.TccParticipant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
public class MicroTxTccClient
implements TccClient {
    @Autowired
    private MicroTxTccThreadLocalStorageService threadLocalStorageService;

    @Override
    public ConfirmResponse confirm() throws TccUnknownTransactionException, TccHeuristicException, TccException {
        return this.confirm(new ArrayList<TccParticipant>());
    }

    public ConfirmResponse confirm(List<TccParticipant> participants) throws TccUnknownTransactionException, TccHeuristicException, TccException {
        return this.currentTccTransaction().confirm(new ConfirmRequest(participants));
    }

    @Override
    public CancelResponse cancel() throws TccUnknownTransactionException, TccHeuristicException, TccException {
        return this.cancel(new ArrayList<TccParticipant>());
    }

    public CancelResponse cancel(List<TccParticipant> participants) throws TccUnknownTransactionException, TccHeuristicException, TccException {
        return this.currentTccTransaction().cancel(new CancelRequest(participants));
    }

    public String getTransactionId() throws TccUnknownTransactionException {
        return this.currentTccTransaction().getTransactionId();
    }

    private TccCoordintorClient currentTccTransaction() throws TccUnknownTransactionException {
        MicroTxTccClient microTxTccClient = this;
        TccCoordintorClient tccTransaction = microTxTccClient.threadLocalStorageService.get();
        if (tccTransaction == null) {
            throw new TccUnknownTransactionException("TCC Transaction not found", null);
        }
        return tccTransaction;
    }

    public void addTccParticipant(String uri) throws TccUnknownTransactionException {
        this.currentTccTransaction().addTccParticipant(new TccParticipant(uri, this.getTimeLimit()));
    }

    public void setTimeLimit(long timeLimit) throws TccUnknownTransactionException {
        this.currentTccTransaction().setTimeLimit(timeLimit);
    }

    public long getTimeLimit() throws TccUnknownTransactionException {
        return this.currentTccTransaction().getTimeLimit();
    }

    @Override
    public ConfirmResponse confirmTccWithOptionalParticipants(List<TccParticipant> participants) throws TccUnknownTransactionException, TccHeuristicException, TccException {
        return this.confirm(participants);
    }

    @Override
    public CancelResponse cancelTccWithOptionalParticipant(List<TccParticipant> participants) throws TccUnknownTransactionException, TccHeuristicException, TccException {
        return this.cancel(participants);
    }

    @Override
    public void setTccTimeLimit(long timeLimit) throws TccUnknownTransactionException {
        this.setTccTimeLimit(timeLimit);
    }

    @Override
    public long getTccTimeLimit() throws TccUnknownTransactionException {
        return this.getTimeLimit();
    }

    @Override
    public void addParticipant(String uri) throws TccUnknownTransactionException {
        this.addTccParticipant(uri);
    }

    @Override
    public String getTccTransactionId() throws TccUnknownTransactionException {
        return this.getTransactionId();
    }
}

