/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.microtx.tcc.pojo.TransactionDetails;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.tmm.tcc.TccCoordintorClient;
import oracle.tmm.tcc.exception.TccClientException;
import oracle.tmm.tcc.exception.TccException;
import oracle.tmm.tcc.exception.TccHeuristicException;
import oracle.tmm.tcc.exception.TccUnknownTransactionException;
import oracle.tmm.tcc.vo.CancelRequest;
import oracle.tmm.tcc.vo.CancelResponse;
import oracle.tmm.tcc.vo.ConfirmRequest;
import oracle.tmm.tcc.vo.ConfirmResponse;
import oracle.tmm.tcc.vo.TccParticipant;
import oracle.tmm.tcc.vo.TccTransactionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.annotation.RequestScope;

@Service
@RequestScope
public class MicroTxTccCoordinatorClientService
implements TccCoordintorClient {
    @Autowired
    @Qualifier(value="MicroTxTccRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    MicroTxTccThreadLocalStorageService threadLocalStorageService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String dummyEmptyBody = "{ }";

    @Override
    public ConfirmResponse confirm(ConfirmRequest request) throws TccException, TccUnknownTransactionException, TccHeuristicException {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        String txnId = transactionDetails.getTxnId();
        List<TccParticipant> tccParticipants = transactionDetails.getTccParticipants();
        String txnUrl = transactionDetails.getTxnUrl();
        LOGGER.info("confirm transaction: {}", (Object)txnId);
        request.addParticipants(tccParticipants);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestHttpEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(txnUrl, HttpMethod.PUT, requestHttpEntity, String.class, new Object[0]);
            LOGGER.info("Successfully Confirmed the transaction:{}", (Object)txnId);
            return (ConfirmResponse)this.objectMapper.readValue((String)response.getBody(), ConfirmResponse.class);
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode status = e.getStatusCode();
            if (status.value() == HttpStatus.NOT_FOUND.value()) {
                throw new TccUnknownTransactionException("Transaction not found", null);
            }
            if (status.value() == HttpStatus.CONFLICT.value()) {
                try {
                    ConfirmResponse confirmResponse = (ConfirmResponse)this.objectMapper.readValue(e.getResponseBodyAsString(), ConfirmResponse.class);
                    throw new TccHeuristicException(confirmResponse.getParticipants(), "Conflict. Participants are in mixed state", null);
                }
                catch (JsonProcessingException ex) {
                    throw new TccHeuristicException(new ArrayList<TccParticipant>(), "Conflict. Participants are in mixed state", null);
                }
            }
            throw new TccException(e.getResponseBodyAsString(), null);
        }
        catch (JsonProcessingException e) {
            throw new TccClientException("Error while creating request", e);
        }
    }

    @Override
    public CancelResponse cancel(CancelRequest request) throws TccException, TccUnknownTransactionException, TccHeuristicException {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        String txnId = transactionDetails.getTxnId();
        List<TccParticipant> tccParticipants = transactionDetails.getTccParticipants();
        String txnUrl = transactionDetails.getTxnUrl();
        LOGGER.info(" cancel transaction:{}", (Object)txnId);
        request.addParticipants(tccParticipants);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestHttpEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(txnUrl, HttpMethod.DELETE, requestHttpEntity, String.class, new Object[0]);
            LOGGER.info("Successfully Canceled the transaction:{}", (Object)txnId);
            return (CancelResponse)this.objectMapper.readValue((String)response.getBody(), CancelResponse.class);
        }
        catch (HttpStatusCodeException e) {
            try {
                HttpStatusCode status = e.getStatusCode();
                if (status.value() == HttpStatus.NOT_FOUND.value()) {
                    throw new TccUnknownTransactionException("Transaction not found", null);
                }
                if (status.value() == HttpStatus.CONFLICT.value()) {
                    CancelResponse cancelResponse = (CancelResponse)this.objectMapper.readValue(e.getResponseBodyAsString(), CancelResponse.class);
                    throw new TccHeuristicException(cancelResponse.getParticipants(), "Conflict. Participants are in mixed state", null);
                }
                String respString = (String)this.objectMapper.readValue(e.getResponseBodyAsString(), String.class);
                throw new TccException(respString, null);
            }
            catch (JsonProcessingException ex) {
                throw new TccClientException("Error while creating request", e);
            }
        }
        catch (JsonProcessingException e) {
            throw new TccClientException("Error while creating request", e);
        }
    }

    @Override
    public TccTransactionState getTransactionState() throws TccException, TccUnknownTransactionException {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        String txnId = transactionDetails.getTxnId();
        String txnUrl = transactionDetails.getTxnUrl();
        LOGGER.info("get  transaction:{} status", (Object)txnId);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity requestHttpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(txnUrl, HttpMethod.GET, requestHttpEntity, String.class, new Object[0]);
            return (TccTransactionState)this.objectMapper.readValue((String)response.getBody(), TccTransactionState.class);
        }
        catch (HttpStatusCodeException e) {
            try {
                HttpStatusCode status = e.getStatusCode();
                if (status.value() == HttpStatus.NOT_FOUND.value()) {
                    throw new TccUnknownTransactionException("Transaction not found", null);
                }
                String respString = (String)this.objectMapper.readValue(e.getResponseBodyAsString(), String.class);
                throw new TccException(respString, null);
            }
            catch (JsonProcessingException ex) {
                throw new TccClientException("Error while creating request", ex);
            }
        }
        catch (JsonProcessingException e) {
            throw new TccClientException("Error while creating request", e);
        }
    }

    @Override
    public void addTccParticipant(TccParticipant tccParticipants) {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        transactionDetails.addTccParticipant(tccParticipants);
        this.threadLocalStorageService.setTCCTransactionDetails(transactionDetails);
    }

    @Override
    public List<TccParticipant> getTccParticipants() {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        return transactionDetails.getTccParticipants();
    }

    @Override
    public void setTimeLimit(long timeLimit) {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        transactionDetails.setTimeLimit(timeLimit);
        this.threadLocalStorageService.setTCCTransactionDetails(transactionDetails);
    }

    @Override
    public long getTimeLimit() {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        return transactionDetails.getTimeLimit();
    }

    @Override
    public String getTransactionUrl() {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        return transactionDetails.getTransactionUrl();
    }

    @Override
    public String getTransactionId() {
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        return transactionDetails.getTransactionId();
    }
}

