/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.filters;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.tcc.filters.MicroTxTccClientFilter;
import com.oracle.microtx.tcc.filters.MicroTxTccInterceptorService;
import com.oracle.microtx.tcc.pojo.TccParticipantLinks;
import com.oracle.microtx.tcc.pojo.TransactionDetails;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.tmm.tcc.vo.TccParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

public class ClientInterceptorConfig {
    @Autowired
    MicroTxTccClientFilter microTxTccClientInterceptor;
    @Autowired
    MicroTxTccThreadLocalStorageService threadLocalStorageService;
    @Autowired
    MicroTxTccInterceptorService microTxTccInterceptorService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ExchangeFilterFunction filterFunction = (clientRequest, nextFilter) -> {
        this.transactionUtils.setTxIdToThreadLocal(clientRequest);
        ClientRequest.Builder newReqBuilder = ClientRequest.from((ClientRequest)clientRequest);
        if (MicroTxConfig.isPropagateTraceHeadersActive().booleanValue()) {
            this.microTxTccInterceptorService.propagateTraceHeaders(clientRequest, newReqBuilder);
        }
        this.microTxTccInterceptorService.propagateAuthzHeaders(clientRequest, newReqBuilder);
        TransactionDetails transactionDetails = this.threadLocalStorageService.getTCCTransactionDetails();
        if (transactionDetails != null) {
            LOGGER.debug("TccRequestClientFilter with tcc transaction URL: {}", (Object)transactionDetails.getTransactionUrl());
            StringBuilder linkHeaderValue = new StringBuilder();
            MicroTxTccInterceptorService.buildLinkHeader(linkHeaderValue, null, transactionDetails.getTransactionUrl(), "https://otmm.oracle.com/tcc-transaction");
            newReqBuilder.header("Link", new String[]{linkHeaderValue.toString()});
        }
        return nextFilter.exchange(newReqBuilder.build()).doOnNext(clientResponse -> {
            if (transactionDetails != null) {
                LOGGER.debug("TccResponseClientFilter with tcc transaction URL: {}", (Object)transactionDetails.getTransactionUrl());
                List linkHeaderCtxList = clientResponse.headers().header("Link");
                if (linkHeaderCtxList != null) {
                    LOGGER.debug("TccResponseClientFilter with tcc transaction URL: {}", (Object)linkHeaderCtxList);
                }
                List<TccParticipantLinks> participantLinks = this.microTxTccInterceptorService.getParticipantLinks(linkHeaderCtxList);
                for (TccParticipantLinks link : participantLinks) {
                    transactionDetails.addTccParticipant(new TccParticipant(link.getParticipantUri().toString(), link.getTimelimit()));
                }
            }
        });
    };

    @Bean(value={"MicroTxTccRestTemplate"})
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<MicroTxTccClientFilter> interceptors = restTemplate.getInterceptors();
        if (CollectionUtils.isEmpty((Collection)interceptors)) {
            interceptors = new ArrayList<MicroTxTccClientFilter>();
        }
        interceptors.add(this.microTxTccClientInterceptor);
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }

    @Bean(value={"MicroTxTccWebClientBuilder"})
    public WebClient.Builder webClient() {
        return WebClient.builder().filter(this.filterFunction);
    }
}

