/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.filters;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.tcc.filters.MicroTxTccInterceptorService;
import com.oracle.microtx.tcc.pojo.TccParticipantLinks;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import oracle.tmm.tcc.TccCoordintorClient;
import oracle.tmm.tcc.vo.TccParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
public class MicroTxTccClientFilter
implements ClientHttpRequestInterceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MicroTxTccThreadLocalStorageService threadLocalStorageService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    MicroTxTccInterceptorService microTxInterceptorService;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.transactionUtils.setTxIdToThreadLocal(request);
        TccCoordintorClient tccTxn = this.threadLocalStorageService.getTCCTransaction();
        if (MicroTxConfig.isPropagateTraceHeadersActive().booleanValue()) {
            this.microTxInterceptorService.propagateTraceHeaders(request);
        }
        this.microTxInterceptorService.propagateAuthzHeaders(request);
        if (tccTxn != null) {
            LOGGER.debug("TccRequestClientFilter with tcc transaction URL: {}", (Object)tccTxn.getTransactionUrl());
            StringBuilder linkHeaderValue = new StringBuilder();
            MicroTxTccInterceptorService.buildLinkHeader(linkHeaderValue, null, tccTxn.getTransactionUrl(), "https://otmm.oracle.com/tcc-transaction");
            request.getHeaders().add("Link", linkHeaderValue.toString());
        }
        request.getHeaders().add("Content-Type", "application/json");
        ClientHttpResponse response = execution.execute(request, body);
        LOGGER.trace("filter execution response status :{}", (Object)response.getStatusCode());
        LOGGER.debug("Tcc response with tcc transaction URL: {}", (Object)tccTxn.getTransactionUrl());
        List<String> linkHeaderCtxList = response.getHeaders().get((Object)"Link");
        if (linkHeaderCtxList != null) {
            LOGGER.debug("Tcc response  with tcc transaction URL: {}", linkHeaderCtxList);
        } else {
            linkHeaderCtxList = Collections.emptyList();
        }
        List<TccParticipantLinks> participantLinks = this.microTxInterceptorService.getParticipantLinks(linkHeaderCtxList);
        for (TccParticipantLinks link : participantLinks) {
            tccTxn.addTccParticipant(new TccParticipant(link.getParticipantUri().toString(), link.getTimelimit()));
        }
        return response;
    }
}

